/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.util.URLEncoder;

public class B2UploadFileRequest
extends BaseB2Request {
    private final HttpEntity entity;
    private static final String CONTENT_TYPE_VALUE_B2_X_AUTO = "b2/x-auto";

    public B2UploadFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String sha1Checksum, Map<String, String> fileInfo) {
        this(client, b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, sha1Checksum, null, fileInfo);
    }

    public B2UploadFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String sha1Checksum, String mimeType) {
        this(client, b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, sha1Checksum, mimeType, null);
    }

    public B2UploadFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String sha1Checksum) {
        this(client, b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, file, sha1Checksum, null, null);
    }

    public B2UploadFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, File file, String sha1Checksum, String mimeType, Map<String, String> fileInfo) {
        this(client, b2AuthorizeAccountResponse, b2GetUploadUrlResponse, fileName, (HttpEntity)new FileEntity(file), sha1Checksum, mimeType, fileInfo);
    }

    public B2UploadFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, B2GetUploadUrlResponse b2GetUploadUrlResponse, String fileName, HttpEntity entity, String sha1Checksum, String mimeType, Map<String, String> fileInfo) {
        super(client, b2AuthorizeAccountResponse, b2GetUploadUrlResponse.getUploadUrl());
        this.entity = entity;
        if (null != fileInfo) {
            for (String key : fileInfo.keySet()) {
                this.addHeader("X-Bz-Info-" + URLEncoder.encode(key), URLEncoder.encode(fileInfo.get(key)));
            }
        }
        this.addHeader("X-Bz-Content-Sha1", sha1Checksum);
        this.addHeader("Authorization", b2GetUploadUrlResponse.getAuthorizationToken());
        if (null == mimeType) {
            this.addHeader("Content-Type", CONTENT_TYPE_VALUE_B2_X_AUTO);
        } else {
            this.addHeader("Content-Type", mimeType);
        }
        this.addHeader("X-Bz-File-Name", URLEncoder.encode(fileName));
    }

    public B2FileResponse getResponse() throws B2ApiException, IOException {
        return new B2FileResponse(EntityUtils.toString((HttpEntity)this.executePost(this.entity).getEntity()));
    }
}

