/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import java.util.List;

public class CryptoAclPermission
implements AclPermission {
    private final Session<?> session;
    private final AclPermission delegate;
    private final CryptoVault cryptomator;

    public CryptoAclPermission(Session<?> session, AclPermission delegate, CryptoVault cryptomator) {
        this.session = session;
        this.delegate = delegate;
        this.cryptomator = cryptomator;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        return this.delegate.getPermission(this.cryptomator.encrypt(this.session, file));
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        this.delegate.setPermission(this.cryptomator.encrypt(this.session, file), acl);
    }

    public List<Acl.User> getAvailableAclUsers() {
        return this.delegate.getAvailableAclUsers();
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return this.delegate.getAvailableAclRoles(files);
    }

    public Acl getDefault(Local file) {
        return this.delegate.getDefault(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoAclPermission{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

