/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class DAVUploadFeature
extends HttpUploadFeature<String, MessageDigest> {
    private static final Logger log = Logger.getLogger(DAVUploadFeature.class);

    public DAVUploadFeature(Write<String> writer) {
        super(writer);
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            log.warn((Object)"MD5 calculation disabled");
            return super.decorate(in, null);
        }
        return new DigestInputStream(super.decorate(in, (Object)digest), digest);
    }

    protected MessageDigest digest() throws IOException {
        MessageDigest digest = null;
        if (PreferencesFactory.get().getBoolean("webdav.upload.md5")) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, String etag) throws BackgroundException {
        this.verify(file, digest, Checksum.parse((String)etag));
    }
}

