/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVMoveFeature
implements Move {
    private final DAVSession session;

    public DAVMoveFeature(DAVSession session) {
        this.session = session;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            String target = new DefaultUrlProvider(this.session.getHost()).toUrl(renamed).find(DescriptiveUrl.Type.provider).getUrl();
            if (file.isDirectory()) {
                ((DAVClient)((Object)this.session.getClient())).move(new DAVPathEncoder().encode(file), String.format("%s/", target), true);
            } else {
                ((DAVClient)((Object)this.session.getClient())).move(new DAVPathEncoder().encode(file), target, true);
            }
            return renamed;
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

