/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVDirectoryFeature
implements Directory<String> {
    private final DAVSession session;

    public DAVDirectoryFeature(DAVSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            ((DAVClient)((Object)this.session.getClient())).createDirectory(new DAVPathEncoder().encode(folder));
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, folder);
        }
        return folder;
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public DAVDirectoryFeature withWriter(Write<String> writer) {
        return this;
    }
}

