/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TerminalActionFinder;
import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;

public class TerminalOptionsInputValidator {
    private final Console console = new Console();
    private final ProtocolFactory factory;

    public TerminalOptionsInputValidator() {
        this(ProtocolFactory.get());
    }

    public TerminalOptionsInputValidator(ProtocolFactory factory) {
        this.factory = factory;
    }

    public boolean validate(CommandLine input) {
        for (Option o : input.getOptions()) {
            if (-1 == o.getArgs() || o.hasOptionalArg() || o.getArgs() == o.getValuesList().size()) continue;
            this.console.printf("Missing argument for option %s%n", o.getLongOpt());
            return false;
        }
        TerminalAction action = TerminalActionFinder.get(input);
        if (null == action) {
            this.console.printf("%s%n", "Missing argument");
            return false;
        }
        if (input.hasOption(TerminalOptionsBuilder.Params.existing.name())) {
            String arg = input.getOptionValue(TerminalOptionsBuilder.Params.existing.name());
            if (null == TransferAction.forName(arg)) {
                HashSet<TransferAction> actions = new HashSet<TransferAction>(TransferAction.forTransfer(Transfer.Type.download));
                actions.add(TransferAction.cancel);
                this.console.printf("Invalid argument '%s' for option %s. Must be one of %s%n", arg, TerminalOptionsBuilder.Params.existing.name(), Arrays.toString(actions.toArray()));
                return false;
            }
            switch (action) {
                case download: {
                    if (this.validate(arg, Transfer.Type.download)) break;
                    return false;
                }
                case upload: {
                    if (this.validate(arg, Transfer.Type.upload)) break;
                    return false;
                }
                case synchronize: {
                    if (this.validate(arg, Transfer.Type.sync)) break;
                    return false;
                }
                case copy: {
                    if (this.validate(arg, Transfer.Type.copy)) break;
                    return false;
                }
            }
        }
        switch (action) {
            case download: 
            case list: {
                if (this.validate(input.getOptionValue(action.name()))) break;
                return false;
            }
            case upload: 
            case synchronize: 
            case copy: {
                if (this.validate(input.getOptionValue(action.name()))) break;
                return false;
            }
        }
        return true;
    }

    private boolean validate(String arg, Transfer.Type type) {
        List<TransferAction> actions = TransferAction.forTransfer(type);
        if (!actions.contains(TransferAction.forName(arg))) {
            this.console.printf("Invalid argument '%s' for option %s. Must be one of %s%n", arg, TerminalOptionsBuilder.Params.existing.name(), Arrays.toString(actions.toArray()));
            return false;
        }
        return true;
    }

    protected boolean validate(String uri) {
        Protocol protocol;
        if (uri.indexOf("://", 0) != -1 && null == (protocol = this.factory.forName(uri.substring(0, uri.indexOf("://", 0))))) {
            this.console.printf("Missing protocol in URI %s%n", uri);
            return false;
        }
        Host host = new HostParser(this.factory).get(uri);
        switch (host.getProtocol().getType()) {
            case file: 
            case b2: 
            case s3: 
            case googlestorage: 
            case swift: 
            case azure: 
            case googledrive: 
            case dropbox: 
            case onedrive: {
                break;
            }
            default: {
                if (!StringUtils.isBlank((CharSequence)host.getHostname())) break;
                this.console.printf("Missing hostname in URI %s%n", uri);
                return false;
            }
        }
        if (StringUtils.isBlank((CharSequence)host.getDefaultPath())) {
            this.console.printf("Missing path in URI %s%n", uri);
            return false;
        }
        return true;
    }
}

