/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class SwiftQuotaFeature
implements Quota {
    private static final Logger log = Logger.getLogger(SwiftQuotaFeature.class);
    private final SwiftSession session;

    public SwiftQuotaFeature(SwiftSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        long used = 0L;
        try {
            for (Region region : ((Client)this.session.getClient()).getRegions()) {
                long bytes = ((Client)this.session.getClient()).getAccountInfo(region).getBytesUsed();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Add %d used in region %s", bytes, region));
                }
                used += bytes;
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
        return new Quota.Space(Long.valueOf(used), Long.valueOf(Long.MAX_VALUE));
    }
}

