/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import com.joyent.manta.http.MantaHttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;

public class MantaReadFeature
implements Read {
    private final MantaSession session;

    public MantaReadFeature(MantaSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback connectionCallback) throws BackgroundException {
        MantaHttpHeaders headers = new MantaHttpHeaders();
        try {
            try {
                if (status.isAppend()) {
                    HttpRange range = HttpRange.withStatus((TransferStatus)status);
                    headers.setByteRange(Long.valueOf(range.getStart()), range.getEnd() < 0L ? null : Long.valueOf(range.getEnd()));
                }
                return ((MantaClient)this.session.getClient()).getAsInputStream(file.getAbsolute(), headers);
            }
            catch (UnsupportedOperationException e) {
                MantaObjectResponse probablyEmptyFile = ((MantaClient)this.session.getClient()).head(file.getAbsolute());
                if (probablyEmptyFile.getContentLength() != 0L) {
                    throw new AccessDeniedException();
                }
                return new NullInputStream(0L);
            }
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        return true;
    }
}

