/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;

public class MantaMoveFeature
implements Move {
    private final MantaSession session;

    public MantaMoveFeature(MantaSession session) {
        this.session = session;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback deleteCallback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            ((MantaClient)this.session.getClient()).move(file.getAbsolute(), renamed.getAbsolute());
            return renamed;
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot rename {0}", (Throwable)e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return this.session.isUserWritable(target);
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

