/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.collections.Partition;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3VersionIdProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.MultipleDeleteResult;
import org.jets3t.service.model.container.ObjectKeyAndVersion;

public class S3MultipleDeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(S3MultipleDeleteFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3MultipartService multipartService;
    private final Versioning versioningService;

    public S3MultipleDeleteFeature(S3Session session) {
        this(session, new S3DefaultMultipartService(session));
    }

    public S3MultipleDeleteFeature(S3Session session, S3MultipartService multipartService) {
        this.session = session;
        this.multipartService = multipartService;
        this.versioningService = (Versioning)session.getFeature(Versioning.class);
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<ObjectKeyAndVersion> keys;
        Path container;
        HashMap map = new HashMap();
        ArrayList<Path> containers = new ArrayList<Path>();
        for (Path path : files) {
            if (this.containerService.isContainer(path)) {
                containers.add(path);
                continue;
            }
            callback.delete(path);
            if (path.getType().contains(AbstractPath.Type.upload)) {
                try {
                    this.multipartService.delete(new MultipartUpload(path.attributes().getVersionId(), this.containerService.getContainer(path).getName(), this.containerService.getKey(path)));
                }
                catch (NotfoundException ignored) {
                    log.warn((Object)String.format("Ignore failure deleting multipart upload %s", path));
                }
                continue;
            }
            container = this.containerService.getContainer(path);
            keys = new ArrayList<ObjectKeyAndVersion>();
            try {
                keys.add(new ObjectKeyAndVersion(this.containerService.getKey(path), path.isDirectory() ? new S3VersionIdProvider(this.session).getFileid(path, (ListProgressListener)new DisabledListProgressListener()) : null));
            }
            catch (NotfoundException e) {
                if (path.isDirectory()) {
                    log.warn((Object)String.format("Ignore missing placeholder object %s", path));
                }
                throw e;
            }
            if (map.containsKey(container)) {
                ((List)map.get(container)).addAll(keys);
                continue;
            }
            map.put(container, keys);
        }
        for (Map.Entry entry : map.entrySet()) {
            container = (Path)entry.getKey();
            keys = (ArrayList<ObjectKeyAndVersion>)entry.getValue();
            this.delete(container, (List<ObjectKeyAndVersion>)keys, prompt);
        }
        for (Path path : containers) {
            callback.delete(path);
            try {
                String bucket = this.containerService.getContainer(path).getName();
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteBucket(bucket);
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache().removeRegionForBucketName(bucket);
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot delete {0}", e, path);
            }
        }
    }

    public void delete(Path container, List<ObjectKeyAndVersion> keys, PasswordCallback prompt) throws BackgroundException {
        try {
            if (this.versioningService != null && this.versioningService.getConfiguration(container).isMultifactor()) {
                Credentials factor = this.versioningService.getToken(prompt);
                MultipleDeleteResult result = ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteMultipleObjectsWithMFA(container.getName(), keys.toArray(new ObjectKeyAndVersion[keys.size()]), factor.getUsername(), factor.getPassword(), true);
                if (result.hasErrors()) {
                    for (MultipleDeleteResult.ErrorResult error : result.getErrorResults()) {
                        if (StringUtils.equals((CharSequence)"ObjectNotFound", (CharSequence)error.getErrorCode())) continue;
                        ServiceException failure = new ServiceException();
                        failure.setErrorCode(error.getErrorCode());
                        failure.setErrorMessage(error.getMessage());
                        throw new S3ExceptionMappingService().map("Cannot delete {0}", failure, new Path(container, error.getKey(), EnumSet.of(AbstractPath.Type.file)));
                    }
                }
            } else {
                for (List partition : new Partition(keys, PreferencesFactory.get().getInteger("s3.delete.multiple.partition"))) {
                    MultipleDeleteResult result = ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteMultipleObjects(container.getName(), partition.toArray(new ObjectKeyAndVersion[partition.size()]), true);
                    if (!result.hasErrors()) continue;
                    for (MultipleDeleteResult.ErrorResult error : result.getErrorResults()) {
                        if (StringUtils.equals((CharSequence)"ObjectNotFound", (CharSequence)error.getErrorCode())) continue;
                        ServiceException failure = new ServiceException();
                        failure.setErrorCode(error.getErrorCode());
                        failure.setErrorMessage(error.getMessage());
                        throw new S3ExceptionMappingService().map("Cannot delete {0}", failure, new Path(container, error.getKey(), EnumSet.of(AbstractPath.Type.file)));
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot delete {0}", e, container);
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return false;
    }
}

