/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.LifecycleConfig;

public class S3LifecycleConfiguration
implements Lifecycle {
    private static final Logger log = Logger.getLogger(S3LifecycleConfiguration.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();

    public S3LifecycleConfiguration(S3Session session) {
        this.session = session;
    }

    public void setConfiguration(Path file, LifecycleConfiguration configuration) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            if (configuration.getTransition() != null || configuration.getExpiration() != null) {
                LifecycleConfig config = new LifecycleConfig();
                LifecycleConfig.Rule rule = config.newRule(String.format("%s-%s", PreferencesFactory.get().getProperty("application.name"), new AlphanumericRandomStringService().random()), "", Boolean.valueOf(true));
                if (configuration.getTransition() != null) {
                    rule.newTransition().setDays(configuration.getTransition());
                }
                if (configuration.getExpiration() != null) {
                    rule.newExpiration().setDays(configuration.getExpiration());
                }
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).setLifecycleConfig(container.getName(), config);
            } else {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteLifecycleConfig(container.getName());
            }
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
    }

    public LifecycleConfiguration getConfiguration(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return LifecycleConfiguration.empty();
        }
        try {
            LifecycleConfig status = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getLifecycleConfig(container.getName());
            if (null != status) {
                Integer transition = null;
                Integer expiration = null;
                String storageClass = null;
                for (LifecycleConfig.Rule rule : status.getRules()) {
                    if (rule.getTransition() != null) {
                        storageClass = rule.getTransition().getStorageClass();
                        transition = rule.getTransition().getDays();
                    }
                    if (rule.getExpiration() == null) continue;
                    expiration = rule.getExpiration().getDays();
                }
                return new LifecycleConfiguration(transition, storageClass, expiration);
            }
            return LifecycleConfiguration.empty();
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, container);
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn((Object)String.format("Missing permission to read lifecycle configuration for %s %s", container, e.getMessage()));
                return LifecycleConfiguration.empty();
            }
        }
    }
}

