/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;
import org.apache.log4j.Logger;

public class S3FindFeature
implements Find {
    private static final Logger log = Logger.getLogger(S3AttributesFinderFeature.class);
    private final S3Session session;
    private Cache<Path> cache;

    public S3FindFeature(S3Session session) {
        this.session = session;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            new S3AttributesFinderFeature(this.session).withCache(this.cache).find(file);
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
        catch (AccessDeniedException e) {
            return true;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

