/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDeltaItemIterator;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveItemIterator;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.OneDriveThumbnailSetIterator;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveFolder
extends OneDriveItem
implements Iterable<OneDriveItem.Metadata> {
    public OneDriveFolder(OneDriveAPI api, OneDriveResource parent) {
        super(api, parent);
    }

    public OneDriveFolder(OneDriveAPI api, OneDriveResource parent, String resourceIdentifier, OneDriveItem.ItemIdentifierType itemIdentifierType) {
        super(api, parent, resourceIdentifier, itemIdentifierType);
    }

    public Metadata create(String directory) throws IOException {
        OneDriveFolder folder;
        URL url = this.getChildrenURL().build(this.getApi().getBaseURL(), this.getItemIdentifier());
        JsonObject rootObject = new JsonObject();
        rootObject.add("name", directory);
        rootObject.add("folder", (JsonValue)new JsonObject());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST", rootObject);
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        OneDriveFolder oneDriveFolder = folder = new OneDriveFolder(this.getApi(), this, directory, OneDriveItem.ItemIdentifierType.Path);
        oneDriveFolder.getClass();
        Metadata metadata = oneDriveFolder.new Metadata(response.getContent());
        response.close();
        return metadata;
    }

    @Override
    public Metadata getMetadata(OneDriveExpand ... expands) throws IOException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL(), query, this.getItemIdentifier());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return new Metadata(response.getContent());
    }

    public Iterable<OneDriveItem.Metadata> getChildren() {
        return this;
    }

    public Iterable<OneDriveItem.Metadata> getChildren(OneDriveExpand ... expands) {
        return () -> this.iterator(expands);
    }

    @Override
    public Iterator<OneDriveItem.Metadata> iterator() {
        return this.iterator(new OneDriveExpand[0]);
    }

    public Iterator<OneDriveItem.Metadata> iterator(OneDriveExpand ... expands) {
        return this.iterator(200, expands);
    }

    public Iterator<OneDriveItem.Metadata> iterator(int limit, OneDriveExpand ... expands) {
        QueryStringBuilder query = new QueryStringBuilder().set("orderby", "name asc").set("top", limit);
        URL url = this.getChildrenURL().build(this.getApi().getBaseURL(), query, this.getItemIdentifier());
        return new OneDriveItemIterator(this.getApi(), url);
    }

    public Iterable<OneDriveItem.Metadata> search(String search, OneDriveExpand ... expands) {
        URL url = this.getSearchUrl().build(this.getApi().getBaseURL(), this.getItemIdentifier(), search);
        return () -> new OneDriveItemIterator(this.getApi(), url);
    }

    public URLTemplate getSearchUrl() {
        String action = this.getApi().isGraphConnection() ? "search(q='%2$s')" : "oneDrive.search(q='%2$s')";
        return new URLTemplate(this.getActionPath(action));
    }

    public URLTemplate getChildrenURL() {
        return new URLTemplate(this.getActionPath("children"));
    }

    public OneDriveDeltaItemIterator delta() {
        URL url = this.getDeltaUrl().build(this.getApi().getBaseURL(), this.getItemIdentifier());
        return new OneDriveDeltaItemIterator(this.getApi(), url);
    }

    public URLTemplate getDeltaUrl() {
        String action = this.getApi().isGraphConnection() ? "delta" : "oneDrive.delta";
        return new URLTemplate(this.getActionPath(action));
    }

    public OneDriveItemIterator delta(String deltaLink) {
        if (deltaLink == null) {
            return this.delta();
        }
        try {
            URL url = new URL(deltaLink);
            return new OneDriveDeltaItemIterator(this.getApi(), url);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }

    @Override
    public Iterable<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
        if (this.isRoot()) {
            return () -> new OneDriveThumbnailSetIterator(this.getApi());
        }
        return super.getThumbnailSets();
    }

    public class Reference
    extends OneDriveResource.Metadata {
        private String driveId;
        private String path;

        public Reference(JsonObject json) {
            super(json);
        }

        public String getDriveId() {
            return this.driveId;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("driveId".equals(memberName)) {
                    this.driveId = value.asString();
                } else if ("path".equals(memberName)) {
                    this.path = value.asString();
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        @Override
        public OneDriveFolder getResource() {
            return OneDriveFolder.this;
        }
    }

    public class Metadata
    extends OneDriveItem.Metadata {
        private long childCount;

        @Override
        public List<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
            return super.getThumbnailSets();
        }

        public Metadata(JsonObject json) {
            super(json);
        }

        public long getChildCount() {
            return this.childCount;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("folder".equals(memberName)) {
                    Metadata.parseMember(value.asObject(), this::parseChildMember);
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private void parseChildMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("childCount".equals(memberName)) {
                this.childCount = value.asLong();
            }
        }

        @Override
        public OneDriveFolder getResource() {
            return OneDriveFolder.this;
        }

        @Override
        public boolean isFolder() {
            return true;
        }

        @Override
        public Metadata asFolder() {
            return this;
        }
    }
}

