/* Copyright (C) 2003, 2004, 2005, 2006, 2008, 2009 Dean Beeler, Jerome Fisher
 * Copyright (C) 2011-2021 Dean Beeler, Jerome Fisher, Sergey V. Mikayev
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 2.1 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MT32EMU_TVF_H
#define MT32EMU_TVF_H

#include "globals.h"
#include "Types.h"
#include "Structures.h"

namespace MT32Emu {

class LA32Ramp;
class Partial;

class TVF {
private:
	const Partial * const partial;
	LA32Ramp *cutoffModifierRamp;
	const TimbreParam::PartialParam *partialParam;

	uint8_t baseCutoff;
	int keyTimeSubtraction;
	unsigned int levelMult;

	uint8_t target;
	unsigned int phase;

	void startRamp(uint8_t newTarget, uint8_t newIncrement, int newPhase);
	void nextPhase();

public:
	TVF(const Partial *partial, LA32Ramp *cutoffModifierRamp);
	void reset(const TimbreParam::PartialParam *partialParam, uint32_t basePitch);
	// Returns the base cutoff (without envelope modification).
	// The base cutoff is calculated when reset() is called and remains static
	// for the lifetime of the partial.
	// Barring bugs, the number returned is confirmed accurate
	// (based on specs from Mok).
	uint8_t getBaseCutoff() const;
	void handleInterrupt();
	void startDecay();
}; // class TVF

} // namespace MT32Emu

#endif // #ifndef MT32EMU_TVF_H
