/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;

public final class TypeMetadata {
    public static final String TN_BIGINT = "SQL_BIGINT";
    public static final String TN_BINARY = "SQL_BINARY";
    public static final String TN_BIT = "SQL_BIT";
    public static final String TN_BOOLEAN = "BOOLEAN";
    public static final String TN_CHAR = "SQL_CHAR";
    public static final String TN_DATE = "SQL_DATE";
    public static final String TN_DECIMAL = "SQL_DECIMAL";
    public static final String TN_DOUBLE = "SQL_DOUBLE";
    public static final String TN_FLOAT = "SQL_FLOAT";
    public static final String TN_GUID = "SQL_GUID";
    public static final String TN_INTEGER = "SQL_INTEGER";
    public static final String TN_INTERVAL_DAY = "SQL_INTERVAL_DAY";
    public static final String TN_INTERVAL_DAY_TO_HOUR = "SQL_INTERVAL_DAY_TO_HOUR";
    public static final String TN_INTERVAL_DAY_TO_MINUTE = "SQL_INTERVAL_DAY_TO_MINUTE";
    public static final String TN_INTERVAL_DAY_TO_SECOND = "SQL_INTERVAL_DAY_TO_SECOND";
    public static final String TN_INTERVAL_HOUR = "SQL_INTERVAL_HOUR";
    public static final String TN_INTERVAL_HOUR_TO_MINUTE = "SQL_INTERVAL_HOUR_TO_MINUTE";
    public static final String TN_INTERVAL_HOUR_TO_SECOND = "SQL_INTERVAL_HOUR_TO_SECOND";
    public static final String TN_INTERVAL_MINUTE = "SQL_INTERVAL_MINUTE";
    public static final String TN_INTERVAL_MINUTE_TO_SECOND = "SQL_INTERVAL_MINUTE_TO_SECOND";
    public static final String TN_INTERVAL_MONTH = "SQL_INTERVAL_MONTH";
    public static final String TN_INTERVAL_SECOND = "SQL_INTERVAL_SECOND";
    public static final String TN_INTERVAL_YEAR = "SQL_INTERVAL_YEAR";
    public static final String TN_INTERVAL_YEAR_TO_MONTH = "SQL_INTERVAL_YEAR_TO_MONTH";
    public static final String TN_LONGVARBINARY = "SQL_LONGVARBINARY";
    public static final String TN_LONGVARCHAR = "SQL_LONGVARCHAR";
    public static final String TN_NUMERIC = "SQL_NUMERIC";
    public static final String TN_REAL = "SQL_REAL";
    public static final String TN_SMALLINT = "SQL_SMALLINT";
    public static final String TN_TIME = "SQL_TIME";
    public static final String TN_TIMESTAMP = "SQL_TIMESTAMP";
    public static final String TN_TINYINT = "SQL_TINYINT";
    public static final String TN_TYPE_DATE = "SQL_TYPE_DATE";
    public static final String TN_TYPE_TIME = "SQL_TYPE_TIME";
    public static final String TN_TYPE_TIMESTAMP = "SQL_TYPE_TIMESTAMP";
    public static final String TN_VARBINARY = "SQL_VARBINARY";
    public static final String TN_VARCHAR = "SQL_VARCHAR";
    public static final String TN_WCHAR = "SQL_WCHAR";
    public static final String TN_WLONGVARCHAR = "SQL_WLONGVARCHAR";
    public static final String TN_WVARCHAR = "SQL_WVARCHAR";
    private short m_type;
    private String m_typeName;
    private short m_scale;
    private short m_precision;
    private int m_intervalPrecision;
    private boolean m_isSigned;
    private boolean m_isApproximateNumericType;
    private boolean m_isBinaryType;
    private boolean m_isCharacterType;
    private boolean m_isExactNumericType;
    private boolean m_isIntegerType;
    private boolean m_isIntervalType;

    public static TypeMetadata createTypeMetadata(int n) throws ErrorException {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return TypeMetadata.createTypeMetadata(n, true);
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return TypeMetadata.createTypeMetadata(n, false);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public static TypeMetadata createTypeMetadata(int n, boolean bl) throws ErrorException {
        switch (n) {
            case -5: {
                return new TypeMetadata((short)n, TN_BIGINT, 19, 0, 19, bl);
            }
            case -2: {
                return new TypeMetadata((short)n, TN_BINARY, 1, 0, 1, bl);
            }
            case -7: {
                return new TypeMetadata((short)n, TN_BIT, 1, 0, 0, bl);
            }
            case 16: {
                return new TypeMetadata((short)n, TN_BOOLEAN, 1, 0, 0, bl);
            }
            case 1: {
                return new TypeMetadata((short)n, TN_CHAR, 1, 0, 1, bl);
            }
            case 3: {
                return new TypeMetadata((short)n, TN_DECIMAL, 38, 0, 38, bl);
            }
            case 8: {
                return new TypeMetadata((short)n, TN_DOUBLE, 15, 0, 53, bl);
            }
            case 6: {
                return new TypeMetadata((short)n, TN_FLOAT, 15, 0, 53, bl);
            }
            case -11: {
                return new TypeMetadata((short)n, TN_GUID, 36, 0, 36, bl);
            }
            case 4: {
                return new TypeMetadata((short)n, TN_INTEGER, 10, 0, 0, bl);
            }
            case -4: {
                return new TypeMetadata((short)n, TN_LONGVARBINARY, 1, 0, 1, bl);
            }
            case -1: {
                return new TypeMetadata((short)n, TN_LONGVARCHAR, 1, 0, 1, bl);
            }
            case 2: {
                return new TypeMetadata((short)n, TN_NUMERIC, 38, 0, 38, bl);
            }
            case 7: {
                return new TypeMetadata((short)n, TN_REAL, 7, 0, 24, bl);
            }
            case 5: {
                return new TypeMetadata((short)n, TN_SMALLINT, 5, 0, 5, bl);
            }
            case -6: {
                return new TypeMetadata((short)n, TN_TINYINT, 3, 0, 3, bl);
            }
            case 91: {
                return new TypeMetadata((short)n, TN_TYPE_DATE, 0, 0, 10, bl);
            }
            case 92: {
                return new TypeMetadata((short)n, TN_TYPE_TIME, 0, 0, 8, bl);
            }
            case 93: {
                return new TypeMetadata((short)n, TN_TYPE_TIMESTAMP, 6, 6, 0, bl);
            }
            case -3: {
                return new TypeMetadata((short)n, TN_VARBINARY, 1, 0, 1, bl);
            }
            case 12: {
                return new TypeMetadata((short)n, TN_VARCHAR, 1, 0, 1, bl);
            }
            case 103: {
                return new TypeMetadata((short)n, TN_INTERVAL_DAY, 0, 0, 2, bl);
            }
            case 108: {
                return new TypeMetadata((short)n, TN_INTERVAL_DAY_TO_HOUR, 0, 0, 2, bl);
            }
            case 109: {
                return new TypeMetadata((short)n, TN_INTERVAL_DAY_TO_MINUTE, 0, 0, 2, bl);
            }
            case 110: {
                return new TypeMetadata((short)n, TN_INTERVAL_DAY_TO_SECOND, 6, 6, 2, bl);
            }
            case 104: {
                return new TypeMetadata((short)n, TN_INTERVAL_HOUR, 0, 0, 2, bl);
            }
            case 111: {
                return new TypeMetadata((short)n, TN_INTERVAL_HOUR_TO_MINUTE, 0, 0, 2, bl);
            }
            case 112: {
                return new TypeMetadata((short)n, TN_INTERVAL_HOUR_TO_SECOND, 6, 6, 2, bl);
            }
            case 105: {
                return new TypeMetadata((short)n, TN_INTERVAL_MINUTE, 0, 0, 2, bl);
            }
            case 113: {
                return new TypeMetadata((short)n, TN_INTERVAL_MINUTE_TO_SECOND, 6, 6, 2, bl);
            }
            case 102: {
                return new TypeMetadata((short)n, TN_INTERVAL_MONTH, 0, 0, 2, bl);
            }
            case 106: {
                return new TypeMetadata((short)n, TN_INTERVAL_SECOND, 6, 6, 2, bl);
            }
            case 101: {
                return new TypeMetadata((short)n, TN_INTERVAL_YEAR, 0, 0, 2, bl);
            }
            case 107: {
                return new TypeMetadata((short)n, TN_INTERVAL_YEAR_TO_MONTH, 0, 0, 2, bl);
            }
            case -8: {
                return new TypeMetadata((short)n, TN_WCHAR, 0, 0, 0, bl);
            }
            case -10: {
                return new TypeMetadata((short)n, TN_WLONGVARCHAR, 0, 0, 0, bl);
            }
            case -9: {
                return new TypeMetadata((short)n, TN_WVARCHAR, 0, 0, 0, bl);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
    }

    public TypeMetadata(short s, String string, short s2, short s3, int n) {
        this(s, string, s2, s3, n, false);
    }

    public TypeMetadata(short s, String string, short s2, short s3, int n, boolean bl) {
        this.m_type = s;
        this.m_typeName = string;
        this.m_precision = s2;
        this.m_scale = s3;
        this.m_intervalPrecision = n;
        this.m_isSigned = bl;
        this.m_isApproximateNumericType = TypeUtilities.isApproximateNumericType(this.m_type);
        this.m_isBinaryType = TypeUtilities.isBinaryType(this.m_type);
        this.m_isCharacterType = TypeUtilities.isCharacterType(this.m_type);
        this.m_isExactNumericType = TypeUtilities.isExactNumericType(this.m_type);
        this.m_isIntegerType = TypeUtilities.isIntegerType(this.m_type);
        this.m_isIntervalType = TypeUtilities.isIntervalType(this.m_type);
    }

    public int getIntervalPrecision() {
        return this.m_intervalPrecision;
    }

    public short getPrecision() {
        return this.m_precision;
    }

    public short getScale() {
        return this.m_scale;
    }

    public short getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isApproximateNumericType() {
        return this.m_isApproximateNumericType;
    }

    public boolean isBinaryType() {
        return this.m_isBinaryType;
    }

    public boolean isCharacterOrBinaryType() {
        return this.m_isCharacterType || this.m_isBinaryType;
    }

    public boolean isCharacterType() {
        return this.m_isCharacterType;
    }

    public boolean isExactNumericType() {
        return this.m_isExactNumericType;
    }

    public boolean isIntegerType() {
        return this.m_isIntegerType;
    }

    public boolean isIntervalType() {
        return this.m_isIntervalType;
    }

    public boolean isSigned() {
        return this.m_isSigned;
    }

    public void setIntervalPrecision(int n) {
        this.m_intervalPrecision = n;
    }

    public void setPrecision(short s) {
        this.m_precision = s;
    }

    public void setScale(short s) {
        this.m_scale = s;
    }

    public void setSigned(boolean bl) {
        this.m_isSigned = bl;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }
}

