/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.VConnection;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.core.VDriver;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.security.TLSMode;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VConnectionPropertyKey {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String LOG_LEVEL = "loglevel";
    public static final String LOG_PATH = "logpath";
    public static final String LOG_NAMESPACE = "lognamespace";
    public static final String SSL = "ssl";
    public static final String TLSMODE = "tlsmode";
    public static final String SSL_SOCKET_FACTORY_NAME = "sslsocketfactoryname";
    public static final String HOST_NAME_VERIFIER = "hostnameverifier";
    public static final String KEYSTORE_PATH = "keystorepath";
    public static final String KEYSTORE_PASSWORD = "keystorepassword";
    public static final String TRUSTSTORE_PATH = "truststorepath";
    public static final String TRUSTSTORE_PASSWORD = "truststorepassword";
    public static final String LOCALE = "locale";
    public static final String LOGIN_TIMEOUT = "logintimeout";
    public static final String SOCKET_FACTORY_NAME = "socketfactoryname";
    public static final String HOST = "host";
    public static final String DATABASE = "database";
    public static final String PORT = "port";
    public static final String READ_ONLY = "readonly";
    public static final String SESSION_LABEL = "sessionlabel";
    public static final String RESULT_BUFFER_SIZE = "resultbuffersize";
    public static final String THREE_PART_NAMING = "threepartnaming";
    public static final String TRANSACTION_ISOLATION = "transactionisolation";
    public static final String BI_DIRECT = "directbatchinsert";
    public static final String BI_STRING = "stringbatchinsert";
    public static final String AUTOCOMMIT = "autocommit";
    public static final String SEARCH_PATH = "searchpath";
    public static final String CONN_SETTINGS = "connsettings";
    public static final String STRICT_CATALOG_FILTERING = "strictcatalogfiltering";
    public static final String ADD_TZ_TO_TIMESTAMP_PARAMETERS = "addtztotimestampparameters";
    public static final String BACKUP_SERVER_NODE = "backupservernode";
    public static final String CONNECTON_LOAD_BALANCE = "connectionloadbalance";
    public static final String JAAS_CONFIG_NAME = "jaasconfigname";
    public static final String KRB_SERVICE_NAME = "kerberosservicename";
    public static final String KRB_HOST_NAME = "kerberoshostname";
    public static final String STREAMING_BATCH_INSERT = "streamingbatchinsert";
    public static final String DISABLE_COPY_LOCAL = "disablecopylocal";
    public static final String NETWORK_BUFFER_SIZE = "networkbuffersize";
    public static final String ENABLE_ROUTABLE_QUERIES = "enableroutablequeries";
    public static final String FAIL_ON_MULTINODE_PLANS = "failonmultinodeplans";
    public static final String MAX_POOLED_CONNECTIONS = "maxpooledconnections";
    public static final String MAX_POOLED_CONNECTIONS_PER_NODE = "maxpooledconnectionspernode";
    public static final String METADATA_CACHE_LIFETIME = "metadatacachelifetime";
    public static final String NODE_DOWN_WAIT_TIME = "nodedownwaittime";
    public static final String MAX_POOLED_CONNECTION_USES = "maxpooledconnectionuses";
    public static final String SIMPLE_QUERIES_ONLY = "simplequeriesonly";
    public static final String PREFERRED_ADDRESS_FAMILY = "preferredaddressfamily";
    public static final String MULTIPLE_ACTIVE_RESULT_SETS = "mars";
    public static final String PROTOCOL = "protocol";
    private static final HashSet<String> legalKeys = new HashSet();
    private static final HashMap<String, String> keyAliases = new HashMap();
    private static final HashMap<String, HashSet<String>> legalValues = new HashMap();
    private static final HashMap<String, HashMap<String, String>> valueAliases = new HashMap();
    private static final HashMap<String, Object> defaultValues = new HashMap();
    private static final HashMap<String, String> propertyDescriptions = new HashMap();
    private static HashSet<String> BOOL_VALUES;
    private static HashMap<String, String> BOOL_ALIASES;

    public static boolean addProperty(Properties properties, String string, Object object) {
        boolean bl = false;
        if (string == null || object == null) {
            return false;
        }
        String[] stringArray = VConnectionPropertyKey.translateSetting(string, object);
        if (stringArray[0] != null && stringArray[1] != null) {
            bl = true;
            properties.put(stringArray[0], stringArray[1]);
        }
        return bl;
    }

    public static String[] translateSetting(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = null;
        if (keyAliases.containsKey(string2)) {
            string2 = keyAliases.get(string2);
        }
        if (legalKeys.contains(string2)) {
            if (legalValues.containsKey(string2)) {
                HashSet<String> hashSet;
                String string4 = object == null ? null : object.toString().toLowerCase();
                HashMap<String, String> hashMap = valueAliases.get(string2);
                if (hashMap != null && hashMap.containsKey(string4)) {
                    string4 = hashMap.get(string4);
                }
                string3 = (hashSet = legalValues.get(string2)).contains(string4) ? string4 : null;
            } else {
                string3 = object == null ? null : object.toString();
            }
        } else {
            string2 = null;
        }
        return new String[]{string2, string3};
    }

    public static String translatePropertyKey(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (legalKeys.contains(string2)) {
            return string2;
        }
        return keyAliases.get(string2);
    }

    public static boolean parseSubName(String string, Properties properties) {
        boolean bl = true;
        try {
            Properties properties2;
            block14: {
                String[] stringArray;
                properties2 = new Properties();
                for (Map.Entry<Object, Object> object : properties.entrySet()) {
                    stringArray = object.getKey().toString();
                    String[] stringArray2 = object.getValue();
                    String string2 = stringArray2 == null ? null : stringArray2.toString();
                    VConnectionPropertyKey.addProperty(properties2, (String)stringArray, string2);
                }
                try {
                    String string3;
                    int n;
                    Iterator<Object> iterator = new URL("http:" + string);
                    if (!properties2.containsKey(DATABASE)) {
                        String n2 = ((URL)((Object)iterator)).getPath().substring(1);
                        bl &= n2.indexOf("/") == -1;
                        properties2.put(DATABASE, n2);
                    }
                    if (!properties2.containsKey(HOST)) {
                        String string4 = ((URL)((Object)iterator)).getHost();
                        properties2.put(HOST, string4);
                    }
                    if (!properties2.containsKey(PORT) && (n = ((URL)((Object)iterator)).getPort()) != -1) {
                        properties2.put(PORT, String.valueOf(n));
                    }
                    if ((string3 = ((URL)((Object)iterator)).getQuery()) == null) break block14;
                    try {
                        for (String string5 : stringArray = string3.split("&")) {
                            String[] stringArray3 = string5.split("=");
                            if (stringArray3.length != 2) continue;
                            String string6 = URLDecoder.decode(stringArray3[0], VConnection.VERTICA_CHARSET);
                            String string7 = URLDecoder.decode(stringArray3[1], VConnection.VERTICA_CHARSET);
                            VConnectionPropertyKey.addProperty(properties2, string6, string7);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!properties2.containsKey(PASSWORD)) {
                properties2.put(PASSWORD, "");
            }
            if (bl) {
                properties.clear();
                for (Object object : properties2.keySet()) {
                    properties.put(object, properties2.get(object));
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static ArrayList<Variant> getLegalValueVariants(String string) {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        HashSet<String> hashSet = legalValues.get(string = VConnectionPropertyKey.translatePropertyKey(string));
        if (hashSet == null) {
            return null;
        }
        for (String string2 : hashSet) {
            try {
                arrayList.add(new Variant(0, string2));
            }
            catch (UtilsException utilsException) {
                assert (false);
            }
        }
        return arrayList;
    }

    public static HashSet<String> getLegalValueSet(String string) {
        string = VConnectionPropertyKey.translatePropertyKey(string);
        HashSet<String> hashSet = legalValues.get(string);
        return hashSet;
    }

    public static String getProperyDescription(String string) {
        if ((string = VConnectionPropertyKey.translatePropertyKey(string)) == null) {
            return "";
        }
        return propertyDescriptions.get(string);
    }

    private static void addBooleanParameter(String string) {
        legalKeys.add(string);
        legalValues.put(string, BOOL_VALUES);
        valueAliases.put(string, BOOL_ALIASES);
    }

    private VConnectionPropertyKey() {
    }

    static {
        defaultValues.put(AUTOCOMMIT, true);
        defaultValues.put(BI_DIRECT, false);
        defaultValues.put(BI_STRING, true);
        defaultValues.put(LOCALE, "en_US@collation=binary");
        defaultValues.put(LOG_LEVEL, (Object)VConnectionPropertyValue.DEFAULT_LOG_LEVEL);
        defaultValues.put(LOG_PATH, "");
        defaultValues.put(LOG_NAMESPACE, "com.vertica");
        defaultValues.put(LOGIN_TIMEOUT, 0);
        defaultValues.put(SOCKET_FACTORY_NAME, "");
        defaultValues.put(RESULT_BUFFER_SIZE, 8192);
        defaultValues.put(READ_ONLY, false);
        defaultValues.put(PORT, 5433);
        defaultValues.put(TLSMODE, (Object)VConnectionPropertyValue.DEFAULT_TLSMODE);
        defaultValues.put(HOST_NAME_VERIFIER, VConnectionPropertyValue.DEFAULT_HOST_NAME_VERIFIER);
        defaultValues.put(SSL_SOCKET_FACTORY_NAME, "");
        defaultValues.put(KEYSTORE_PATH, "");
        defaultValues.put(KEYSTORE_PASSWORD, "");
        defaultValues.put(TRUSTSTORE_PATH, "");
        defaultValues.put(TRUSTSTORE_PASSWORD, "");
        defaultValues.put(THREE_PART_NAMING, true);
        defaultValues.put(TRANSACTION_ISOLATION, 2);
        defaultValues.put(SEARCH_PATH, "");
        defaultValues.put(CONN_SETTINGS, "");
        defaultValues.put(STRICT_CATALOG_FILTERING, false);
        defaultValues.put(ADD_TZ_TO_TIMESTAMP_PARAMETERS, false);
        defaultValues.put(BACKUP_SERVER_NODE, "");
        defaultValues.put(CONNECTON_LOAD_BALANCE, false);
        defaultValues.put(JAAS_CONFIG_NAME, "verticajdbc");
        defaultValues.put(KRB_SERVICE_NAME, "vertica");
        defaultValues.put(KRB_HOST_NAME, "");
        defaultValues.put(STREAMING_BATCH_INSERT, false);
        defaultValues.put(DISABLE_COPY_LOCAL, false);
        defaultValues.put(NETWORK_BUFFER_SIZE, 8192);
        defaultValues.put(ENABLE_ROUTABLE_QUERIES, false);
        defaultValues.put(FAIL_ON_MULTINODE_PLANS, true);
        defaultValues.put(MAX_POOLED_CONNECTIONS, 20);
        defaultValues.put(MAX_POOLED_CONNECTIONS_PER_NODE, 5);
        defaultValues.put(METADATA_CACHE_LIFETIME, 300);
        defaultValues.put(NODE_DOWN_WAIT_TIME, 60);
        defaultValues.put(MAX_POOLED_CONNECTION_USES, 1000);
        defaultValues.put(SIMPLE_QUERIES_ONLY, false);
        defaultValues.put(PREFERRED_ADDRESS_FAMILY, (Object)VConnectionPropertyValue.DEFAULT_PREFERRED_ADDRESS_FAMILY);
        defaultValues.put(MULTIPLE_ACTIVE_RESULT_SETS, false);
        defaultValues.put(PROTOCOL, "3.5");
        legalKeys.add(LOG_PATH);
        legalKeys.add(LOCALE);
        legalKeys.add(LOGIN_TIMEOUT);
        legalKeys.add(KEYSTORE_PATH);
        legalKeys.add(KEYSTORE_PASSWORD);
        legalKeys.add(TRUSTSTORE_PATH);
        legalKeys.add(TRUSTSTORE_PASSWORD);
        legalKeys.add(SSL_SOCKET_FACTORY_NAME);
        legalKeys.add(TLSMODE);
        legalValues.put(TLSMODE, new HashSet<String>(TLSMode.stringValues()));
        keyAliases.put("sslmode", TLSMODE);
        legalKeys.add(HOST_NAME_VERIFIER);
        legalKeys.add(SOCKET_FACTORY_NAME);
        legalKeys.add(DATABASE);
        legalKeys.add(SEARCH_PATH);
        keyAliases.put("search_path", SEARCH_PATH);
        legalKeys.add(CONN_SETTINGS);
        keyAliases.put("connectsql", CONN_SETTINGS);
        keyAliases.put("conn_settings", CONN_SETTINGS);
        legalKeys.add(HOST);
        keyAliases.put("server", HOST);
        keyAliases.put("hostname", HOST);
        legalKeys.add(PORT);
        legalKeys.add(USER);
        keyAliases.put("uid", USER);
        keyAliases.put("username", USER);
        legalKeys.add(PASSWORD);
        keyAliases.put("pwd", PASSWORD);
        legalKeys.add(RESULT_BUFFER_SIZE);
        keyAliases.put("maxmemorycache", RESULT_BUFFER_SIZE);
        keyAliases.put("maxlrsmemory", RESULT_BUFFER_SIZE);
        legalKeys.add(SESSION_LABEL);
        keyAliases.put("label", SESSION_LABEL);
        legalKeys.add(JAAS_CONFIG_NAME);
        legalKeys.add(KRB_SERVICE_NAME);
        legalKeys.add(KRB_HOST_NAME);
        legalKeys.add(BACKUP_SERVER_NODE);
        legalKeys.add(NETWORK_BUFFER_SIZE);
        legalKeys.add(MAX_POOLED_CONNECTIONS);
        legalKeys.add(MAX_POOLED_CONNECTIONS_PER_NODE);
        legalKeys.add(MAX_POOLED_CONNECTION_USES);
        legalKeys.add(METADATA_CACHE_LIFETIME);
        legalKeys.add(NODE_DOWN_WAIT_TIME);
        BOOL_VALUES = new HashSet<String>(Arrays.asList("true", "false"));
        BOOL_ALIASES = new HashMap();
        BOOL_ALIASES.put("no", "false");
        BOOL_ALIASES.put("0", "false");
        BOOL_ALIASES.put("off", "false");
        BOOL_ALIASES.put("yes", "true");
        BOOL_ALIASES.put("on", "true");
        BOOL_ALIASES.put("1", "true");
        VConnectionPropertyKey.addBooleanParameter(SSL);
        VConnectionPropertyKey.addBooleanParameter(THREE_PART_NAMING);
        VConnectionPropertyKey.addBooleanParameter(READ_ONLY);
        VConnectionPropertyKey.addBooleanParameter(STRICT_CATALOG_FILTERING);
        VConnectionPropertyKey.addBooleanParameter(ADD_TZ_TO_TIMESTAMP_PARAMETERS);
        VConnectionPropertyKey.addBooleanParameter(CONNECTON_LOAD_BALANCE);
        VConnectionPropertyKey.addBooleanParameter(ENABLE_ROUTABLE_QUERIES);
        VConnectionPropertyKey.addBooleanParameter(FAIL_ON_MULTINODE_PLANS);
        VConnectionPropertyKey.addBooleanParameter(STREAMING_BATCH_INSERT);
        VConnectionPropertyKey.addBooleanParameter(DISABLE_COPY_LOCAL);
        VConnectionPropertyKey.addBooleanParameter(SIMPLE_QUERIES_ONLY);
        VConnectionPropertyKey.addBooleanParameter(MULTIPLE_ACTIVE_RESULT_SETS);
        keyAliases.put("multipleactiveresultsets", MULTIPLE_ACTIVE_RESULT_SETS);
        VConnectionPropertyKey.addBooleanParameter(BI_DIRECT);
        keyAliases.put("batchinsertdirect", BI_DIRECT);
        VConnectionPropertyKey.addBooleanParameter(BI_STRING);
        keyAliases.put("batchinsertstring", BI_STRING);
        VConnectionPropertyKey.addBooleanParameter(AUTOCOMMIT);
        keyAliases.put("defaultautocommit", AUTOCOMMIT);
        legalKeys.add(LOG_LEVEL);
        legalValues.put(LOG_LEVEL, new HashSet<String>(Arrays.asList("off", "error", "warning", "info", "debug", "trace")));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("0", "off");
        hashMap.put("1", "error");
        hashMap.put("2", "warning");
        hashMap.put("3", "info");
        hashMap.put("4", "debug");
        hashMap.put("5", "trace");
        valueAliases.put(LOG_LEVEL, hashMap);
        legalKeys.add(LOG_NAMESPACE);
        keyAliases.put("logpackage", LOG_NAMESPACE);
        keyAliases.put("logcomponent", LOG_NAMESPACE);
        hashMap = new HashMap();
        hashMap.put(PROTOCOL, "com.vertica.io");
        hashMap.put("io", "com.vertica.io");
        hashMap.put("connection", "com.vertica.core");
        hashMap.put("jdbc", "com.vertica.jdbc");
        hashMap.put("kv", "com.vertica.jdbc.kv");
        hashMap.put("all", "com.vertica");
        valueAliases.put(LOG_NAMESPACE, hashMap);
        legalKeys.add(TRANSACTION_ISOLATION);
        keyAliases.put("isolationlevel", TRANSACTION_ISOLATION);
        legalValues.put(TRANSACTION_ISOLATION, new HashSet<String>(Arrays.asList("2", "8", "0")));
        hashMap = new HashMap();
        hashMap.put("read_commited", "2");
        hashMap.put("serverdefault", "0");
        hashMap.put("server_default", "0");
        hashMap.put("serializable", "8");
        valueAliases.put(TRANSACTION_ISOLATION, hashMap);
        legalKeys.add(PREFERRED_ADDRESS_FAMILY);
        HashSet<String> hashSet = new HashSet<String>();
        for (VConnectionPropertyValue.AddressFamilyPreference addressFamilyPreference : VConnectionPropertyValue.AddressFamilyPreference.values()) {
            hashSet.add(addressFamilyPreference.toString().toLowerCase());
        }
        legalValues.put(PREFERRED_ADDRESS_FAMILY, hashSet);
        legalKeys.add(PROTOCOL);
        propertyDescriptions.put(USER, "The user to connect as");
        propertyDescriptions.put(PASSWORD, "The user's password");
        propertyDescriptions.put(LOG_LEVEL, "The amount of detail to include in log messages");
        propertyDescriptions.put(LOG_PATH, "The directory to store the log file in");
        propertyDescriptions.put(LOG_NAMESPACE, "A package name to restrict logging to");
        propertyDescriptions.put(SSL, "If true, connect using SSL/TLS. Deprecated; use tlsmode=verify-ca to have the same effect as ssl=true");
        propertyDescriptions.put(TLSMODE, "Controls how the driver performs TLS and certificate verification when establishing a connection. Supported values are disable, require, verify-ca and verify-full");
        propertyDescriptions.put(KEYSTORE_PATH, "A path to a JKS file containing client certificates and keys to be used when performing SSL/TLS");
        propertyDescriptions.put(KEYSTORE_PASSWORD, "The password for the keystore file; only used if keystorepath is set");
        propertyDescriptions.put(TRUSTSTORE_PATH, "A path to a JKS file containing trusted certificate authorities to be used when performing SSL/TLS");
        propertyDescriptions.put(TRUSTSTORE_PASSWORD, "The password for the truststore JKS file; only used if truststorepath is set");
        propertyDescriptions.put(HOST_NAME_VERIFIER, "user define hostname verifer to replace default one");
        propertyDescriptions.put(SSL_SOCKET_FACTORY_NAME, "The name of a javax.net.ssl.SSLSocketFactory class to use when performing SSL/TLS");
        propertyDescriptions.put(SOCKET_FACTORY_NAME, "The name of a javax.net.SocketFactory class to use when creating sockets");
        propertyDescriptions.put(LOCALE, "The ICU locale to use for this session");
        propertyDescriptions.put(LOGIN_TIMEOUT, "The amount of time to spend establishing a connection before giving up");
        propertyDescriptions.put(HOST, "The IP address or host name of the " + VDriver.SERVER_PRODUCT_NAME + " server");
        propertyDescriptions.put(DATABASE, "The name of the database to connect to");
        propertyDescriptions.put(READ_ONLY, "If true, commands that modify the database in any way will result in an error");
        propertyDescriptions.put(PORT, "The port to connect to on the host");
        propertyDescriptions.put(SESSION_LABEL, "A string to identify the JDBC connection's session on the server");
        propertyDescriptions.put(RESULT_BUFFER_SIZE, "The size in bytes of the client side result cache (one per ResultSet)");
        propertyDescriptions.put(THREE_PART_NAMING, "If true, use the database name as the catalog name when reporting metadata");
        propertyDescriptions.put(TRANSACTION_ISOLATION, "The default transaction isolation level to use");
        propertyDescriptions.put(BI_DIRECT, "If true, batch insert data is written directly to the ROS");
        propertyDescriptions.put(AUTOCOMMIT, "If false, the connection will start with autocommit disabled");
        propertyDescriptions.put(SEARCH_PATH, "A comma separated list of schema names to search when looking up unqualified object references");
        propertyDescriptions.put(CONN_SETTINGS, "SQL to run after a connection is established to change session properties on the server");
        propertyDescriptions.put(STRICT_CATALOG_FILTERING, "If false, DatabaseMetaData methods that take a catalog argument will treat the empty string as if it were null");
        propertyDescriptions.put(ADD_TZ_TO_TIMESTAMP_PARAMETERS, "If true, Timestamp parameters bound with PreparedStatement.setTimestamp(int, Timestamp, Calendar) will include the Calendar's time zone in the value sent to the server, so that they may map more accurately to TimestampTz columns");
        propertyDescriptions.put(BACKUP_SERVER_NODE, "A comma separated list of host:port pairs to use if primary server is unavailable");
        propertyDescriptions.put(CONNECTON_LOAD_BALANCE, "If true, use native load balancing");
        propertyDescriptions.put(JAAS_CONFIG_NAME, "The name of a JAAS configuration that the driver should use when performing GSS authentication");
        propertyDescriptions.put(KRB_SERVICE_NAME, "The service name portion of the kerberos service principal that identifies the Vertica server");
        propertyDescriptions.put(KRB_HOST_NAME, "The host name portion of the kerberos service principal that identifies the Vertica server");
        propertyDescriptions.put(STREAMING_BATCH_INSERT, "If true, send PreparedStatement batch insert data to the server as it arrives via addBatch() instead of holding in memory until executeBatch(). Streaming is faster and uses less memory, but while a streaming batch insert is in progress PreparedStatement.clearBatch() is disabled and other connection operations are not allowed");
        propertyDescriptions.put(DISABLE_COPY_LOCAL, "If true, file-based COPY LOCAL will be disabled");
        propertyDescriptions.put(NETWORK_BUFFER_SIZE, "Size of data to buffer before sending network messages to the server");
        propertyDescriptions.put(ENABLE_ROUTABLE_QUERIES, "If true, connections returned will implement VerticaRoutableConnection and provide access to the VGet API");
        propertyDescriptions.put(FAIL_ON_MULTINODE_PLANS, "If true, VGet operations that require more than a single node's resources are disallowed");
        propertyDescriptions.put(MAX_POOLED_CONNECTIONS, "The maximum number of connections allowed in the VerticaRoutableConnection's connection pool");
        propertyDescriptions.put(MAX_POOLED_CONNECTIONS_PER_NODE, "The maximum number of connections allowed to a single node in the VerticaRoutableConnection's connection pool");
        propertyDescriptions.put(MAX_POOLED_CONNECTION_USES, "The maximum number of times to use a pooled connection before closing it");
        propertyDescriptions.put(NODE_DOWN_WAIT_TIME, "Time in seconds to wait before attemptng a new connection to a node after a connection failure occurs");
        propertyDescriptions.put(METADATA_CACHE_LIFETIME, "Time in seconds to cache table and projection metadata used during VGet operations");
        propertyDescriptions.put(PREFERRED_ADDRESS_FAMILY, "The address family type to prefer when resolving hostnames");
        propertyDescriptions.put(MULTIPLE_ACTIVE_RESULT_SETS, "If true, server may cache query result sets, so client can have multiple open result sets on the same connection");
        propertyDescriptions.put(PROTOCOL, "The base protocol version number passed for backward compatibility purposes");
    }
}

