/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AbstractEXAConnection;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NotImplemented;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Properties;
import java.util.Vector;

public class EXAConnection
extends AbstractEXAConnection {
    protected int defaultHoldability = 1;

    public EXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties) throws SQLException {
        super(string, n, string2, string3, debugLog, properties, null);
    }

    public EXAConnection(String string, int n, String string2, String string3, DebugLog debugLog) throws SQLException {
        super(string, n, string2, string3, debugLog);
    }

    public EXAConnection(String string, int n, String string2, String string3) throws SQLException {
        super(string, n, string2, string3, null);
    }

    public EXAConnection(Vector vector, String string, String string2, DebugLog debugLog, Properties properties) throws SQLException {
        super(vector, string, string2, debugLog, properties, null);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + ")", 0);
        if (n != 2) {
            throw new NotImplemented(this.debug, "Auto-generated keys.");
        }
        return this.prepareStatement(string);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + "," + n2 + "," + n3 + ")", 0);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, "Updatable ResultSets");
        }
        return this.prepareStatement(string);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.log("setHoldability(" + n + ")", 0);
        this.defaultHoldability = n;
        throw new NotImplemented(this.debug, "setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.log("getHoldability()", 0);
        return this.defaultHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.log("setSavepoint()", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.log("setSavepoint(s)", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.log("rollback(Savepoint)", 0);
        throw new NotImplemented(this.debug, "rollback to savepoint");
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.log("releaseSavepoint()", 0);
        throw new NotImplemented(this.debug, "releaseSavepoint");
    }

    @Override
    protected Socket createSocket(String string, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("createSocket: connect timeout cannot be negative: " + n2);
        }
        Socket socket = new Socket();
        socket.setSoTimeout(10000);
        socket.connect(new InetSocketAddress(string, n), n2);
        return socket;
    }

    protected synchronized byte[] communication(byte[] byArray, int n, byte by, ExecutionStatus executionStatus) throws SQLException {
        if (this.csocket == null || !this.csocket.isConnected() || this.csocket.isClosed()) {
            throw new ConnectionLost("Not connected.", this.getSessionID());
        }
        return super.communication(byArray, n, by, 0, executionStatus);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }
}

