/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.sql.SQLException;

class BoolColumn
extends Column {
    private boolean[] values;

    BoolColumn(String string, boolean[] blArray) {
        super(string);
        this.values = blArray;
        int n = this.values.length;
        this.validMask = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.validMask[i] = true;
        }
    }

    BoolColumn() {
        this.values = new boolean[initialBatchCapacity];
    }

    @Override
    int getPrecision() throws SQLException {
        return 1;
    }

    @Override
    void setPrecision(int n) throws SQLException {
        throw new SQLException("Not implemented for BoolColumn");
    }

    @Override
    void setScale(int n) throws SQLException {
        throw new SQLException("Not implemented for BoolColumn - setScale()");
    }

    @Override
    String getClassName() {
        return "java.lang.Boolean";
    }

    @Override
    int getDisplaySize(EXAConnection eXAConnection) {
        return 5;
    }

    @Override
    int getType() {
        return 16;
    }

    @Override
    String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BoolColumn::getObject: " + Translator.Accessed_null_value());
        }
        return new Boolean(this.values[n]);
    }

    @Override
    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BoolColumn::getString: " + Translator.Accessed_null_value());
        }
        return String.valueOf(this.values[n]).toUpperCase();
    }

    @Override
    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BoolColumn::getBoolean: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    @Override
    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("BoolColumn::getByte: " + Translator.Accessed_null_value());
        }
        if (this.values[n]) {
            return 1;
        }
        return 0;
    }

    @Override
    int getInt(int n) throws SQLException {
        return this.getByte(n);
    }

    @Override
    long getLong(int n) throws SQLException {
        return this.getByte(n);
    }

    @Override
    short getShort(int n) throws SQLException {
        return this.getByte(n);
    }

    @Override
    void setBoolean(int n, boolean bl) {
        this.validMask[n] = true;
        this.values[n] = bl;
    }

    @Override
    void setInt(int n, int n2) throws SQLException {
        super.setBoolean(n, n2 != 0);
    }

    @Override
    void setLong(int n, long l) throws SQLException {
        super.setBoolean(n, l != 0L);
    }

    @Override
    void setShort(int n, short s) throws SQLException {
        super.setBoolean(n, s != 0);
    }

    @Override
    void resize(int n) {
        int n2;
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            blArray2[n2] = this.validMask[n2];
            blArray[n2] = this.values[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray2[n2] = false;
        }
        this.values = blArray;
        this.validMask = blArray2;
    }

    @Override
    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeBoolean(this.values[n]);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    @Override
    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.validMask[n] = true;
            this.values[n] = eXAInputStream.readBoolean();
        }
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) throws IOException {
        return new BoolColumn();
    }

    @Override
    int getEXAType() {
        return 9;
    }
}

