/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.logger.LoggerException;
import com.nuodb.jdbc.logger.LoggerFactory;
import com.nuodb.jdbc.logger.Slf4jLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Slf4jLoggerFactory
implements LoggerFactory {
    private Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static Method GET_LOGGER;

    @Override
    public void init(Properties properties) throws LoggerException {
    }

    @Override
    public Logger getLogger() {
        return this.getLogger("com.nuodb.jdbc");
    }

    @Override
    public Logger getLogger(String loggerName) {
        Logger logger = this.loggers.get(loggerName);
        if (logger == null) {
            logger = this.createLogger(loggerName);
            this.loggers.put(loggerName, logger);
        }
        return logger;
    }

    protected Logger createLogger(String loggerName) {
        Slf4jLogger logger;
        try {
            logger = new Slf4jLogger((org.slf4j.Logger)GET_LOGGER.invoke(null, loggerName));
        }
        catch (IllegalAccessException exception) {
            throw new LoggerException("Can't create Slf4jLogger", exception);
        }
        catch (InvocationTargetException exception) {
            throw new LoggerException("Can't create Slf4jLogger", exception.getTargetException());
        }
        return logger;
    }

    static {
        try {
            GET_LOGGER = Class.forName("org.slf4j.LoggerFactory").getMethod("getLogger", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

