/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.DataSource;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class DataSourceConnectionFactory
implements ObjectFactory {
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String CONNECTION_POOL_DATA_SOURCE = "javax.sql.ConnectionPoolDataSource";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> environment) throws Exception {
        if (!(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        String className = reference.getClassName();
        if (!className.equals(DATA_SOURCE) || !className.equals(CONNECTION_POOL_DATA_SOURCE)) {
            return null;
        }
        Properties properties = new Properties();
        for (String property : DataSource.ALL_PROPERTIES) {
            RefAddr refAddr = reference.get(property);
            if (refAddr == null) continue;
            properties.setProperty(property, refAddr.getContent().toString());
        }
        return new DataSource(properties);
    }
}

