/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.G;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBarIconsFactory;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.WholeWordsSupport;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SearchableBar
extends JToolBar
implements SearchableProvider {
    private Searchable \u0108;
    protected JLabel _statusLabel;
    protected JLabel _leadingLabel;
    protected JTextField _textField;
    protected JComboBox _comboBox;
    protected AbstractButton _closeButton;
    protected AbstractButton _findPrevButton;
    protected AbstractButton _findNextButton;
    protected AbstractButton _highlightsButton;
    protected AbstractButton _matchCaseCheckBox;
    protected AbstractButton _wholeWordsCheckBox;
    protected AbstractButton _repeatCheckBox;
    public static final int SHOW_CLOSE = 1;
    public static final int SHOW_NAVIGATION = 2;
    public static final int SHOW_HIGHLIGHTS = 4;
    public static final int SHOW_MATCHCASE = 8;
    public static final int SHOW_REPEATS = 16;
    public static final int SHOW_STATUS = 32;
    public static final int SHOW_WHOLE_WORDS = 64;
    public static final int SHOW_ALL = -1;
    public static final String PROPERTY_MAX_HISTORY_LENGTH = "maxHistoryLength";
    private int \u0109 = -17;
    private boolean \u010f;
    private boolean \u010e = false;
    private JidePopup \u0105;
    private MouseMotionListener \u010b;
    private KeyListener \u010a;
    private List<String> \u0106;
    private int \u0103 = 0;
    private int \u010d = -1;
    private static final Color \u0107 = new Color(255, 85, 85);
    private Color \u010c;
    private Installer \u0104;

    public SearchableBar(Searchable searchable) {
        this(searchable, "", false);
    }

    public SearchableBar(Searchable searchable, boolean bl) {
        this(searchable, "", bl);
    }

    public SearchableBar(Searchable searchable, String string, boolean bl) {
        this.setFloatable(false);
        this.setRollover(true);
        this.\u0108 = searchable;
        this.\u0108.addSearchableListener(new SearchableListener(){

            @Override
            public void searchableEventFired(SearchableEvent searchableEvent) {
                if (searchableEvent.getID() == 3005 && SearchableBar.this.\u0108.getSearchingText() != null && SearchableBar.this.\u0108.getSearchingText().length() != 0) {
                    SearchableBar.this.\u0101();
                }
            }
        });
        this.\u0108.setSearchableProvider(this);
        this.\u010f = bl;
        this.\u0103(string);
    }

    private void \u0103(String string) {
        final AbstractAction abstractAction = new AbstractAction(){
            private static final long \u0102 = -2245391247321137224L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchableBar.this.getInstaller() != null) {
                    SearchableBar.this.getInstaller().closeSearchBar(SearchableBar.this);
                }
            }
        };
        final AbstractAction abstractAction2 = new AbstractAction(){
            private static final long \u0102 = -5263488798121831276L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String string = SearchableBar.this.getSearchingText();
                SearchableBar.this.\u0102(string);
                int n2 = SearchableBar.this.\u0108.getSelectedIndex();
                SearchableBar.this.\u0108.setCursor(n2);
                int n3 = SearchableBar.this.\u0108.findNext(string);
                if (n3 == n2) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0105();
                } else if (n3 != -1 && SearchableBar.this.\u0108.isRepeats() && n3 <= n2) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0101(SearchableBar.this.getResourceString("SearchableBar.reachedBottomRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this.\u0108.isRepeats() && n3 == -1) {
                    SearchableBar.this.\u0101(SearchableBar.this.getResourceString("SearchableBar.reachedBottom"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (n3 != -1) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0105();
                    if (SearchableBar.this.\u0108.getSearchingDelay() < 0) {
                        SearchableBar.this.\u0101();
                    }
                }
            }
        };
        final AbstractAction abstractAction3 = new AbstractAction(){
            private static final long \u0102 = -2534332227053620232L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String string = SearchableBar.this.getSearchingText();
                SearchableBar.this.\u0102(string);
                int n2 = SearchableBar.this.\u0108.getSelectedIndex();
                SearchableBar.this.\u0108.setCursor(n2);
                int n3 = SearchableBar.this.\u0108.findPrevious(string);
                if (n3 == n2) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0105();
                } else if (n3 != -1 && SearchableBar.this.\u0108.isRepeats() && n3 >= n2) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0101(SearchableBar.this.getResourceString("SearchableBar.reachedTopRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this.\u0108.isRepeats() && n3 == -1) {
                    SearchableBar.this.\u0101(SearchableBar.this.getResourceString("SearchableBar.reachedTop"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (n3 != -1) {
                    SearchableBar.this.select(n3, string, false);
                    SearchableBar.this.\u0105();
                }
            }
        };
        this.\u010b = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SearchableBar.this.\u0103();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        };
        this.\u010a = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SearchableBar.this.\u0103();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this._closeButton = this.createCloseButton(abstractAction);
        this._findNextButton = this.createFindNextButton(abstractAction2);
        this._findPrevButton = this.createFindPrevButton(abstractAction3);
        this._highlightsButton = this.createHighlightButton();
        this._matchCaseCheckBox = this.createMatchCaseButton();
        this._wholeWordsCheckBox = this.createWholeWordsButton();
        this._repeatCheckBox = this.createRepeatsButton();
        this._statusLabel = new JLabel();
        this._textField = this.createTextField();
        this._textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SearchableBar.this._textField.selectAll();
            }
        });
        this._textField.setColumns(13);
        DocumentListener documentListener = new DocumentListener(){
            private Timer \u0102;
            {
                this.\u0102 = new Timer(SearchableBar.this.\u0108.getSearchingDelay(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchableBar.this.\u0101();
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.\u0101();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.\u0101();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.\u0101();
            }

            void \u0101() {
                if (SearchableBar.this.\u0108.getSearchingDelay() > 0) {
                    if (this.\u0102.isRunning()) {
                        this.\u0102.restart();
                    } else {
                        this.\u0102.setRepeats(false);
                        this.\u0102.start();
                    }
                } else if (SearchableBar.this.\u0108.getSearchingDelay() == 0) {
                    SearchableBar.this.\u0101();
                }
            }
        };
        this._textField.getDocument().addDocumentListener(documentListener);
        this._textField.setText(string);
        this._textField.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
        this._textField.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(10, 0), 0);
        this._textField.registerKeyboardAction(abstractAction3, KeyStroke.getKeyStroke(38, 0), 0);
        this._textField.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 0);
        this._comboBox = this.createComboBox();
        if (this._comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this._comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(documentListener);
            this.\u0101(abstractAction, abstractAction2, abstractAction3);
            this._comboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    SearchableBar.this.\u0106();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    SearchableBar.this.\u0101(abstractAction, abstractAction2, abstractAction3);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    SearchableBar.this.\u0101(abstractAction, abstractAction2, abstractAction3);
                }
            });
        }
        this._comboBox.setSelectedItem(string);
        this._comboBox.setPreferredSize(this._textField.getPreferredSize());
        this.installComponents();
        int n2 = this.\u0108.findFromCursor(this.getSearchingText());
        if (string.length() != 0 && n2 == -1) {
            this.select(n2, string, false);
        }
    }

    private void \u0101(AbstractAction abstractAction, AbstractAction abstractAction2, AbstractAction abstractAction3) {
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(10, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(abstractAction3, KeyStroke.getKeyStroke(38, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 0);
    }

    private void \u0106() {
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    protected JComboBox createComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        return jComboBox;
    }

    public Searchable getSearchable() {
        return this.\u0108;
    }

    protected AbstractButton createCloseButton(AbstractAction abstractAction) {
        JButton jButton = new JButton(this.getImageIcon("icons/close.png"));
        jButton.addActionListener(abstractAction);
        jButton.setRolloverEnabled(true);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setOpaque(false);
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.setRolloverIcon(this.getImageIcon("icons/closeR.png"));
        return jButton;
    }

    protected AbstractButton createFindNextButton(AbstractAction abstractAction) {
        JButton jButton = new JButton(this.\u010f ? "" : this.getResourceString("SearchableBar.findNext"), this.getImageIcon("icons/next.png"));
        jButton.setToolTipText(this.getResourceString("SearchableBar.findNext.tooltip"));
        jButton.setMnemonic(this.getResourceString("SearchableBar.findNext.mnemonic").charAt(0));
        jButton.setRolloverIcon(this.getImageIcon("icons/nextR.png"));
        jButton.setDisabledIcon(this.getImageIcon("icons/nextD.png"));
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.addActionListener(abstractAction);
        jButton.setEnabled(false);
        return jButton;
    }

    protected AbstractButton createFindPrevButton(AbstractAction abstractAction) {
        JButton jButton = new JButton(this.\u010f ? "" : this.getResourceString("SearchableBar.findPrevious"), this.getImageIcon("icons/previous.png"));
        jButton.setToolTipText(this.getResourceString("SearchableBar.findPrevious.tooltip"));
        jButton.setMnemonic(this.getResourceString("SearchableBar.findPrevious.mnemonic").charAt(0));
        jButton.setRolloverIcon(this.getImageIcon("icons/previousR.png"));
        jButton.setDisabledIcon(this.getImageIcon("icons/previousD.png"));
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.addActionListener(abstractAction);
        jButton.setEnabled(false);
        return jButton;
    }

    protected AbstractButton createHighlightButton() {
        JToggleButton jToggleButton = new JToggleButton(this.\u010f ? "" : this.getResourceString("SearchableBar.highlights"), this.getImageIcon("icons/highlights.png"));
        jToggleButton.setToolTipText(this.getResourceString("SearchableBar.highlights.tooltip"));
        jToggleButton.setMnemonic(this.getResourceString("SearchableBar.highlights.mnemonic").charAt(0));
        jToggleButton.setSelectedIcon(this.getImageIcon("icons/highlightsS.png"));
        jToggleButton.setDisabledIcon(this.getImageIcon("icons/highlightsD.png"));
        jToggleButton.setRolloverIcon(this.getImageIcon("icons/highlightsR.png"));
        jToggleButton.setRolloverSelectedIcon(this.getImageIcon("icons/highlightsRS.png"));
        jToggleButton.setRequestFocusEnabled(false);
        jToggleButton.setFocusable(false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long \u0102 = 5170786863522331175L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchableBar.this.\u0102(SearchableBar.this.getSearchingText());
                SearchableBar.this.\u0101();
            }
        };
        jToggleButton.addActionListener(abstractAction);
        jToggleButton.setEnabled(false);
        return jToggleButton;
    }

    protected AbstractButton createRepeatsButton() {
        JCheckBox jCheckBox = new JCheckBox(this.getResourceString("SearchableBar.repeats"));
        jCheckBox.setMnemonic(this.getResourceString("SearchableBar.repeats.mnemonic").charAt(0));
        jCheckBox.setRequestFocusEnabled(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setSelected(this.getSearchable().isRepeats());
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setRepeats(((AbstractButton)itemEvent.getSource()).isSelected());
                }
            }
        });
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    protected AbstractButton createMatchCaseButton() {
        JCheckBox jCheckBox = new JCheckBox(this.getResourceString("SearchableBar.matchCase"));
        jCheckBox.setMnemonic(this.getResourceString("SearchableBar.matchCase.mnemonic").charAt(0));
        jCheckBox.setRequestFocusEnabled(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setSelected(this.getSearchable().isCaseSensitive());
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setCaseSensitive(((AbstractButton)itemEvent.getSource()).isSelected());
                    SearchableBar.this.\u0102(SearchableBar.this.getSearchingText());
                    SearchableBar.this.\u0101();
                }
            }
        });
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    protected AbstractButton createWholeWordsButton() {
        JCheckBox jCheckBox = new JCheckBox(this.getResourceString("SearchableBar.wholeWords"));
        jCheckBox.setMnemonic(this.getResourceString("SearchableBar.wholeWords.mnemonic").charAt(0));
        jCheckBox.setRequestFocusEnabled(false);
        jCheckBox.setFocusable(false);
        if (this.getSearchable() instanceof WholeWordsSupport) {
            jCheckBox.setSelected(((WholeWordsSupport)((Object)this.getSearchable())).isWholeWords());
        } else {
            jCheckBox.setSelected(false);
            jCheckBox.setEnabled(false);
        }
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() instanceof AbstractButton && SearchableBar.this.getSearchable() instanceof WholeWordsSupport) {
                    ((WholeWordsSupport)((Object)SearchableBar.this.getSearchable())).setWholeWords(((AbstractButton)itemEvent.getSource()).isSelected());
                    SearchableBar.this.\u0102(SearchableBar.this.getSearchingText());
                    SearchableBar.this.\u0101();
                }
            }
        });
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    protected void installComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new JideBoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(4), "fix");
        if ((this.\u0109 & 1) != 0) {
            this.add(this._closeButton);
            this.add(Box.createHorizontalStrut(10));
        }
        this._leadingLabel = new JLabel(this.getResourceString("SearchableBar.find"));
        this._leadingLabel.setDisplayedMnemonic(this.getResourceString("SearchableBar.find.mnemonic").charAt(0));
        this.add(this._leadingLabel);
        this.add(Box.createHorizontalStrut(2), "fix");
        this.add((Component)JideSwingUtilities.createCenterPanel(this._textField), "fix");
        this.add((Component)JideSwingUtilities.createCenterPanel(this._comboBox), "fix");
        if (this.getMaxHistoryLength() == 0) {
            this._leadingLabel.setLabelFor(this._textField);
            this._textField.setVisible(true);
            this._comboBox.setVisible(false);
        } else {
            this._leadingLabel.setLabelFor(this._comboBox);
            this._comboBox.setVisible(true);
            this._textField.setVisible(false);
        }
        this.add(Box.createHorizontalStrut(2), "fix");
        if ((this.\u0109 & 2) != 0) {
            this.add(this._findNextButton);
            this.add(this._findPrevButton);
        }
        if ((this.\u0109 & 4) != 0) {
            this.add(this._highlightsButton);
        }
        if ((this.\u0109 & 8) != 0) {
            this.add(this._matchCaseCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this.\u0109 & 0x40) != 0 && this.getSearchable() instanceof WholeWordsSupport) {
            this.add(this._wholeWordsCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this.\u0109 & 0x10) != 0) {
            this.add(this._repeatCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this.\u0109 & 0x20) != 0) {
            this.add(Box.createHorizontalStrut(24));
            this.add((Component)this._statusLabel, "vary");
        }
        this.add(Box.createHorizontalStrut(6), "fix");
    }

    public boolean isHighlightAll() {
        return this._highlightsButton.isSelected();
    }

    public void setHighlightAll(boolean bl) {
        this._highlightsButton.setSelected(bl);
    }

    private void \u0101() {
        if (this._highlightsButton.isSelected()) {
            this.\u010d = this.\u0108.getCurrentIndex();
            this.\u0104();
            this.\u0102();
        } else {
            if (this.\u010d >= 0) {
                this.\u0108.setCursor(this.\u010d);
                this.\u0108.setSelectedIndex(this.\u010d, false);
            }
            this.\u0104();
        }
    }

    private void \u0102() {
        String string = this.getSearchingText();
        if (string == null || string.length() == 0) {
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.select(-1, "", false);
            this.\u0105();
            return;
        }
        boolean bl = this.\u0108.isRepeats();
        this.\u0108.setRepeats(false);
        int n2 = this.\u0108.findFirst(string);
        if (n2 != -1) {
            this.\u0108.setSelectedIndex(n2, false);
            this.\u0108.setCursor(n2);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.\u0105();
        } else {
            this.select(-1, string, false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.\u0101(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        }
        this.\u0108.highlightAll();
        this.\u0108.setRepeats(bl);
        this.\u0108.setCursor(0);
    }

    private void \u0104() {
        this.\u0108.cancelHighlightAll();
        String string = this.getSearchingText();
        if (string == null || string.length() == 0) {
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.select(-1, "", false);
            this.\u0105();
            return;
        }
        int n2 = this.\u0108.findFromCursor(string);
        if (n2 == -1) {
            this.select(-1, "", false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.\u0101(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        } else {
            this.select(n2, string, false);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.\u0105();
        }
    }

    private void \u0105() {
        this._statusLabel.setIcon(null);
        this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        if (this.isShowMatchCount() && (this._textField.getText().length() > 0 || this._comboBox.isVisible() && this._comboBox.getEditor().getEditorComponent() instanceof JTextField && ((JTextField)this._comboBox.getEditor().getEditorComponent()).getText().length() > 0)) {
            this._statusLabel.setText(this.getSearchable().\u0102() + " " + this.getResourceString("SearchableBar.matches"));
        } else {
            this._statusLabel.setText("");
        }
        this.\u0103();
    }

    private void \u0101(String string, Icon icon) {
        this._statusLabel.setIcon(icon);
        this._statusLabel.setText(string);
        this._statusLabel.setToolTipText(string);
        if (!this._statusLabel.isShowing() || this._statusLabel.getWidth() < 25) {
            this.\u0101(string);
        }
    }

    public void focusSearchField() {
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.requestFocus();
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.requestFocus();
        }
    }

    protected void select(int n2, String string, boolean bl) {
        if (n2 != -1) {
            this.\u0108.setSelectedIndex(n2, bl);
            this.\u0108.setCursor(n2, bl);
            this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
            this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        } else {
            this.\u0108.setSelectedIndex(-1, false);
            this._textField.setBackground(this.getMismatchBackground());
            this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        }
        this.\u0108.firePropertyChangeEvent(string);
        if (n2 != -1) {
            Object object = this.\u0108.getElementAt(n2);
            this.\u0108.fireSearchableEvent(new SearchableEvent(this.\u0108, 3002, string, object, this.\u0108.convertElementToString(object)));
        } else {
            this.\u0108.fireSearchableEvent(new SearchableEvent(this.\u0108, 3003, string));
        }
    }

    @Override
    public String getSearchingText() {
        if (this._textField != null && this._textField.isVisible()) {
            return this._textField.getText();
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            Object object = this._comboBox.getEditor().getItem();
            return object == null ? "" : object.toString();
        }
        return "";
    }

    public void setSearchingText(String string) {
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.setText(string);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.setSelectedItem(string);
        }
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    public void setMismatchForeground(Color color) {
        this.\u010c = color;
    }

    public Color getMismatchBackground() {
        if (this.\u010c == null) {
            return \u0107;
        }
        return this.\u010c;
    }

    public String[] getSearchHistory() {
        return this.\u0106 == null ? new String[]{} : this.\u0106.toArray(new String[this.\u0106.size()]);
    }

    public void setSearchHistory(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.\u0106 = null;
        } else {
            this.\u0106 = new ArrayList<String>();
            this.\u0106.addAll(Arrays.asList(stringArray));
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        if (this.\u0106 != null) {
            for (int i2 = this.\u0106.size() - 1; i2 >= 0; --i2) {
                defaultComboBoxModel.addElement(this.\u0106.get(i2));
            }
        }
        defaultComboBoxModel.insertElementAt("", 0);
        this._comboBox.setModel(defaultComboBoxModel);
        this._comboBox.setSelectedIndex(0);
    }

    public int getMaxHistoryLength() {
        return this.\u0103;
    }

    public void setMaxHistoryLength(int n2) {
        if (this.\u0103 != n2) {
            int n3 = this.\u0103;
            this.\u0103 = n2;
            if (this.getMaxHistoryLength() == 0) {
                this._leadingLabel.setLabelFor(this._textField);
                this._textField.setVisible(true);
                Object object = this._comboBox.getEditor().getItem();
                this._textField.setText(object == null ? "" : object.toString());
                this._comboBox.setVisible(false);
            } else if (!this._comboBox.isVisible()) {
                this._leadingLabel.setLabelFor(this._comboBox);
                this._comboBox.setVisible(true);
                this._comboBox.getEditor().setItem(this._textField.getText());
                this._textField.setVisible(false);
            }
            this.firePropertyChange(PROPERTY_MAX_HISTORY_LENGTH, n3, this.\u0103);
        }
    }

    public boolean isShowMatchCount() {
        return this.\u010e;
    }

    public void setShowMatchCount(boolean bl) {
        this.\u010e = bl;
        if (this.getSearchable() != null) {
            this.getSearchable().setCountMatch(this.isShowMatchCount());
        }
    }

    public Installer getInstaller() {
        return this.\u0104;
    }

    public void setInstaller(Installer installer) {
        this.\u0104 = installer;
    }

    public static SearchableBar install(Searchable searchable, KeyStroke keyStroke, Installer installer) {
        final SearchableBar searchableBar = new SearchableBar(searchable);
        searchableBar.setInstaller(installer);
        ((JComponent)searchable.getComponent()).registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 8328919754409621715L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                searchableBar.getInstaller().openSearchBar(searchableBar);
                searchableBar.focusSearchField();
            }
        }, keyStroke, 1);
        return searchableBar;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getVisibleButtons() {
        return this.\u0109;
    }

    public void setVisibleButtons(int n2) {
        this.\u0109 = n2;
        this.removeAll();
        this.installComponents();
        this.revalidate();
        this.repaint();
    }

    public boolean isCompact() {
        return this.\u010f;
    }

    public void setCompact(boolean bl) {
        this.\u010f = bl;
        this._findNextButton.setText(this.\u010f ? "" : this.getResourceString("SearchableBar.findNext"));
        this._highlightsButton.setText(this.\u010f ? "" : this.getResourceString("SearchableBar.highlights"));
        this._findPrevButton.setText(this.\u010f ? "" : this.getResourceString("SearchableBar.findPrevious"));
    }

    protected ImageIcon getImageIcon(String string) {
        return SearchableBarIconsFactory.getImageIcon(string);
    }

    protected String getResourceString(String string) {
        return G.\u0101(Locale.getDefault()).getString(string);
    }

    private void \u0101(String string) {
        this.\u0103();
        this.\u0105 = JidePopupFactory.getSharedInstance().createPopup();
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(true);
        jLabel.setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
        jLabel.setBackground(new Color(253, 254, 226));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        jLabel.setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
        this.\u0105.getContentPane().setLayout(new BorderLayout());
        this.\u0105.getContentPane().add(jLabel);
        if (this._textField != null && this._textField.isVisible()) {
            this.\u0105.setOwner(this._textField);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this.\u0105.setOwner(this._comboBox);
        }
        this.\u0105.setDefaultMoveOperation(0);
        this.\u0105.setTransient(true);
        this.\u0105.showPopup();
        this.addMouseMotionListener(this.\u010b);
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.addKeyListener(this.\u010a);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.addKeyListener(this.\u010a);
        }
    }

    private void \u0103() {
        if (this.\u0105 != null) {
            this.\u0105.hidePopupImmediately();
            this.\u0105 = null;
        }
        if (this.\u010b != null) {
            this.removeMouseMotionListener(this.\u010b);
        }
        if (this.\u010a != null) {
            this._textField.removeKeyListener(this.\u010a);
            this._comboBox.removeKeyListener(this.\u010a);
        }
    }

    private void \u0102(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.\u0106 == null) {
            this.\u0106 = new ArrayList<String>();
        }
        if (this.\u0106.size() <= 0) {
            this.\u0106.add(string);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(string);
            this._comboBox.setModel(defaultComboBoxModel);
            return;
        }
        if (JideSwingUtilities.equals(this.\u0106.get(this.\u0106.size() - 1), string)) {
            return;
        }
        this.\u0106.remove(string);
        this.\u0106.add(string);
        if (this.getMaxHistoryLength() > 0 && this.\u0106.size() > this.getMaxHistoryLength()) {
            this.\u0106.remove(0);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i2 = this.\u0106.size() - 1; i2 >= 0; --i2) {
            defaultComboBoxModel.addElement(this.\u0106.get(i2));
        }
        this._comboBox.setModel(defaultComboBoxModel);
    }

    public static interface Installer {
        public void openSearchBar(SearchableBar var1);

        public void closeSearchBar(SearchableBar var1);
    }
}

