/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JideSplitButton
extends JideMenu
implements ButtonStyle,
ComponentStateSupport {
    private static final String \u1edf = "JideSplitButtonUI";
    private int \u1ee3 = 0;
    private boolean \u1edc = false;
    public static final String PROPERTY_ALWAYS_DROPDOWN = "alwaysDropdown";
    public static final String ACTION_PROPERTY_SPLIT_BUTTON_ENABLED = "JideSplitButtonEnabled";
    private Color \u1edd;
    private Color \u1ee4;
    private Color \u1ee5;
    private Color \u1ee1;
    private Color \u1ee0;
    private Color \u1ee2;
    private Color \u1ede;

    public JideSplitButton() {
        this.initComponent();
    }

    public JideSplitButton(String string) {
        super(string);
        this.initComponent();
    }

    public JideSplitButton(String string, Icon icon) {
        super(string);
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Icon icon) {
        super("");
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Action action) {
        super(action);
        this.initComponent();
    }

    protected void initComponent() {
        this.setModel(new DefaultSplitButtonModel());
        if (this.getAction() != null) {
            this.configurePropertiesFromAction(this.getAction());
        }
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    @Override
    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(\u1edf) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return \u1edf;
    }

    public boolean isButtonSelected() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonSelected();
    }

    public void setButtonSelected(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonSelected(bl);
        }
    }

    public boolean isButtonEnabled() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonEnabled();
    }

    public void setButtonEnabled(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonEnabled(bl);
        }
    }

    @Override
    public int getButtonStyle() {
        return this.\u1ee3;
    }

    @Override
    public void setButtonStyle(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, and FLAT_STYLE are supported");
        }
        if (n2 == this.\u1ee3) {
            return;
        }
        int n3 = this.\u1ee3;
        this.\u1ee3 = n2;
        this.firePropertyChange("buttonStyle", n3, this.\u1ee3);
    }

    public boolean isAlwaysDropdown() {
        return this.\u1edc;
    }

    public void setAlwaysDropdown(boolean bl) {
        if (this.\u1edc != bl) {
            boolean bl2 = this.\u1edc;
            this.\u1edc = bl;
            this.firePropertyChange(PROPERTY_ALWAYS_DROPDOWN, bl2, bl);
        }
    }

    @Override
    public void setText(String string) {
        Boolean bl = (Boolean)this.getClientProperty("hideActionText");
        if (bl == null || Boolean.FALSE.equals(bl)) {
            super.setText(string);
        }
    }

    public Color getDefaultForeground() {
        return this.\u1edd;
    }

    public void setDefaultForeground(Color color) {
        this.\u1edd = color;
    }

    private Color \u0395() {
        return this.\u1ee4;
    }

    private void \u010d(Color color) {
        this.\u1ee4 = color;
    }

    private Color \u0397() {
        return this.\u1ee5;
    }

    private void \u010a(Color color) {
        this.\u1ee5 = color;
    }

    private Color \u0399() {
        return this.\u1ee1;
    }

    private void \u010c(Color color) {
        this.\u1ee1 = color;
    }

    private Color \u0394() {
        return this.\u1ee0;
    }

    private void \u010b(Color color) {
        this.\u1ee0 = color;
    }

    private Color \u0396() {
        return this.\u1ee2;
    }

    private void \u0108(Color color) {
        this.\u1ee2 = color;
    }

    private Color \u0398() {
        return this.\u1ede;
    }

    private void \u0109(Color color) {
        this.\u1ede = color;
    }

    @Override
    public Color getBackgroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.\u0395();
            }
            case 3: {
                return this.\u0397();
            }
            case 1: {
                return this.\u0399();
            }
        }
        return null;
    }

    @Override
    public void setBackgroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.\u010d(color);
                break;
            }
            case 3: {
                this.\u010a(color);
                break;
            }
            case 1: {
                this.\u010c(color);
            }
        }
    }

    @Override
    public Color getForegroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.\u0394();
            }
            case 3: {
                return this.\u0396();
            }
            case 1: {
                return this.\u0398();
            }
        }
        return null;
    }

    @Override
    public void setForegroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.\u010b(color);
                break;
            }
            case 3: {
                this.\u0108(color);
                break;
            }
            case 1: {
                this.\u0109(color);
            }
        }
    }

    @Override
    public void doClick() {
        Action action = this.getActionMap().get("pressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void doClickOnMenu() {
        Action action = this.getActionMap().get("downPressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        this.setIconFromAction(action);
    }

    protected void setIconFromAction(Action action) {
        Icon icon = null;
        if (action != null) {
            Icon icon2 = icon = SystemInfo.isJdk6Above() && !(this.getParent() instanceof JPopupMenu) ? (Icon)action.getValue("SwingLargeIconKey") : null;
            if (icon == null) {
                icon = (Icon)action.getValue("SmallIcon");
            }
        }
        this.setIcon(icon);
    }

    @Override
    protected void actionPropertyChanged(Action action, String string) {
        super.actionPropertyChanged(action, string);
        if (ACTION_PROPERTY_SPLIT_BUTTON_ENABLED.equals(string) || "enabled".equals(string)) {
            this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        } else if ("SmallIcon".equals(string)) {
            this.setIconFromAction(action);
        } else if (SystemInfo.isJdk6Above() && "SwingLargeIconKey".equals(string)) {
            this.setIconFromAction(action);
        }
    }

    public static boolean isSplitButtonEnabled(Action action) {
        if (action == null) {
            return true;
        }
        Object object = action.getValue(ACTION_PROPERTY_SPLIT_BUTTON_ENABLED);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return action.isEnabled();
    }

    void largeIconChanged(Action action) {
    }

    void smallIconChanged(Action action) {
    }
}

