/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2007.Office2007Painter;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.status.StatusBarSeparator;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class MemoryStatusBarItem
extends StatusBarItem {
    private final Color \u0106 = new Color(236, 233, 176);
    private final Icon \u0102 = IconsFactory.getImageIcon(MemoryStatusBarItem.class, "icons/gc.gif");
    private static final String \u0108 = "showMaxMemory";
    private Color \u0103;
    private Icon \u0107;
    private boolean \u0109 = false;
    protected JComponent _statusArea;
    protected AbstractButton _button;
    protected JPanel _buttonPanel;
    private int \u0104 = 2000;
    private Timer \u0105;

    public MemoryStatusBarItem() {
        this.setLayout(new BorderLayout(0, 0));
        this._statusArea = new A();
        this._statusArea.setFont(null);
        this._statusArea.setOpaque(false);
        this._statusArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MemoryStatusBarItem.this._button.doClick();
                }
            }
        });
        this._button = this.createButton();
        PortingUtils.removeFocus(this._button);
        PortingUtils.removeButtonBorder(this._button);
        this._button.setOpaque(false);
        this._button.addActionListener(new AbstractAction(){
            private static final long \u0102 = -1766810895595638575L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.gc();
                MemoryStatusBarItem.this._statusArea.repaint();
            }
        });
        this.add((Component)this._statusArea, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        if (SystemInfo.isMacOSX()) {
            this._buttonPanel.add((Component)this._button, "Before");
            this._buttonPanel.add((Component)new StatusBarSeparator(), "After");
            this.add((Component)this._buttonPanel, "Before");
        } else {
            this._buttonPanel.add((Component)new StatusBarSeparator(), "Before");
            this._buttonPanel.add((Component)this._button, "After");
            this.add((Component)this._buttonPanel, "After");
        }
        ToolTipManager.sharedInstance().registerComponent(this._statusArea);
        this.\u0105 = new Timer(this.\u0104, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryStatusBarItem.this._statusArea.repaint();
            }
        });
        this.\u0105.start();
    }

    protected AbstractButton createButton() {
        JButton jButton = new JButton(this.\u0102){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (SystemInfo.isJdk6Above()) {
                    return super.getToolTipLocation(mouseEvent);
                }
                Point point = this.getLocation();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                point.y += this.getHeight() - fontMetrics.getHeight();
                return point;
            }
        };
        jButton.setToolTipText(com.jidesoft.status.A.\u0101(this.getLocale()).getString("Memory.rungc"));
        jButton.setFont(null);
        return jButton;
    }

    protected long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    protected long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    protected long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public String formatText(long l2, long l3, long l4) {
        return MessageFormat.format(com.jidesoft.status.A.\u0101(this.getLocale()).getString("Memory.usageText"), Long.toString((l2 - l3) / 0x100000L), Long.toString((this.isShowMaxMemory() ? l4 : l2) / 0x100000L));
    }

    protected String formatTooltip(long l2, long l3, long l4) {
        return MessageFormat.format(com.jidesoft.status.A.\u0101(this.getLocale()).getString(this.isShowMaxMemory() ? "Memory.usageTooltipMax" : "Memory.usageTooltip"), Long.toString((this.isShowMaxMemory() ? l4 : l3) / 0x100000L), Long.toString((l3 - l2) / 0x100000L));
    }

    @Override
    public String getItemName() {
        return "Memory";
    }

    public Color getFillColor() {
        if (this.\u0103 == null) {
            Color color = UIDefaultsLookup.getColor("MemoryStatusBarItem.fillColor");
            return color == null ? this.\u0106 : color;
        }
        return this.\u0103;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._button != null) {
            PortingUtils.removeButtonBorder(this._button);
        }
    }

    public void setFillColor(Color color) {
        this.\u0103 = color;
    }

    public Icon getGcIcon() {
        if (this.\u0107 == null) {
            return this.\u0102;
        }
        return this.\u0107;
    }

    public void setGcIcon(Icon icon) {
        this.\u0107 = icon;
        if (this.\u0107 != null) {
            this._button.setIcon(this.\u0107);
        }
    }

    public void setUpdateInterval(int n2) {
        this.\u0105.stop();
        this.\u0104 = n2;
        this.\u0105.setDelay(n2);
        this.\u0105.start();
    }

    public int getUpdateInterval() {
        return this.\u0104;
    }

    public void start() {
        this.\u0105.start();
    }

    public void stop() {
        this.\u0105.stop();
    }

    @Override
    public int getPreferredWidth() {
        long l2 = this.getTotalMemory();
        String string = this.formatText(l2, l2, l2);
        if (this.getGraphics() != null) {
            return 40 + this.getGraphics().getFontMetrics().stringWidth(string) + this._button.getPreferredSize().width;
        }
        return 80;
    }

    public boolean isShowMaxMemory() {
        return this.\u0109;
    }

    public void setShowMaxMemory(boolean bl) {
        boolean bl2 = this.\u0109;
        if (bl2 != bl) {
            this.\u0109 = bl;
            this.firePropertyChange(\u0108, bl2, this.\u0109);
        }
    }

    class A
    extends JComponent {
        A() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = MemoryStatusBarItem.this._statusArea.getSize();
            long l2 = MemoryStatusBarItem.this.getFreeMemory();
            long l3 = MemoryStatusBarItem.this.getTotalMemory();
            long l4 = MemoryStatusBarItem.this.getMaxMemory();
            int n2 = dimension.width;
            int n3 = (int)((long)n2 * (l3 - l2) / (MemoryStatusBarItem.this.isShowMaxMemory() ? l4 : l3));
            int n4 = dimension.height;
            Color color = MemoryStatusBarItem.this.getFillColor();
            ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
            if (this.isOpaque() && !(themePainter instanceof Office2007Painter)) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n2, n4);
            }
            if (themePainter != null) {
                themePainter.fillBackground(this, graphics, new Rectangle(0, 1, n3, n4 - 2), 0, 0, color);
            } else {
                graphics.setColor(color);
                graphics.fillRect(0, 1, n3, n4 - 2);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n3, 1, n3, n4 - 2);
            graphics.setColor(this.getForeground());
            String string = MemoryStatusBarItem.this.formatText(l3, l2, l4);
            int n5 = graphics.getFontMetrics().stringWidth(string);
            graphics.setFont(this.getFont());
            Rectangle rectangle = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width = n3 - (insets.left + insets.right);
            rectangle.height = n4 - (insets.top + insets.bottom);
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            SwingUtilities.layoutCompoundLabel(graphics.getFontMetrics(), string, null, 0, 0, 0, 0, rectangle, rectangle3, rectangle2, 0);
            JideSwingUtilities.drawString(this, graphics, string, 2 + (n2 - n5) / 2, rectangle2.y + graphics.getFontMetrics().getAscent());
        }

        @Override
        public String getToolTipText() {
            long l2 = MemoryStatusBarItem.this.getFreeMemory();
            long l3 = MemoryStatusBarItem.this.getTotalMemory();
            long l4 = MemoryStatusBarItem.this.getMaxMemory();
            return MemoryStatusBarItem.this.formatTooltip(l2, l3, l4);
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Point point = this.getLocation();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            point.y += this.getHeight() - fontMetrics.getHeight();
            return point;
        }
    }
}

