/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.list.ListModelWrapperUtils;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultDisableableListSelectionModel
extends DefaultListSelectionModel {
    protected Set<Integer> _disabledIndices;
    protected DefaultListSelectionModel _delegate;
    private JTable \u0101;
    private JList \u0102;

    public DefaultDisableableListSelectionModel(JTable jTable) {
        this();
        this.\u0101 = jTable;
    }

    public DefaultDisableableListSelectionModel(JList jList) {
        this();
        this.\u0102 = jList;
    }

    public DefaultDisableableListSelectionModel() {
        this.\u0101();
        this._delegate = new DefaultListSelectionModel();
        this._delegate.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultDisableableListSelectionModel.this.fireValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
        });
    }

    private void \u0101() {
        if (this._disabledIndices == null) {
            this._disabledIndices = new TreeSet<Integer>();
        }
    }

    public void setDisabledIndices(int[] nArray) {
        this._disabledIndices.clear();
        if (nArray != null) {
            for (int n2 : nArray) {
                this._disabledIndices.add(n2);
            }
        }
    }

    public void setDisabledSelectionInterval(int n2, int n3) {
        this._disabledIndices.clear();
        this.addDisabledSelectionInterval(n2, n3);
    }

    public void addDisabledSelectionInterval(int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this._disabledIndices.add(i2);
        }
    }

    public void removeDisabledSelectionInterval(int n2, int n3) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n4 = 0;
        for (int n5 : this._disabledIndices) {
            if (n4 < n2 || n3 < n4) {
                treeSet.add(n5);
            }
            ++n4;
        }
        this._disabledIndices = treeSet;
    }

    public void removeDisabledIndexInterval(int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this._disabledIndices.remove(i2);
        }
    }

    public int[] getDisabledIndices() {
        int[] nArray = new int[this._disabledIndices.size()];
        int n2 = 0;
        Iterator<Integer> iterator = this._disabledIndices.iterator();
        while (iterator.hasNext()) {
            int n3;
            nArray[n2] = n3 = iterator.next().intValue();
            ++n2;
        }
        return nArray;
    }

    @Override
    public boolean isSelectedIndex(int n2) {
        if (this.\u0101 != null) {
            int n3 = TableModelWrapperUtils.getActualRowAt(this.\u0101.getModel(), n2);
            return this.originalIsSelectedIndex(n2) && !this._disabledIndices.contains(n3);
        }
        if (this.\u0102 != null) {
            int n4 = ListModelWrapperUtils.getActualIndexAt(this.\u0102.getModel(), n2);
            return this.originalIsSelectedIndex(n2) && !this._disabledIndices.contains(n4);
        }
        return this.originalIsSelectedIndex(n2) && !this._disabledIndices.contains(n2);
    }

    @Override
    public boolean isSelectionEmpty() {
        int n2 = this.originalGetMaxSelectionIndex();
        if (n2 == -1) {
            return true;
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (!this.isSelectedIndex(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMinSelectionIndex() {
        int n2;
        int n3 = this.originalGetMaxSelectionIndex();
        int n4 = n2;
        for (n2 = this.originalGetMinSelectionIndex(); n2 < n3 && !this.isSelectedIndex(n2); ++n2) {
        }
        if (n2 >= n3) {
            return n4;
        }
        return n2;
    }

    @Override
    public int getMaxSelectionIndex() {
        int n2;
        int n3 = this.originalGetMinSelectionIndex();
        for (n2 = this.originalGetMaxSelectionIndex(); n2 > n3 && !this.isSelectedIndex(n2); --n2) {
        }
        return n2;
    }

    protected int originalGetMinSelectionIndex() {
        return this._delegate.getMinSelectionIndex();
    }

    protected int originalGetMaxSelectionIndex() {
        return this._delegate.getMaxSelectionIndex();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this._delegate.getValueIsAdjusting();
    }

    @Override
    public int getSelectionMode() {
        return this._delegate.getSelectionMode();
    }

    @Override
    public void setSelectionMode(int n2) {
        this._delegate.setSelectionMode(n2);
    }

    protected boolean originalIsSelectedIndex(int n2) {
        return this._delegate.isSelectedIndex(n2);
    }

    protected boolean originalIsSelectionEmpty() {
        return this._delegate.isSelectionEmpty();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public ListSelectionListener[] getListSelectionListeners() {
        return this._delegate.getListSelectionListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this._delegate.setLeadAnchorNotificationEnabled(bl);
    }

    @Override
    public boolean isLeadAnchorNotificationEnabled() {
        return this._delegate.isLeadAnchorNotificationEnabled();
    }

    @Override
    public void clearSelection() {
        this._delegate.clearSelection();
    }

    @Override
    public void setSelectionInterval(int n2, int n3) {
        this._delegate.setSelectionInterval(n2, n3);
    }

    @Override
    public void addSelectionInterval(int n2, int n3) {
        this._delegate.addSelectionInterval(n2, n3);
    }

    @Override
    public void removeSelectionInterval(int n2, int n3) {
        this._delegate.removeSelectionInterval(n2, n3);
    }

    @Override
    public void insertIndexInterval(int n2, int n3, boolean bl) {
        this._delegate.insertIndexInterval(n2, n3, bl);
    }

    @Override
    public void removeIndexInterval(int n2, int n3) {
        this._delegate.removeIndexInterval(n2, n3);
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this._delegate.setValueIsAdjusting(bl);
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public DefaultDisableableListSelectionModel clone() {
        DefaultDisableableListSelectionModel defaultDisableableListSelectionModel = new DefaultDisableableListSelectionModel();
        defaultDisableableListSelectionModel._delegate = this._delegate;
        defaultDisableableListSelectionModel._disabledIndices = this._disabledIndices;
        return defaultDisableableListSelectionModel;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this._delegate.getAnchorSelectionIndex();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this._delegate.getLeadSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int n2) {
        this._delegate.setAnchorSelectionIndex(n2);
    }

    @Override
    public void moveLeadSelectionIndex(int n2) {
        this._delegate.moveLeadSelectionIndex(n2);
    }

    @Override
    public void setLeadSelectionIndex(int n2) {
        this._delegate.setLeadSelectionIndex(n2);
    }
}

