/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractNode;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.grid.TreeTableUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public abstract class AbstractExpandable
extends AbstractNode
implements Expandable {
    protected boolean _expanded = false;
    protected boolean _expandable = true;
    private boolean \u0469 = false;

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void setExpanded(boolean bl) {
        if (this._expanded != bl) {
            boolean bl2 = this._expanded;
            this._expanded = bl;
            if (this._expanded && this instanceof Cacheable) {
                ((Cacheable)((Object)this)).invalidateCache();
            }
            this.firePropertyChange("expanded", bl2, bl);
        }
    }

    @Override
    public boolean isExpandable() {
        return this._expandable;
    }

    @Override
    public void setExpandable(boolean bl) {
        if (this._expandable != bl) {
            boolean bl2 = this._expandable;
            this._expandable = bl;
            this.firePropertyChange("expandable", bl2, bl);
        }
    }

    @Override
    public boolean hasChildren() {
        List<?> list = this.getChildren();
        return list != null && list.size() > 0;
    }

    @Override
    public void removeAllChildren() {
        List<?> list = this.getChildren();
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            arrayList.addAll(list);
        }
        this.removeChildren(arrayList);
    }

    @Override
    public int getNumberOfVisibleExpandable() {
        int n2 = 1;
        if (!this.isExpanded()) {
            return n2;
        }
        if (this.hasChildren()) {
            int n3 = this.getChildrenCount();
            IExpandableTreeTableModel iExpandableTreeTableModel = this.\u0101(this);
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = this.getChildAt(i2);
                if (object instanceof Property && ((Property)object).isHidden() || iExpandableTreeTableModel instanceof TreeTableModel && ((TreeTableModel)iExpandableTreeTableModel).shouldBeFiltered((Row)object)) continue;
                if (object instanceof Expandable) {
                    n2 += ((Expandable)object).getNumberOfVisibleExpandable();
                    continue;
                }
                ++n2;
            }
        }
        return n2;
    }

    public int getNumberOfVisibleChildren() {
        int n2 = 0;
        if (this.hasChildren()) {
            int n3 = this.getChildrenCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = this.getChildAt(i2);
                if (object instanceof Property && ((Property)object).isHidden()) continue;
                ++n2;
            }
        }
        return n2;
    }

    public boolean hasVisibleChildren() {
        if (this.hasChildren()) {
            int n2 = this.getChildrenCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = this.getChildAt(i2);
                if (object instanceof Property && ((Property)object).isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getChildrenCount() {
        List<?> list = this.getChildren();
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    @Deprecated
    public int getAllVisibleChildrenCount() {
        List<?> list = this.getChildren();
        if (list == null) {
            return 0;
        }
        int n2 = 0;
        for (Object obj : list) {
            if (!(obj instanceof Expandable) || !((Expandable)obj).hasChildren()) {
                if (obj instanceof Cacheable) {
                    Cacheable cacheable = (Cacheable)obj;
                    if (cacheable.isCacheValid() && cacheable.getCachedValue() != null) continue;
                    ++n2;
                    continue;
                }
                ++n2;
                continue;
            }
            n2 += ((Expandable)obj).getAllVisibleChildrenCount();
        }
        return n2;
    }

    public int getAllChildrenCount(boolean bl) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getChildrenCount(); ++i2) {
            Object object = this.getChildAt(i2);
            if (object instanceof Expandable) {
                if (!bl) {
                    ++n2;
                }
                n2 += ((Expandable)object).getChildrenCount();
                continue;
            }
            ++n2;
        }
        return n2;
    }

    @Override
    public Object addChild(Object object) {
        return this.addChild(this.getChildrenCount(), object);
    }

    @Override
    public Object addChild(int n2, Object object) {
        List<?> list = this.getChildren();
        if (list == null) {
            list = new ArrayList();
            this.setChildren(list);
        }
        if (n2 < 0 || n2 >= list.size()) {
            list.add(object);
        } else {
            list.add(n2, object);
        }
        if (object instanceof Node) {
            ((Node)object).setParent(this);
        }
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (!this.isAdjusting() && treeTableModel != null) {
            int n3 = this.\u0101(this, object);
            this.notifyChildInserted(object, n3);
            if ((!(treeTableModel instanceof TreeTableModel) || treeTableModel.isAutoExpand()) && this.isExpandable() && !this.isExpanded() && this instanceof ExpandableRow) {
                treeTableModel.expandRow((ExpandableRow)((Object)this), true);
            }
        }
        return object;
    }

    private int \u0102(Expandable expandable, Object object) {
        IExpandableTreeTableModel iExpandableTreeTableModel = this.\u0101(this);
        if (!(expandable instanceof Row) || iExpandableTreeTableModel == null) {
            return -1;
        }
        int n2 = iExpandableTreeTableModel.getRowIndex((Row)((Object)expandable));
        if (n2 < 0 && expandable != iExpandableTreeTableModel.getRoot()) {
            return -1;
        }
        for (int i2 = expandable.getChildIndex(object) - 1; i2 >= 0; --i2) {
            Object object2 = expandable.getChildAt(i2);
            if (!(object2 instanceof Row)) {
                return -1;
            }
            int n3 = iExpandableTreeTableModel.getRowIndex((Row)object2);
            if (n3 < 0) continue;
            return n2 < 0 ? n3 + 1 : (n3 += TableModelWrapperUtils.getVisibleChildrenCount((TableModel)((Object)iExpandableTreeTableModel), (Row)object2)) - n2;
        }
        return 0;
    }

    private int \u0101(Expandable expandable, Object object) {
        Object object2;
        int n2 = this.\u0102(expandable, object);
        if (n2 >= 0) {
            return n2;
        }
        n2 = 0;
        IExpandableTreeTableModel iExpandableTreeTableModel = this.\u0101(this);
        int n3 = expandable.getChildrenCount();
        for (int i2 = 0; i2 < n3 && (object2 = expandable.getChildAt(i2)) != object; ++i2) {
            if (object2 instanceof Property && ((Property)object2).isHidden() || iExpandableTreeTableModel instanceof TreeTableModel && ((TreeTableModel)iExpandableTreeTableModel).shouldBeFiltered((Row)object2)) continue;
            if (object2 instanceof Expandable) {
                n2 += ((Expandable)object2).getNumberOfVisibleExpandable();
                continue;
            }
            ++n2;
        }
        return n2;
    }

    @Override
    public void addChildren(int n2, List<? extends Row> list) {
        if (list == null) {
            return;
        }
        List<?> list2 = this.getChildren();
        if (list2 == null) {
            list2 = new ArrayList();
            this.setChildren(list2);
        }
        if (n2 < 0) {
            list2.addAll(list);
        } else {
            list2.addAll(n2, list);
        }
        for (Row row : list) {
            if (!(row instanceof Node)) continue;
            ((Node)row).setParent(this);
        }
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (!this.isAdjusting() && treeTableModel != null && list.size() > 0) {
            int n3;
            if (this instanceof Row && treeTableModel.getRowIndex((Row)((Object)this)) < 0 && this != treeTableModel.getRoot()) {
                return;
            }
            int n32 = -1;
            if (n2 >= 0) {
                n3 = this.\u0101(this, list.get(0));
            }
            this.notifyChildrenInserted(list, n3);
            if ((!(treeTableModel instanceof TreeTableModel) || ((TreeTableModel)treeTableModel).isAutoExpand()) && this.isExpandable() && !this.isExpanded() && this instanceof ExpandableRow) {
                treeTableModel.expandRow((ExpandableRow)((Object)this), true);
            }
        }
    }

    @Override
    public boolean removeChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(object);
        if (!this.isAdjusting() & this.getTreeTableModel() != null && bl) {
            this.notifyChildDeleted(object);
        }
        if (object instanceof Node) {
            ((Node)object).setParent(null);
        }
        return bl;
    }

    @Override
    public boolean removeChildren(List<? extends Row> list) {
        List<? extends Row> list2 = this.getChildren();
        if (list2 == null || list == null) {
            return false;
        }
        boolean bl = list2.removeAll(list);
        if (!this.isAdjusting() & this.getTreeTableModel() != null && bl) {
            this.notifyChildrenDeleted(list);
        }
        for (Row row : list) {
            if (!(row instanceof Node)) continue;
            ((Node)row).setParent(null);
        }
        return bl;
    }

    @Override
    public Object getChildAt(int n2) {
        List<?> list = this.getChildren();
        if (list == null) {
            return null;
        }
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        Object obj = list.get(n2);
        if (obj instanceof Expandable && ((Expandable)obj).getParent() == null) {
            ((Expandable)obj).setParent(this);
        }
        return obj;
    }

    @Override
    public int getChildIndex(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return -1;
        }
        return list.indexOf(object);
    }

    @Override
    public boolean moveUpChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return false;
        }
        int n2 = this.getChildIndex(object);
        if (n2 == -1) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        this.removeChild(object);
        this.addChild(--n2, object);
        return true;
    }

    @Override
    public boolean moveDownChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return false;
        }
        int n2 = this.getChildIndex(object);
        if (n2 == -1) {
            return false;
        }
        if (n2 == this.getChildren().size() - 1) {
            return false;
        }
        this.removeChild(object);
        this.addChild(++n2, object);
        return true;
    }

    @Override
    public void notifyChildInserted(Object object, int n2) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            int n3 = 1;
            n3 += this.\u0101(expandable, this);
            if (n2 == -1) {
                n2 = expandable.getChildrenCount();
            }
            expandable.notifyChildInserted(object, n3 + n2);
            expandable.notifyChildUpdated(this);
        }
    }

    @Override
    public void notifyChildrenInserted(List list, int n2) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null) {
            return;
        }
        if (this.isExpanded()) {
            int n3 = 1;
            n3 += this.\u0101(expandable, this);
            if (n2 == -1 && this instanceof Row) {
                n2 = TreeTableUtils.getDescendantCount(this.getTreeTableModel(), (Row)((Object)this), false, false);
            }
            if (list.size() == 1) {
                expandable.notifyChildInserted(list.get(0), n3 + n2);
            } else {
                expandable.notifyChildrenInserted(list, n3 + n2);
            }
        }
        expandable.notifyChildUpdated(this);
    }

    @Override
    public void notifyChildDeleted(Object object) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            expandable.notifyChildDeleted(object);
            expandable.notifyChildUpdated(this);
        }
    }

    @Override
    public void notifyChildrenDeleted(List<? extends Row> list) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null || list == null) {
            return;
        }
        if (this.isExpanded()) {
            expandable.notifyChildrenDeleted(list);
        }
        expandable.notifyChildUpdated(this);
    }

    @Override
    public void notifyChildUpdated(Object object) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            expandable.notifyChildUpdated(object);
        }
    }

    @Override
    public void notifyChildrenUpdated(List<? extends Row> list) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null || list == null) {
            return;
        }
        if (!this.isExpanded()) {
            expandable.notifyChildUpdated(this);
        } else {
            for (Row row : list) {
                this.notifyChildUpdated(row);
            }
        }
    }

    public TreeTableModel getTreeTableModel() {
        IExpandableTreeTableModel iExpandableTreeTableModel = this.getExpandableTreeTableModel();
        if (iExpandableTreeTableModel instanceof TreeTableModel) {
            return (TreeTableModel)iExpandableTreeTableModel;
        }
        return null;
    }

    public IExpandableTreeTableModel getExpandableTreeTableModel() {
        return this.\u0101(this.getParent());
    }

    private IExpandableTreeTableModel \u0101(Expandable expandable) {
        if (expandable instanceof RootExpandableRow) {
            return ((RootExpandableRow)expandable).getTreeTableModel();
        }
        if (expandable == null) {
            return null;
        }
        return this.\u0101(expandable.getParent());
    }

    public boolean isAdjusting() {
        return this.\u0469;
    }

    public void setAdjusting(boolean bl) {
        if (bl != this.\u0469) {
            boolean bl2 = this.\u0469;
            this.\u0469 = bl;
            this.firePropertyChange("adjusting", bl2, this.\u0469);
        }
    }
}

