/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.awt.geom.Insets2D;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.ZOrderComparator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.BarIndicatorRenderer;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.BulletAxisPlacement;
import com.jidesoft.gauge.BulletTickStyle;
import com.jidesoft.gauge.DefaultGaugeModel;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.IndicatorRenderer;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.range.Positionable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.border.Border;

public class Bullet
extends AbstractGauge<BulletAxis> {
    private static final long \u010f = 1091447730522337997L;
    private final double \u0118 = 0.1;
    private final double \u010e = 0.2;
    private final double \u0120 = 0.05;
    public static final int INDICATOR_Z_ORDER = 100;
    public static final String DEFAULT_INDICATOR_NAME = "default";
    public static final String PROPERTY_BULLET_FOREGROUND = "Bullet Foreground";
    public static final String PROPERTY_BULLET_BACKGROUND = "Bullet Background";
    private Orientation \u010a = Orientation.horizontal;
    private Paint \u0122 = new Color(216, 216, 216);
    private Border \u0123 = null;
    private List<BulletAxis> \u011d = new ArrayList<BulletAxis>();
    private double \u0124 = 0.1;
    private List<Drawable> \u0125 = new CopyOnWriteArrayList<Drawable>();
    private int \u010c;
    private int \u0111;
    private int \u0110;
    private int \u0116;
    private int \u011e;
    private double \u0109;
    private double \u011f;
    private double \u0119;
    private double \u010d;
    private double \u011c;
    private double \u0117;
    private double \u0113;
    private double \u0115;
    private IndicatorRenderer \u011b = new BarIndicatorRenderer();
    private List<String> \u0114 = new CopyOnWriteArrayList<String>();
    private Map<String, IndicatorRenderer> \u0121 = new HashMap<String, IndicatorRenderer>();
    private Map<String, IndicatorStyle> \u0112 = new HashMap<String, IndicatorStyle>();
    private Map<String, Shape> \u011a = new HashMap<String, Shape>();
    private Insets2D \u010b = null;

    public Bullet() {
        this(new Dimension(300, 300));
    }

    public Bullet(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setModel(new DefaultGaugeModel());
        this.setAxis(new BulletAxis());
        this.setOpaque(true);
        this.\u0101(this.getGraphics());
    }

    public BulletAxis getAxis() {
        if (this.\u011d == null || this.\u011d.size() == 0) {
            throw new IllegalStateException("No axes are currently defined for this Bullet object");
        }
        return this.\u011d.get(0);
    }

    public void setAxis(BulletAxis bulletAxis) {
        this.\u011d.clear();
        this.\u011d.add(bulletAxis);
    }

    public void addAxis(BulletAxis bulletAxis) {
        if (this.\u011d.size() >= 2) {
            throw new IllegalStateException("The Bullet class currently has a limit of two axes and this object has already reached the limit");
        }
        this.\u011d.add(bulletAxis);
    }

    public Insets2D getProportionalInsets() {
        return this.\u010b;
    }

    public void setProportionalInsets(Insets2D insets2D) {
        this.\u010b = insets2D;
    }

    public Orientation getOrientation() {
        return this.\u010a;
    }

    public void setOrientation(Orientation orientation) {
        this.\u010a = orientation;
    }

    public IndicatorRenderer getRenderer() {
        return this.\u011b;
    }

    public void setRenderer(IndicatorRenderer indicatorRenderer) {
        this.\u011b = indicatorRenderer;
    }

    public IndicatorRenderer getRenderer(String string) {
        return this.\u0121.get(string);
    }

    public void setRenderer(String string, IndicatorRenderer indicatorRenderer) {
        if (!this.\u0114.contains(string)) {
            this.\u0114.add(string);
        }
        if (indicatorRenderer == null) {
            this.\u0121.remove(string);
        } else {
            this.\u0121.put(string, indicatorRenderer);
        }
    }

    public void addDrawable(Drawable drawable) {
        this.\u0125.add(drawable);
        this.repaint();
    }

    public void removeDrawable(Drawable drawable) {
        this.\u0125.remove(drawable);
        this.repaint();
    }

    boolean \u0101(Drawable drawable) {
        return this.\u0125.contains(drawable);
    }

    public void removeDrawables() {
        this.\u0125.clear();
        this.repaint();
    }

    public Paint getBulletBackground() {
        return this.\u0122;
    }

    public void setBulletBackground(Paint paint) {
        Paint paint2 = this.\u0122;
        this.\u0122 = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_BULLET_BACKGROUND, paint2, paint);
    }

    public Border getBulletBorder() {
        return this.\u0123;
    }

    public void setBulletBorder(Border border) {
        this.\u0123 = border;
    }

    public Shape renderedAs(String string) {
        return this.\u011a.get(string);
    }

    public List<String> containingShapes(Point point) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Shape> entry : this.\u011a.entrySet()) {
            Shape shape = entry.getValue();
            String string = entry.getKey();
            if (!shape.contains(point)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> renderedValues() {
        Set<String> set = this.\u011a.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    public int getXEnd() {
        return this.\u0110;
    }

    public int getXStart() {
        return this.\u010c;
    }

    public int getYEnd() {
        return this.\u0116;
    }

    public int getYStart() {
        return this.\u0111;
    }

    public double getMidY() {
        return this.\u0113;
    }

    public double getMidX() {
        return this.\u0115;
    }

    @Override
    public void setValue(String string, Positionable positionable, boolean bl) {
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable2 = gaugeModel == null ? null : gaugeModel.getValue(string);
        Double d2 = positionable2 == null ? null : Double.valueOf(positionable2.position());
        Double d3 = positionable == null ? null : Double.valueOf(positionable.position());
        gaugeModel.setValue(string, positionable, bl);
        if (!this.\u0114.contains(string)) {
            this.\u0114.add(string);
        }
        this.firePropertyChange(string, d2, d3);
    }

    public Bullet addIndicator(String string, IndicatorStyle indicatorStyle) {
        this.setIndicatorStyle(string, indicatorStyle);
        return this;
    }

    public void removeIndicator(String string) {
        this.\u0112.remove(string);
        if (this.\u0114 != null) {
            this.\u0114.remove(string);
        }
    }

    public void removeIndicators() {
        if (this.\u0112 != null) {
            this.\u0112.clear();
        }
        if (this.\u0114 != null) {
            this.\u0114.clear();
        }
    }

    public void setIndicatorStyle(IndicatorStyle indicatorStyle) {
        this.setIndicatorStyle(DEFAULT_INDICATOR_NAME, indicatorStyle);
    }

    public void setIndicatorStyle(String string, IndicatorStyle indicatorStyle) {
        if (!this.\u0114.contains(string)) {
            this.\u0114.add(string);
        }
        if (indicatorStyle == null) {
            this.\u0112.remove(string);
        } else {
            this.\u0112.put(string, indicatorStyle);
        }
    }

    public IndicatorStyle getIndicatorStyle(String string) {
        return this.\u0112.get(string);
    }

    public void removeStyles() {
        this.\u0112.clear();
    }

    protected double calculatePixelCoordinate(BulletAxis bulletAxis, double d2) {
        double d3 = this.\u0101(d2, bulletAxis);
        if (this.\u010a == Orientation.horizontal) {
            return (double)this.\u010c + d3 * (double)(this.\u0110 - this.\u010c);
        }
        return (double)this.\u0111 - d3 * (double)(this.\u0111 - this.\u0116);
    }

    @Override
    protected Point2D calculatePixelPoint2D(BulletAxis bulletAxis, double d2) {
        double d3 = this.\u0101(d2, bulletAxis);
        if (this.\u010a == Orientation.horizontal) {
            double d4 = (double)this.\u010c + d3 * (double)(this.\u0110 - this.\u010c);
            return new Point2D.Double(d4, this.\u0113);
        }
        double d5 = (double)this.\u0111 - d3 * (double)(this.\u0111 - this.\u0116);
        return new Point2D.Double(this.\u0115, d5);
    }

    private double \u0101(Double d2, BulletAxis bulletAxis) {
        double d3 = bulletAxis.minimum();
        double d4 = bulletAxis.maximum();
        if (d2 == null || d2 < d3) {
            return 0.0;
        }
        if (d2 > d4) {
            return 1.0;
        }
        return (d2 - d3) / (d4 - d3);
    }

    private Pair<String, String> \u0101() {
        String string = null;
        String string2 = null;
        for (BulletAxis bulletAxis : this.\u011d) {
            String string3;
            List<Tick> list = bulletAxis.ticks();
            if (list == null || list.size() < 1) continue;
            Tick tick = list.get(0);
            Tick tick2 = list.get(list.size() - 1);
            String string4 = tick.getLabel();
            if (string4 != null && (string == null || string.length() < string4.length())) {
                string = tick.getLabel();
            }
            if ((string3 = tick2.getLabel()) == null || string2 != null && string2.length() >= string3.length()) continue;
            string2 = tick2.getLabel();
        }
        return new Pair<Object, Object>(string, string2);
    }

    public void update() {
        this.\u0101(this.getGraphics());
    }

    void \u0101(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        Insets insets = this.getInsets();
        BulletAxis bulletAxis = this.getAxis();
        this.\u010c = insets.left;
        this.\u0110 = dimension.width - insets.right;
        this.\u0111 = dimension.height - insets.bottom;
        this.\u0116 = insets.top;
        if (this.\u010b != null) {
            this.\u010c = (int)((long)this.\u010c + Math.round(this.\u010b.getLeft() * (double)dimension.width));
            this.\u0110 = (int)((long)this.\u0110 - Math.round(this.\u010b.getRight() * (double)dimension.width));
            this.\u0111 = (int)((long)this.\u0111 - Math.round(this.\u010b.getBottom() * (double)dimension.height));
            this.\u0116 = (int)((long)this.\u0116 + Math.round(this.\u010b.getTop() * (double)dimension.height));
        } else {
            Iterator<BulletAxis> iterator;
            Object object;
            FontMetrics fontMetrics;
            Pair<String, String> pair = this.\u0101();
            Font font = this.tickLabelFontForAxis(bulletAxis);
            FontMetrics fontMetrics2 = fontMetrics = graphics == null ? null : graphics.getFontMetrics(font);
            if (fontMetrics == null) {
                object = new BufferedImage(1, 1, 2);
                iterator = ((BufferedImage)object).getGraphics();
                fontMetrics = ((Graphics)((Object)iterator)).getFontMetrics();
            }
            if (bulletAxis.isVisible()) {
                if (this.\u010a == Orientation.horizontal) {
                    object = pair.getFirst();
                    this.\u010c = (int)((long)this.\u010c + (object == null ? 0L : 1L + Math.round((double)(fontMetrics.stringWidth((String)object) + 1) / 2.0)));
                    iterator = pair.getSecond();
                    this.\u0110 = (int)((double)this.\u0110 - (iterator == null ? 0.0 : (double)fontMetrics.stringWidth((String)((Object)iterator)) / 2.0));
                } else {
                    this.\u0111 -= fontMetrics.getDescent() + fontMetrics.getDescent();
                    this.\u0116 += fontMetrics.getAscent() - fontMetrics.getDescent();
                }
            }
        }
        this.\u011e = this.\u010a == Orientation.horizontal ? this.\u0110 - this.\u010c : this.\u0111 - this.\u0116;
        this.\u0109 = this.\u0124 * (double)this.\u011e;
        double d2 = 0.0;
        double d3 = 0.0;
        for (BulletAxis bulletAxis2 : this.\u011d) {
            double d4 = this.\u0101(graphics, bulletAxis2);
            if (this.\u010a == Orientation.horizontal && bulletAxis2.getPlacement() == BulletAxisPlacement.TRAILING) {
                d2 += d4;
            }
            d3 += d4;
        }
        double d5 = this.\u0109 + d3;
        this.\u0113 = this.\u010a == Orientation.horizontal ? ((double)(this.\u0111 - this.\u0116) - d5) / 2.0 + d2 + this.\u0109 / 2.0 : (double)(this.\u0111 + this.\u0116) / 2.0;
        this.\u0115 = (double)(this.\u010c + this.\u0110) / 2.0;
        this.\u010d = this.\u010a == Orientation.horizontal ? this.\u0113 - this.\u0109 / 2.0 : (double)this.\u0116;
        this.\u0119 = this.\u010a == Orientation.horizontal ? this.\u0113 + this.\u0109 / 2.0 : (double)this.\u0111;
        this.\u011c = this.\u010a == Orientation.horizontal ? (double)this.\u010c : this.\u0115 - this.\u0109 / 2.0;
        this.\u0117 = this.\u010a == Orientation.horizontal ? (double)this.\u0110 : this.\u0115 + this.\u0109 / 2.0;
    }

    public double getBulletBreadth() {
        int n2 = this.\u010a == Orientation.horizontal ? this.\u0110 - this.\u010c : this.\u0111 - this.\u0116;
        return this.\u0124 * (double)n2;
    }

    public double getBreadthProportion() {
        return this.\u0124;
    }

    public void setBreadthProportion(double d2) {
        this.\u0124 = d2;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        Rectangle rectangle;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        this.\u0101(graphics2D);
        Shape shape = graphics2D.getClip();
        Rectangle rectangle2 = rectangle = shape == null ? new Rectangle(0, 0, dimension.width, dimension.height) : shape.getBounds();
        if (this.isOpaque()) {
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintBulletBackground(graphics2D);
        this.paintBulletBorder(graphics2D);
        for (BulletAxis object62 : this.\u011d) {
            if (!object62.isVisible()) continue;
            this.paintAxis(graphics2D, object62);
        }
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>(this.\u0125);
        Collections.sort(arrayList, new ZOrderComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object3 = (Drawable)iterator.next();
            if (object3 instanceof ZOrder) {
                ZOrder zOrder = (ZOrder)object3;
                if (zOrder.getZOrder() >= 0 && zOrder.getZOrder() < 100) {
                    object3.draw(graphics2D);
                    continue;
                }
                if (zOrder.getZOrder() < 100) continue;
                break;
            }
            object3.draw(graphics2D);
        }
        this.\u011a.clear();
        ArrayList<Pair<Integer, String>> arrayList2 = new ArrayList<Pair<Integer, String>>();
        for (String string : this.\u0114) {
            IndicatorRenderer indicatorRenderer = this.\u0121.get(string);
            if (indicatorRenderer == null) continue;
            object2 = 100;
            if (indicatorRenderer instanceof ZOrder) {
                object = (ZOrder)((Object)indicatorRenderer);
                object2 = object.getZOrder();
            }
            arrayList2.add(new Pair<Integer, String>((Integer)object2, string));
        }
        object3 = new Comparator<Pair<Integer, String>>(){

            public int \u0101(Pair<Integer, String> pair, Pair<Integer, String> pair2) {
                int n2;
                int n3 = pair.getFirst();
                if (n3 == (n2 = pair2.getFirst().intValue())) {
                    return 0;
                }
                return n3 < n2 ? -1 : 1;
            }
        };
        Collections.sort(arrayList2, object3);
        for (Pair pair : arrayList2) {
            object2 = (String)pair.getSecond();
            object = this.\u0121.get(object2);
            IndicatorStyle indicatorStyle = this.\u0112.get(object2);
            if (indicatorStyle == null) {
                indicatorStyle = new IndicatorStyle();
            }
            Double d2 = this.getValue((String)object2);
            Shape shape2 = object.paintIndicator(graphics2D, this, d2, indicatorStyle);
            this.\u011a.put((String)object2, shape2);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Drawable drawable = (Drawable)iterator2.next();
            if (!(drawable instanceof ZOrder) || (object2 = (ZOrder)((Object)drawable)).getZOrder() < 100) continue;
            drawable.draw(graphics2D);
        }
        for (String string : this.\u0114) {
            object2 = this.\u0121.get(string);
            if (object2 == null) {
                object2 = this.\u011b;
            }
            if (!(object2 instanceof AbstractIndicatorRenderer)) continue;
            object = (AbstractIndicatorRenderer)object2;
            ((AbstractIndicatorRenderer)object).paintLabel(graphics2D, this, this.getValue(string), null);
        }
    }

    protected Rectangle2D paintBulletBackground(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = null;
        if (this.\u0122 != null) {
            graphics2D.setPaint(this.\u0122);
            double d2 = (int)(this.\u0117 - this.\u011c);
            double d3 = (int)(this.\u0119 - this.\u010d);
            double_ = new Rectangle2D.Double(this.\u011c, this.\u010d, d2, d3);
            graphics2D.fill(double_);
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        return double_;
    }

    protected void paintBulletBorder(Graphics2D graphics2D) {
        if (this.\u0123 != null) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int n2 = (int)(this.\u0117 - this.\u011c + 1.0);
            int n3 = (int)(this.\u0119 - this.\u010d + 1.0);
            this.\u0123.paintBorder(this, graphics2D, (int)this.\u011c, (int)this.\u010d, n2, n3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private double \u0101(Graphics graphics, BulletAxis bulletAxis) {
        if (bulletAxis == null) {
            return 0.0;
        }
        BulletTickStyle bulletTickStyle = (BulletTickStyle)bulletAxis.getMajorTickStyle();
        BulletTickStyle bulletTickStyle2 = (BulletTickStyle)bulletAxis.getMinorTickStyle();
        if (!bulletAxis.isVisible()) {
            return 0.0;
        }
        if (!(bulletTickStyle != null && bulletTickStyle.isVisible() || bulletTickStyle2 != null && bulletTickStyle2.isVisible())) {
            return 0.0;
        }
        if (bulletTickStyle != null && !bulletTickStyle.isVisible() && bulletTickStyle2 != null && bulletTickStyle2.isVisible()) {
            double d2 = bulletTickStyle2 == null ? this.\u0109 * 0.1 : this.\u0109 * bulletTickStyle2.getTickLength();
            return d2;
        }
        if (graphics == null) {
            return 0.0;
        }
        Font font = this.tickLabelFontForAxis(bulletAxis);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        double d3 = bulletTickStyle == null ? this.\u0109 * 0.2 : this.\u0109 * bulletTickStyle.getTickLength();
        return d3 + (double)n2;
    }

    protected void paintAxis(Graphics2D graphics2D, BulletAxis bulletAxis) {
        float f2;
        double d2;
        Dimension dimension = this.getSize();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setColor(Color.black);
        Color color = bulletAxis.getTickLabelColor();
        if (color == null) {
            color = Color.BLACK;
        }
        BulletTickStyle bulletTickStyle = (BulletTickStyle)bulletAxis.getMajorTickStyle();
        BulletTickStyle bulletTickStyle2 = (BulletTickStyle)bulletAxis.getMinorTickStyle();
        boolean bl = bulletTickStyle == null || bulletTickStyle.isVisible();
        boolean bl2 = bulletTickStyle2 == null || bulletTickStyle2.isVisible();
        Color color2 = bulletTickStyle == null ? Color.BLACK : bulletTickStyle.getTickColor();
        Color color3 = bulletTickStyle2 == null ? Color.BLACK : bulletTickStyle2.getTickColor();
        double d3 = bulletTickStyle == null ? this.\u0109 * 0.2 : this.\u0109 * bulletTickStyle.getTickLength();
        double d4 = bulletTickStyle2 == null ? this.\u0109 * 0.1 : this.\u0109 * bulletTickStyle2.getTickLength();
        double d5 = bulletTickStyle == null ? d3 * 0.05 : d3 * bulletTickStyle.getTickWidth();
        double d6 = d2 = bulletTickStyle2 == null ? d4 * 0.05 : d4 * bulletTickStyle2.getTickWidth();
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        List<Tick> list = bulletAxis.ticks();
        double d7 = bulletAxis.minimum();
        double d8 = bulletAxis.maximum();
        double d9 = d8 - d7;
        Dimension dimension2 = this.getFontComparisonSize();
        if (this.isResizeFonts() && dimension != null && dimension.height > 0 && dimension2 != null) {
            float f3 = this.\u011e;
            float f4 = (float)(this.\u0109 + d3);
            float f5 = f4 / (float)dimension2.height;
            f2 = f3 / (float)dimension2.width;
            this.setFontSizeRatio(Math.min(f5, f2));
        }
        Font font = this.tickLabelFontForAxis(bulletAxis);
        graphics2D2.setFont(font);
        BulletAxisPlacement bulletAxisPlacement = bulletAxis.getPlacement();
        for (Tick tick : list) {
            float f6;
            float f7;
            Line2D.Double double_;
            double d10;
            double d11;
            double d12;
            boolean bl3 = tick.isMajor() ? bl : bl2;
            if (!bl3) continue;
            double d13 = d12 = tick.isMajor() ? d3 : d4;
            if (this.\u010a == Orientation.horizontal) {
                d11 = (double)this.\u010c + (tick.getPosition() - d7) / d9 * (double)this.\u011e;
                d10 = bulletAxisPlacement == BulletAxisPlacement.LEADING ? (double)((int)this.\u0119) : this.\u010d - d12;
                double_ = new Line2D.Double(d11, d10, d11, d10 + d12);
            } else {
                d11 = bulletAxisPlacement == BulletAxisPlacement.LEADING ? this.\u011c - d12 : this.\u0117;
                d10 = (double)this.\u0111 - (tick.getPosition() - d7) / d9 * (double)this.\u011e;
                double_ = new Line2D.Double(d11, d10, d11 + d12, d10);
            }
            graphics2D2.setColor(tick.isMajor() ? color2 : color3);
            double d14 = tick.isMajor() ? d5 : d2;
            graphics2D2.setStroke(new BasicStroke((float)d14, 0, 2));
            graphics2D2.draw(double_);
            if (!tick.isMajor()) continue;
            graphics2D2.setColor(color);
            String string = tick.getLabel();
            if (this.\u010a == Orientation.horizontal) {
                f7 = (float)d11;
                f6 = (float)(bulletAxisPlacement == BulletAxisPlacement.LEADING ? d10 + d12 : d10);
            } else {
                f7 = (float)(bulletAxisPlacement == BulletAxisPlacement.LEADING ? d11 - 1.0 : d11 + d12 + 1.0);
                f6 = (float)d10;
            }
            this.\u0101(graphics2D2, bulletAxis, string, f7, f6);
        }
        if (this.getFontComparisonSize() == null && dimension != null && dimension.width > 0 && dimension.height > 0) {
            float f8;
            if (this.\u010a == Orientation.horizontal) {
                f8 = this.\u011e;
                f2 = (float)(this.\u0109 + d3);
            } else {
                f8 = (float)(this.\u0109 + d3);
                f2 = this.\u011e;
            }
            this.setFontComparisonSize(new Dimension((int)f8, (int)f2));
        }
        graphics2D2.dispose();
    }

    private void \u0101(Graphics2D graphics2D, BulletAxis bulletAxis, String string, float f2, float f3) {
        if (string == null) {
            return;
        }
        double d2 = bulletAxis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getAscent();
        BulletAxisPlacement bulletAxisPlacement = bulletAxis.getPlacement();
        if (d2 == 0.0) {
            float f4;
            float f5;
            int n4 = fontMetrics.stringWidth(string);
            if (this.\u010a == Orientation.horizontal) {
                f5 = f2 - (float)(n4 / 2);
                f4 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f3 - (float)n2 : f3 + (float)n3;
            } else {
                f5 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f2 + 1.0f : f2 - (float)n4 - 1.0f;
                f4 = f3 + (float)n2;
            }
            this.drawStringIfWithinBounds(graphics2D, string, f5, f4);
        } else {
            boolean bl;
            String string2 = string;
            boolean bl2 = false;
            Font font = this.tickLabelFontForAxis(bulletAxis);
            do {
                float f6;
                float f7;
                float f8;
                String string3;
                String string4 = string3 = bl2 ? string2 + "\u2026" : string2;
                String string5 = string3.length() <= 1 ? "" : (d2 < 1.5707963267948966 && d2 > 0.0 ? string3.substring(string3.length() - 1, string3.length()) : string3.substring(0, 1));
                int n5 = fontMetrics.stringWidth(string5);
                int n6 = string2.length() <= 1 ? fontMetrics.stringWidth(string3) / 2 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                float f9 = this.\u010a == Orientation.horizontal ? (float)n6 / 2.0f : (float)n6 / 2.0f;
                float f10 = f8 = d2 < 1.5707963267948966 && d2 > 0.0 ? -((float)((double)f9 * Math.cos(d2))) : (float)((double)f9 * Math.cos(d2));
                if (this.\u010a == Orientation.horizontal) {
                    f7 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f2 - f9 - f8 - (float)(n5 / 2) : f2 - f9 + f8 - (float)(n5 / 2);
                    f6 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f3 + (float)(fontMetrics.getHeight() / 2) - (float)n3 - (float)Math.abs((double)f9 * Math.sin(d2)) : f3 + (float)(fontMetrics.getHeight() / 2) + (float)Math.abs((double)f9 * Math.sin(d2));
                } else {
                    f7 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? (float)((double)(f2 + (float)fontMetrics.charWidth(':')) + (double)(n6 / 2) * Math.cos(d2) - (double)(n5 / 2)) : (float)((double)(f2 - (float)fontMetrics.charWidth('o') - (float)(n6 / 2)) - (double)(n6 / 2) * Math.cos(d2) - (double)(n5 / 2));
                    f6 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f3 - (float)((double)(n6 / 2) * Math.sin(d2)) : f3 + (float)((double)(n6 / 2) * Math.sin(d2));
                }
                bl = this.drawRotatedStringIfWithinBounds(graphics2D, font, string3, f7, f6, d2);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Bullet.class.getName(), 4096);
        }
    }
}

