/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.BarLabelPlacement;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BarIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private double \u011e = 0.33;
    private Border \u011b = null;
    private BarLabelPlacement \u011c = BarLabelPlacement.BAR_CENTER;
    private double \u011d = 0.5;

    public BarLabelPlacement getLabelPlacement() {
        return this.\u011c;
    }

    public void setLabelPlacement(BarLabelPlacement barLabelPlacement) {
        this.\u011c = barLabelPlacement;
    }

    public double getBarBreadth() {
        return this.\u011e;
    }

    public void setBarBreadth(double d2) {
        this.\u011e = d2;
    }

    public double getBarPosition() {
        return this.\u011d;
    }

    public void setBarPosition(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("The barPosition property must be a value between 0 and 1");
        }
        this.\u011d = d2;
    }

    public Border getBorder() {
        return this.\u011b;
    }

    public void setBorder(Border border) {
        this.\u011b = border;
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d2) {
        int n2;
        int n3;
        double d3;
        double d4;
        if (d2 == null) {
            return null;
        }
        double d5 = bullet.getMidY();
        double d6 = bullet.getMidX();
        double d7 = bullet.getBulletBreadth();
        double d8 = this.\u011e * d7;
        BulletAxis bulletAxis = bullet.getAxis();
        double d9 = bullet.calculatePixelCoordinate(bulletAxis, bulletAxis.minimum());
        double d10 = bullet.calculatePixelCoordinate(bulletAxis, d2);
        Orientation orientation = bullet.getOrientation();
        if (orientation == Orientation.horizontal) {
            double d11 = d5 + (this.\u011d - 0.5) * d7;
            d4 = (int)(d11 - d8 / 2.0);
            double d12 = (int)(d11 + d8 / 2.0);
            double d13 = (int)d10;
            d3 = (int)d9;
            n3 = (int)(d13 - d3);
            if (n3 == 0) {
                n3 = 1;
            }
            n2 = (int)(d12 - d4 + 1.0);
        } else {
            double d14 = d6 + (this.\u011d - 0.5) * d7;
            d4 = (int)Math.round(d10);
            double d15 = (int)Math.round(d9);
            d3 = (int)(d14 - d8 / 2.0);
            double d16 = (int)(d14 + d8 / 2.0);
            n3 = (int)(d16 - d3 + 1.0);
            n2 = (int)(d15 - d4);
            if (n2 == 0) {
                n2 = 1;
            }
        }
        return new Rectangle2D.Double(d3, d4, n3, n2);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Rectangle rectangle = shape.getBounds();
        double d2 = bullet.getBulletBreadth();
        graphics2D2.setPaint(indicatorStyle.getFill());
        Object object = graphics2D2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle rectangle2 = graphics2D2.getClipBounds();
        graphics2D2.fill(rectangle);
        graphics2D2.draw(rectangle);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D2.setClip(rectangle2);
        if (this.\u011b == null) {
            Color color = indicatorStyle.getOutline();
            if (color != null) {
                float f2 = indicatorStyle.getOutlineWidth();
                float f3 = (float)((double)f2 * d2 / 100.0);
                if (f3 < 1.0f) {
                    f3 = 1.0f;
                }
                BasicStroke basicStroke = new BasicStroke(f3);
                Stroke stroke = graphics2D2.getStroke();
                graphics2D2.setStroke(basicStroke);
                graphics2D2.setColor(color);
                graphics2D2.draw(rectangle);
                graphics2D2.setStroke(stroke);
            }
        } else {
            this.\u011b.paintBorder(bullet, graphics2D2, rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        }
        graphics2D2.dispose();
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d2, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d2);
        if (string != null && this.labelVisible) {
            double d3;
            double d4;
            double d5;
            double d6;
            int n2 = bullet.getYStart();
            int n3 = bullet.getYEnd();
            int n4 = bullet.getXStart();
            int n5 = bullet.getXEnd();
            double d7 = bullet.getMidY();
            double d8 = bullet.getMidX();
            BulletAxis bulletAxis = bullet.getAxis();
            double d9 = bullet.calculatePixelCoordinate(bulletAxis, bulletAxis.minimum());
            double d10 = bullet.getBulletBreadth();
            double d11 = this.\u011e * d10;
            Orientation orientation = bullet.getOrientation();
            double d12 = bullet.calculatePixelCoordinate(bulletAxis, d2);
            if (orientation == Orientation.horizontal) {
                d6 = d7 - d11 / 2.0;
                d5 = d7 + d11 / 2.0;
                d4 = d9;
                d3 = d12;
            } else {
                d6 = d12;
                d5 = d9;
                d4 = d8 - d11 / 2.0;
                d3 = d8 + d11 / 2.0;
            }
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n6 = fontMetrics.stringWidth(string);
            int n7 = fontMetrics.charWidth('o');
            graphics2D.setColor(this.getLabelColor());
            graphics2D.setFont(font2);
            if (orientation == Orientation.horizontal) {
                float f2;
                double d13 = d7 + (this.\u011d - 0.5) * d10;
                float f3 = (float)(d13 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                if (this.\u011c == BarLabelPlacement.START) {
                    f2 = (float)((double)n4 + (double)n7 / 2.0);
                } else if (this.\u011c == BarLabelPlacement.BAR_CENTER) {
                    f2 = (float)((d4 + d3) / 2.0 - (double)n6 / 2.0);
                } else if (this.\u011c == BarLabelPlacement.CENTER) {
                    f2 = (float)(d8 - (double)n6 / 2.0);
                } else if (this.\u011c == BarLabelPlacement.BEFORE_BAR_END) {
                    f2 = (float)(d12 - (double)n6 - (double)n7 / 2.0);
                } else if (this.\u011c == BarLabelPlacement.AFTER_BAR_END) {
                    f2 = (float)(d12 + (double)n7 / 2.0);
                } else if (this.\u011c == BarLabelPlacement.END) {
                    f2 = (float)((double)(n5 - n6) - (double)n7 / 2.0);
                } else {
                    throw new IllegalArgumentException("Unexpected value for labelPlacement: " + (Object)((Object)this.\u011c));
                }
                graphics2D.drawString(string, f2, f3);
            } else if (orientation == Orientation.vertical) {
                float f4;
                double d14 = d8 + (this.\u011d - 0.5) * d10;
                float f5 = (float)(d14 - (double)n6 / 2.0);
                if (this.\u011c == BarLabelPlacement.START) {
                    f4 = (float)n2 - (float)fontMetrics.getDescent();
                } else if (this.\u011c == BarLabelPlacement.BAR_CENTER) {
                    float f6 = (float)((d6 + d5) / 2.0);
                    f4 = (float)((double)f6 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                } else if (this.\u011c == BarLabelPlacement.CENTER) {
                    float f7 = (float)d7;
                    f4 = (float)((double)f7 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                } else if (this.\u011c == BarLabelPlacement.BEFORE_BAR_END) {
                    f4 = (float)d6 + (float)fontMetrics.getAscent();
                } else if (this.\u011c == BarLabelPlacement.AFTER_BAR_END) {
                    f4 = (float)d6 - (float)fontMetrics.getDescent();
                } else if (this.\u011c == BarLabelPlacement.END) {
                    f4 = (float)n3 + (float)fontMetrics.getAscent();
                } else {
                    throw new IllegalArgumentException("Unexpected value for labelPlacement: " + (Object)((Object)this.\u011c));
                }
                graphics2D.drawString(string, f5, f4);
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n2, int n3) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Paint paint = indicatorStyle.getFill();
        graphics2D.setPaint(paint);
        int n4 = 4;
        double d2 = 0.75;
        double d3 = 0.75 * (double)n3;
        Rectangle rectangle = new Rectangle(4, (int)Math.ceil((double)n3 * 0.25 / 2.0), n2 - 8, (int)Math.ceil(d3));
        graphics2D.fill(rectangle);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            float f2 = indicatorStyle.getOutlineWidth();
            object = new BasicStroke(f2);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color);
            graphics2D.draw(rectangle);
        }
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            object = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage((Image)object, 0, 0, bullet);
        }
        graphics.drawImage(bufferedImage, 0, 0, bullet);
        graphics2D.dispose();
        return null;
    }
}

