/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class ColumnGuide {
    public static final int UNIT_IN_COLUMNS = 0;
    public static final int UNIT_IN_PIXELS = 1;
    public static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private int \u0102;
    private int \u0103;
    private Color \u0104;
    private Stroke \u0101;

    public ColumnGuide(int n2) {
        this(n2, 0, DEFAULT_COLOR);
    }

    public ColumnGuide(int n2, int n3) {
        this(n2, n3, DEFAULT_COLOR);
    }

    public ColumnGuide(int n2, Color color) {
        this(n2, 0, color);
    }

    public ColumnGuide(int n2, int n3, Color color) {
        this.\u0102 = n2;
        this.\u0103 = n3;
        this.\u0104 = color;
    }

    public int getLocation() {
        return this.\u0102;
    }

    public void setLocation(int n2) {
        this.\u0102 = n2;
    }

    public int getUnit() {
        return this.\u0103;
    }

    public void setUnit(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid value. The unit must be either ColumnGuide.UNIT_IN_COLUMNS or ColumnGuide.UNIT_IN_PIXELS.");
        }
        this.\u0103 = n2;
    }

    public Color getColor() {
        return this.\u0104;
    }

    public void setColor(Color color) {
        this.\u0104 = color;
    }

    public Stroke getStroke() {
        return this.\u0101;
    }

    public void setStroke(Stroke stroke) {
        this.\u0101 = stroke;
    }

    public void paint(CodeEditor codeEditor, Graphics graphics, Rectangle rectangle) {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.getColor());
        if (this.getStroke() != null) {
            graphics2D.setStroke(this.getStroke());
        }
        int n3 = n2 = this.getUnit() == 1 ? this.getLocation() : this.getLocation() * codeEditor.getPainter().getFontMetrics().charWidth('w');
        if (n2 > rectangle.x && n2 < rectangle.x + rectangle.width) {
            graphics2D.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
        }
        graphics2D.setColor(color);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        }
    }
}

