/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.D;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class DocumentComponent {
    private static final Logger \u0113;
    private String \u010d;
    private String \u010c;
    private String \u010f;
    private Icon \u0109;
    private Color \u0110;
    private Color \u0108;
    private JComponent \u0112;
    private boolean \u0104 = true;
    private boolean \u010e = true;
    private boolean \u010b = true;
    private IDocumentPane \u010a;
    private final EventListenerList \u0103 = new EventListenerList();
    private Component \u0114;
    private Component \u0101;
    private JideFocusTracker \u0107;
    private FocusAdapter \u0111;
    private D \u0106;
    private D \u0102;
    private PropertyChangeSupport \u0105;
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TOOLTIP = "tooltip";
    public static final String PROPERTY_BACKGROUND = "background";
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_COMPONENT = "component";
    public static final String PROPERTY_CLOSABLE = "closable";
    public static final String PROPERTY_ENABLED = "enabled";

    public DocumentComponent(JComponent jComponent, String string) {
        this(jComponent, string, string, null);
    }

    public DocumentComponent(JComponent jComponent, String string, String string2) {
        this(jComponent, string, string2, null);
    }

    public DocumentComponent(JComponent jComponent, String string, String string2, Icon icon) {
        this.\u010d = string;
        this.\u010c = string2;
        this.\u0109 = icon;
        this.\u0111 = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DocumentComponent.this.setLastFocusedComponent(focusEvent.getComponent());
            }
        };
        this.setComponent(jComponent);
    }

    public IDocumentPane getDocumentPane() {
        return this.\u010a;
    }

    public void cleanup() {
        if (this.\u0107 != null) {
            this.\u0107.removeFocusListener(this.\u0111);
            this.\u0107.setHeighestComponent(null);
            this.\u0107 = null;
        }
    }

    protected void setDocumentPane(IDocumentPane iDocumentPane) {
        if (this.\u010a instanceof PropertyChangeListener) {
            this.removePropertyChangeListener(PROPERTY_CLOSABLE, (PropertyChangeListener)((Object)this.\u010a));
        }
        this.\u010a = iDocumentPane;
        if (this.\u010a instanceof PropertyChangeListener) {
            this.addPropertyChangeListener(PROPERTY_CLOSABLE, (PropertyChangeListener)((Object)this.\u010a));
        }
    }

    public String getName() {
        return this.\u010d;
    }

    public void setName(String string) {
        String string2 = this.\u010d;
        if (!JideSwingUtilities.equals(string2, string)) {
            this.\u010d = string;
            this.renamePreviousState(string2, this.\u010d, this.\u0106);
            this.renamePreviousState(string2, this.\u010d, this.\u0102);
        }
    }

    protected void renamePreviousState(String string, String string2, D d2) {
        if (d2 != null && d2.\u0103 != null) {
            List<String> list = d2.\u0103;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string3 = list.get(i2);
                if (!string3.equals(string)) continue;
                list.set(i2, string2);
            }
            List<List<String>> list2 = d2.\u0104;
            for (List list3 : list2) {
                for (int i3 = 0; i3 < list3.size(); ++i3) {
                    String string4 = (String)list3.get(i3);
                    if (!string4.equals(string)) continue;
                    list.set(i3, string2);
                }
            }
        }
    }

    public String getTitle() {
        return this.\u010c;
    }

    public void setTitle(String string) {
        String string2 = this.\u010c;
        this.\u010c = string;
        this.firePropertyChange(PROPERTY_TITLE, string2, this.\u010c);
    }

    public String getTooltip() {
        if (this.\u010f == null) {
            String string = this.getTitle();
            if (this.getDocumentPane() != null && this.getDocumentPane().getTitleConverter() != null) {
                string = this.getDocumentPane().getTitleConverter().convert(string);
            }
            return string;
        }
        return this.\u010f;
    }

    public void setTooltip(String string) {
        String string2 = this.\u010f;
        this.\u010f = string;
        this.firePropertyChange(PROPERTY_TOOLTIP, string2, this.\u010f);
    }

    public Icon getIcon() {
        return this.\u0109;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.\u0109;
        this.\u0109 = icon;
        this.firePropertyChange(PROPERTY_ICON, icon2, this.\u0109);
    }

    public Color getBackground() {
        return this.\u0110;
    }

    public void setBackground(Color color) {
        Color color2 = this.\u0110;
        this.\u0110 = color;
        this.firePropertyChange(PROPERTY_BACKGROUND, color2, this.\u0110);
    }

    public Color getForeground() {
        return this.\u0108;
    }

    public void setForeground(Color color) {
        Color color2 = this.\u0108;
        this.\u0108 = color;
        this.firePropertyChange(PROPERTY_FOREGROUND, color2, this.\u0108);
    }

    public JComponent getComponent() {
        return this.\u0112;
    }

    public void setComponent(JComponent jComponent) {
        JComponent jComponent2 = this.\u0112;
        if (this.\u0112 != null && this.\u0107 != null) {
            this.\u0107.removeFocusListener(this.\u0111);
            this.\u0107 = null;
        }
        this.\u0112 = jComponent;
        if (this.\u0112 != null) {
            this.\u0112.setMinimumSize(new Dimension(0, 0));
            this.\u0107 = new JideFocusTracker(this.\u0112);
            this.\u0107.addFocusListener(this.\u0111);
        }
        this.firePropertyChange(PROPERTY_COMPONENT, jComponent2, this.\u0112);
    }

    public String getDisplayTitle() {
        return this.getTitle();
    }

    public void setAllowClosing(boolean bl) {
        this.\u0104 = bl;
    }

    public boolean allowClosing() {
        return this.\u0104;
    }

    public void setAllowMoving(boolean bl) {
        this.\u010e = bl;
    }

    public boolean allowMoving() {
        return this.\u010e;
    }

    public void addDocumentComponentListener(DocumentComponentListener documentComponentListener) {
        this.\u0103.add(DocumentComponentListener.class, documentComponentListener);
    }

    public void removeDocumentComponentListener(DocumentComponentListener documentComponentListener) {
        this.\u0103.remove(DocumentComponentListener.class, documentComponentListener);
    }

    public DocumentComponentListener[] getDocumentComponentListeners() {
        return (DocumentComponentListener[])this.\u0103.getListeners(DocumentComponentListener.class);
    }

    void \u0101(int n2) {
        if (\u0113.isLoggable(Level.FINE)) {
            switch (n2) {
                case 5999: {
                    \u0113.fine("Document " + this.getName() + " opened");
                    break;
                }
                case 6000: {
                    \u0113.fine("Document " + this.getName() + " closing");
                    break;
                }
                case 6001: {
                    \u0113.fine("Document " + this.getName() + " closed");
                    break;
                }
                case 6002: {
                    \u0113.fine("Document " + this.getName() + " activated");
                    break;
                }
                case 6003: {
                    \u0113.fine("Document " + this.getName() + " deactivated");
                    break;
                }
                case 6004: {
                    \u0113.fine("Document " + this.getName() + " moving");
                    break;
                }
                case 6005: {
                    \u0113.fine("Document " + this.getName() + " moved");
                    break;
                }
                case 6006: {
                    \u0113.fine("Document " + this.getName() + " docked");
                    break;
                }
                case 6007: {
                    \u0113.fine("Document " + this.getName() + " floated");
                    break;
                }
            }
        }
        Object[] objectArray = this.\u0103.getListenerList();
        AWTEvent aWTEvent = null;
        block22: for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DocumentComponentListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DocumentComponentEvent(this, n2);
            }
            switch (aWTEvent.getID()) {
                case 5999: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentOpened((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6000: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentClosing((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6001: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentClosed((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6002: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentActivated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6003: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentDeactivated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6004: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentMoving((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6005: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentMoved((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6006: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentDocked((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
                case 6007: {
                    ((DocumentComponentListener)objectArray[i2 + 1]).documentComponentFloated((DocumentComponentEvent)aWTEvent);
                    continue block22;
                }
            }
        }
    }

    public Component getDefaultFocusComponent() {
        if (this.\u0114 == null) {
            return this.\u0112;
        }
        return this.\u0114;
    }

    public void setDefaultFocusComponent(Component component) {
        this.\u0114 = component;
    }

    public Component getLastFocusedComponent() {
        return this.\u0101;
    }

    protected void setLastFocusedComponent(Component component) {
        this.\u0101 = component;
    }

    public void refocusLastFocusedComponent() {
        Component component;
        if (this.\u0112 != this.getLastFocusedComponent() && JideSwingUtilities.passesFocusabilityTest(component = this.getLastFocusedComponent())) {
            this.\u0101(component);
            return;
        }
        if (this.\u0112 != this.getDefaultFocusComponent() && JideSwingUtilities.passesFocusabilityTest(component = this.getDefaultFocusComponent())) {
            this.\u0101(component);
            return;
        }
        if (!JideSwingUtilities.compositeRequestFocus(this.\u0112)) {
            this.\u0101(this.\u0112);
        }
    }

    private void \u0101(Component component) {
        Container container;
        component.requestFocusInWindow();
        if (component instanceof JComponent && (container = ((JComponent)component).getTopLevelAncestor()) instanceof FloatingDocumentContainer) {
            if (container instanceof Frame) {
                if (((Frame)container).getState() == 1) {
                    ((Frame)container).setState(0);
                } else {
                    ((Frame)container).toFront();
                }
            } else {
                ((FloatingDocumentContainer)((Object)container)).toFront();
            }
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.\u0105 == null) {
            this.\u0105 = new PropertyChangeSupport(this);
        }
        this.\u0105.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.\u0105 == null) {
            return;
        }
        this.\u0105.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.\u0105 == null) {
            return new PropertyChangeListener[0];
        }
        return this.\u0105.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.\u0105 == null) {
            this.\u0105 = new PropertyChangeSupport(this);
        }
        this.\u0105.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.\u0105 == null) {
            return;
        }
        this.\u0105.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.\u0105 == null) {
            return new PropertyChangeListener[0];
        }
        return this.\u0105.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.\u0105;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.\u0105;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n2, int n3) {
        PropertyChangeSupport propertyChangeSupport = this.\u0105;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n2, n3);
    }

    public boolean isClosable() {
        return this.\u010b;
    }

    public void setClosable(boolean bl) {
        boolean bl2 = this.\u010b;
        if (bl != bl2) {
            this.\u010b = bl;
            this.firePropertyChange(PROPERTY_CLOSABLE, bl2, this.\u010b);
        }
    }

    public D getDockPreviousState() {
        return this.\u0106;
    }

    public void setDockPreviousState(D d2) {
        this.\u0106 = d2;
    }

    public D getFloatPreviousState() {
        return this.\u0102;
    }

    public void setFloatPreviousState(D d2) {
        this.\u0102 = d2;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(DocumentComponent.class.getName(), 2);
        }
        \u0113 = Logger.getLogger(DocumentComponentEvent.class.getName());
    }
}

