/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.BasicDiffPane;
import com.jidesoft.diff.C;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffSegment;
import com.jidesoft.diff.DiffSpan;
import com.jidesoft.diff.DiffTokens;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.E;
import com.jidesoft.diff.G;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarkerSupport;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;

public class CodeEditorDiffPane
extends BasicDiffPane<CharSequence> {
    protected CodeEditor _fromEditor;
    protected CodeEditor _toEditor;
    private boolean \u0128 = false;
    private boolean \u0135 = true;
    private boolean \u012e = false;
    private int \u012f = 0;
    private int \u012d = 0;
    private Timer \u012c;
    protected static char[] separators = new char[]{'.', ',', ';', ':', '=', '<', '>', '(', ')', '/', '+', '-', '[', ']'};
    private boolean \u0132 = false;
    private boolean \u0129 = false;
    private AdjustmentListener \u0131;
    private AdjustmentListener \u012b;
    private AdjustmentListener \u0130;
    private AdjustmentListener \u0133;
    private CaretListener \u0134;
    private CaretListener \u012a;

    public CodeEditorDiffPane() {
        super("", "");
    }

    public CodeEditorDiffPane(CharSequence charSequence, CharSequence charSequence2) {
        super(charSequence, charSequence2);
    }

    @Override
    void \u0103() {
        SyntaxDocument syntaxDocument = this._fromEditor.getDocument();
        SyntaxDocument syntaxDocument2 = this._toEditor.getDocument();
        this._fromEditor.setDocument(syntaxDocument2);
        this._toEditor.setDocument(syntaxDocument);
    }

    @Override
    public JComponent createComponent(Object object, int n2) {
        CodeEditor codeEditor = this.createEditor(n2);
        codeEditor.setText(object == null ? null : object.toString());
        return codeEditor;
    }

    @Override
    public JComponent createPane(Object object, int n2) {
        if (n2 == 0) {
            this._fromComponent = this.createComponent(object, n2);
            if (this._fromComponent instanceof CodeEditor) {
                this._fromEditor = (CodeEditor)this._fromComponent;
            } else {
                JideSwingUtilities.setRecursively(this._fromComponent, new JideSwingUtilities.Handler(){

                    @Override
                    public boolean condition(Component component) {
                        return component instanceof CodeEditor;
                    }

                    @Override
                    public void action(Component component) {
                        CodeEditorDiffPane.this._fromEditor = (CodeEditor)component;
                    }

                    @Override
                    public void postAction(Component component) {
                    }
                });
            }
            if (this._fromEditor == null) {
                throw new IllegalArgumentException("The from component created by createComponent() does not contain a CodeEditor.");
            }
            this._fromEditor.setEditable(false);
            this._fromRowMarginSupport = this.createRowMarginSupport(this._fromEditor, null);
            this._fromDiffMargin = this.createDiffMargin(this._fromRowMarginSupport, true);
            this._fromDiffLineNumberMargin = new C(this._fromRowMarginSupport);
            this._fromMarkerArea = new com.jidesoft.diff.A(this._fromEditor);
            ((com.jidesoft.diff.A)this._fromMarkerArea).\u0103(this.getChangedColor());
            ((com.jidesoft.diff.A)this._fromMarkerArea).\u0104(this.getInsertedColor());
            ((com.jidesoft.diff.A)this._fromMarkerArea).\u0102(this.getDeletedColor());
            this._fromEditor.setMarkerArea(this._fromMarkerArea);
            this._fromEditor.getMarginArea().removeAll();
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffMargin);
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffLineNumberMargin);
            this._fromEditor.swap();
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add(this._fromComponent);
            jPanel.add((Component)this._fromMarkerArea, "Before");
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add(jPanel);
            this._fromTitle = this.createFromTitle();
            jPanel2.add((Component)this._fromTitle, "First");
            return jPanel2;
        }
        this._toComponent = this.createComponent(object, n2);
        if (this._toComponent instanceof CodeEditor) {
            this._toEditor = (CodeEditor)this._toComponent;
        } else {
            JideSwingUtilities.setRecursively(this._toComponent, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component component) {
                    return component instanceof CodeEditor;
                }

                @Override
                public void action(Component component) {
                    CodeEditorDiffPane.this._toEditor = (CodeEditor)component;
                }

                @Override
                public void postAction(Component component) {
                }
            });
        }
        if (this._toEditor == null) {
            throw new IllegalArgumentException("The to component created by createComponent() does not contain a CodeEditor.");
        }
        this._toRowMarginSupport = this.createRowMarginSupport(this._toEditor, null);
        this._toDiffMargin = this.createDiffMargin(this._toRowMarginSupport, false);
        this._toDiffLineNumberMargin = new C(this._toRowMarginSupport);
        this._toMarkerArea = new com.jidesoft.diff.A(this._toEditor);
        ((com.jidesoft.diff.A)this._toMarkerArea).\u0103(this.getChangedColor());
        ((com.jidesoft.diff.A)this._toMarkerArea).\u0104(this.getInsertedColor());
        ((com.jidesoft.diff.A)this._toMarkerArea).\u0102(this.getDeletedColor());
        this._toEditor.setMarkerArea(this._toMarkerArea);
        this._toEditor.getMarginArea().removeAll();
        this._toEditor.getMarginArea().addMarginComponent(this._toDiffLineNumberMargin);
        this._toEditor.getMarginArea().addMarginComponent(this._toDiffMargin);
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add(this._toComponent);
        jPanel.add((Component)this._toMarkerArea, "After");
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        jPanel3.add(jPanel);
        this._toTitle = this.createToTitle();
        jPanel3.add((Component)this._toTitle, "First");
        return jPanel3;
    }

    @Override
    protected void customizePane(JComponent jComponent, int n2) {
        CodeEditor codeEditor;
        super.customizePane(jComponent, n2);
        CodeEditor codeEditor2 = codeEditor = n2 == 0 ? this._fromEditor : this._toEditor;
        if (codeEditor != null) {
            codeEditor.setLineHighlight(false);
            codeEditor.getMarkerArea().getMarkerEye().setVisible(false);
        }
        this.customizeEditor(codeEditor, n2);
    }

    @Override
    protected MarkerSupport createMarkerSupport(JComponent jComponent) {
        return new CodeEditorMarkerSupport((CodeEditor)jComponent);
    }

    @Override
    protected RowMarginSupport createRowMarginSupport(JComponent jComponent, JScrollPane jScrollPane) {
        return new CodeEditorRowMarginSupport((CodeEditor)jComponent);
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n2) {
        FontMetrics fontMetrics = this._fromEditor.getPainter().getFontMetrics();
        int n3 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        diffDivider.adjustFirstVerticalOffset(n3 - 2, 2 + this._fromTitle.getPreferredSize().height);
        fontMetrics = this._toEditor.getPainter().getFontMetrics();
        n3 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        diffDivider.adjustSecondVerticalOffset(n3 - 2, 2 + this._toTitle.getPreferredSize().height);
    }

    protected CodeEditor createEditor(int n2) {
        return this.createEditor();
    }

    protected CodeEditor createEditor() {
        return new CodeEditor();
    }

    protected void customizeEditor(CodeEditor codeEditor, int n2) {
    }

    public CharSequence[] getFromItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._fromEditor.getLineCount()];
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            charSequenceArray[i2] = this.getLineCharSequence(this._fromEditor, i2);
        }
        return charSequenceArray;
    }

    public CharSequence[] getToItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._toEditor.getLineCount()];
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            charSequenceArray[i2] = this.getLineCharSequence(this._toEditor, i2);
        }
        return charSequenceArray;
    }

    protected CharSequence getLineCharSequence(CodeEditor codeEditor, int n2) {
        return this.getSegment(codeEditor, n2, n2);
    }

    protected Segment getFromSegment(int n2, int n3) {
        return this.getSegment(this._fromEditor, n2, n3);
    }

    protected Segment getToSegment(int n2, int n3) {
        return this.getSegment(this._toEditor, n2, n3);
    }

    protected Segment getSegment(CodeEditor codeEditor, int n2, int n3) {
        DiffSegment diffSegment = new DiffSegment(this.isIgnoreWhitespaces(), this.is_caseSensitive());
        int n4 = codeEditor.getDocument().getLineStartOffset(n2);
        int n5 = codeEditor.getDocument().getLineEndOffset(n3);
        try {
            codeEditor.getDocument().getText(n4, n5 + 1 - n4, diffSegment);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return diffSegment;
    }

    public boolean isIgnoreWhitespaces() {
        return this.\u0135;
    }

    public void setIgnoreWhitespaces(boolean bl) {
        this.\u0135 = bl;
    }

    public boolean is_caseSensitive() {
        return this.\u012e;
    }

    public void set_caseSensitive(boolean bl) {
        this.\u012e = bl;
    }

    public void setFromText(String string) {
        try {
            this.\u0128 = true;
            this._fromEditor.setText(string);
        }
        finally {
            this.\u0128 = false;
        }
    }

    public String getFromText() {
        return this._fromEditor.getText();
    }

    @Override
    public Diff<?> createLinesDiff(int n2, int n3, int n4, int n5) {
        this.\u012f = 0;
        this.\u012d = 0;
        Segment segment = this.getFromSegment(n2, n3);
        Segment segment2 = this.getToSegment(n4, n5);
        return new Diff<Segment>(this.getDiffTokens(segment).getTokenValues(), this.getDiffTokens(segment2).getTokenValues());
    }

    protected Character[] getFromText(int n2, int n3) {
        Object object;
        int n4;
        int n5;
        if (n2 > n3) {
            n5 = n3;
            n3 = n2;
            n2 = n5;
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        n5 = this._fromEditor.getLineStartOffset(n2);
        Object object2 = this._fromEditor.getText(n5, (n4 = n3 >= this._fromEditor.getLineCount() ? this._fromEditor.getDocumentLength() : this._fromEditor.getLineEndOffset(n3)) - n5 + 1);
        if (object2 == null) {
            return new Character[0];
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            object = ((String)object2).trim();
            this.\u012f = ((String)object2).indexOf((String)object);
            object2 = object;
        }
        object = ((String)object2).toCharArray();
        Character[] characterArray = new Character[((Object)object).length];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            characterArray[i2] = Character.valueOf((char)object[i2]);
        }
        return characterArray;
    }

    protected Character[] getToText(int n2, int n3) {
        Object object;
        int n4;
        int n5;
        if (n2 > n3) {
            n5 = n3;
            n3 = n2;
            n2 = n5;
        }
        n2 = Math.max(0, n2);
        n3 = Math.max(0, n3);
        n5 = this._toEditor.getLineStartOffset(n2);
        Object object2 = this._toEditor.getText(n5, (n4 = n3 >= this._toEditor.getLineCount() ? this._toEditor.getDocumentLength() : this._toEditor.getLineEndOffset(n3)) - n5 + 1);
        if (object2 == null) {
            return new Character[0];
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            object = ((String)object2).trim();
            this.\u012d = ((String)object2).indexOf((String)object);
            object2 = object;
        }
        object = ((String)object2).toCharArray();
        Character[] characterArray = new Character[((Object)object).length];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            characterArray[i2] = Character.valueOf((char)object[i2]);
        }
        return characterArray;
    }

    public void setToText(String string) {
        try {
            this.\u0128 = true;
            this._toEditor.setText(string);
        }
        finally {
            this.\u0128 = false;
        }
    }

    public String getToText() {
        return this._toEditor.getText();
    }

    protected void synchronizeViewport(DiffDivider diffDivider, boolean bl) {
        if (bl) {
            int n2 = this._fromEditor.getFirstLine();
            int n3 = diffDivider.getSecondMatchLine(Math.min(this._fromEditor.getVisualLineCount(), this._fromEditor.getVisibleLines()), n2);
            if (n3 < this._toEditor.getVisualLineCount()) {
                this._toEditor.setFirstLine(n3);
            }
        } else {
            int n4 = this._toEditor.getFirstLine();
            int n5 = diffDivider.getFirstMatchLine(Math.min(this._toEditor.getVisualLineCount(), this._toEditor.getVisibleLines()), n4);
            if (n5 < this._fromEditor.getVisualLineCount()) {
                this._fromEditor.setFirstLine(n5);
            }
        }
    }

    protected void synchronizeViewportHorizontally(boolean bl) {
        if (bl) {
            int n2 = this._fromEditor.getHorizontalOffset();
            this._toEditor.setHorizontalOffset(n2);
        } else {
            int n3 = this._toEditor.getHorizontalOffset();
            this._fromEditor.setHorizontalOffset(n3);
        }
    }

    @Override
    protected int getSelectedIndex(int n2) {
        CodeEditor codeEditor = n2 == 0 ? this._fromEditor : this._toEditor;
        int n3 = codeEditor.getCaretPosition();
        return codeEditor.getLineNumber(n3);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.\u0131 != null) {
            this._fromEditor.getVerticalScrollBar().removeAdjustmentListener(this.\u0131);
        }
        if (this.\u012b != null) {
            this._fromEditor.getHorizontalScrollBar().removeAdjustmentListener(this.\u012b);
        }
        this.\u0131 = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this.\u0132) {
                    return;
                }
                CodeEditorDiffPane.this.\u0129 = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewport(CodeEditorDiffPane.this._fromToDivider, true);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this.\u0129 = false;
                }
            }
        };
        this.\u012b = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this.\u0132) {
                    return;
                }
                CodeEditorDiffPane.this.\u0129 = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewportHorizontally(true);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this.\u0129 = false;
                }
            }
        };
        this._fromEditor.getVerticalScrollBar().addAdjustmentListener(this.\u0131);
        this._fromEditor.getHorizontalScrollBar().addAdjustmentListener(this.\u012b);
        if (this.\u0130 != null) {
            this._toEditor.getVerticalScrollBar().removeAdjustmentListener(this.\u0130);
        }
        if (this.\u0133 != null) {
            this._toEditor.getHorizontalScrollBar().removeAdjustmentListener(this.\u0133);
        }
        this.\u0130 = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this.\u0129) {
                    return;
                }
                CodeEditorDiffPane.this.\u0132 = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewport(CodeEditorDiffPane.this._fromToDivider, false);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this.\u0132 = false;
                }
            }
        };
        this.\u0133 = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this.\u0129) {
                    return;
                }
                CodeEditorDiffPane.this.\u0132 = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewportHorizontally(false);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this.\u0132 = false;
                }
            }
        };
        this._toEditor.getVerticalScrollBar().addAdjustmentListener(this.\u0130);
        this._toEditor.getHorizontalScrollBar().addAdjustmentListener(this.\u0133);
        if (this.\u0134 != null) {
            this._fromEditor.getCaretModel().removeCaretListener(this.\u0134);
        }
        this.\u0134 = new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorDiffPane.this.\u0102(0);
            }
        };
        this._fromEditor.getCaretModel().addCaretListener(this.\u0134);
        if (this.\u012a != null) {
            this._toEditor.getCaretModel().removeCaretListener(this.\u012a);
        }
        this.\u012a = new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorDiffPane.this.\u0102(1);
            }
        };
        this._toEditor.getCaretModel().addCaretListener(this.\u012a);
        this.\u012c = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CodeEditorDiffPane.this._diffed) {
                    CodeEditorDiffPane.this.runDiff();
                }
            }
        });
        A a2 = new A();
        this._toEditor.getDocument().addDocumentListener(a2);
        this._fromEditor.getDocument().addDocumentListener(a2);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.\u0131 != null && this._fromEditor != null) {
            this._fromEditor.getVerticalScrollBar().removeAdjustmentListener(this.\u0131);
        }
        if (this.\u0130 != null && this._toEditor != null) {
            this._toEditor.getVerticalScrollBar().removeAdjustmentListener(this.\u0130);
        }
        if (this.\u0134 != null && this._fromEditor != null) {
            this._fromEditor.getCaretModel().removeCaretListener(this.\u0134);
        }
        if (this.\u012a != null && this._toEditor != null) {
            this._toEditor.getCaretModel().removeCaretListener(this.\u012a);
        }
        if (this._fromEditor != null) {
            for (DocumentListener documentListener : this._fromEditor.getDocument().getDocumentListeners()) {
                if (!(documentListener instanceof A)) continue;
                this._fromEditor.getDocument().removeDocumentListener(documentListener);
            }
        }
        if (this._toEditor != null) {
            for (DocumentListener documentListener : this._toEditor.getDocument().getDocumentListeners()) {
                if (!(documentListener instanceof A)) continue;
                this._toEditor.getDocument().removeDocumentListener(documentListener);
            }
        }
        this.\u0131 = null;
        this.\u0130 = null;
        this.\u0134 = null;
        this.\u012a = null;
    }

    @Deprecated
    protected String[] splitString(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        String[] stringArray = string.split(string2);
        if (this.isIgnoreLeadingTrailingSpaces()) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
            }
        }
        return stringArray;
    }

    private Character[] \u0101(String string) {
        Character[] characterArray = new Character[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            characterArray[i2] = Character.valueOf(string.charAt(i2));
        }
        return characterArray;
    }

    @Override
    public void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        this._toEditor.setEditable(!bl);
    }

    @Override
    public void clearHighlights() {
        this._fromEditor.getFixedHighlighter().removeAllHighlights();
        this._toEditor.getFixedHighlighter().removeAllHighlights();
        this._fromEditor.getMarkerModel().clearMarkers();
        this._toEditor.getMarkerModel().clearMarkers();
    }

    @Override
    public void startHighlights() {
        this._fromEditor.getMarkerModel().setAdjusting(true);
        this._toEditor.getMarkerModel().setAdjusting(true);
    }

    @Override
    public void endHighlights() {
        this._fromEditor.getMarkerModel().setAdjusting(false);
        this._toEditor.getMarkerModel().setAdjusting(false);
    }

    @Override
    public void highlightChangedExactly(List<Difference> list, int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        int n6 = this._fromEditor.getLineStartOffset(n2);
        int n7 = n3 >= 0 ? this._fromEditor.getLineEndOffset(n3) + 1 : 0;
        int n8 = this._toEditor.getLineStartOffset(n4);
        int n9 = n5 >= 0 ? this._toEditor.getLineEndOffset(n5) + 1 : 0;
        Segment segment = this.getFromSegment(n2, n3);
        List<DiffSpan> list2 = this.getDiffTokens(segment).getTokenSpans();
        Segment segment2 = this.getToSegment(n4, n5);
        List<DiffSpan> list3 = this.getDiffTokens(segment2).getTokenSpans();
        try {
            CodeEditorDiffPane.\u0101(this._fromEditor, n6, n7, color2);
            CodeEditorDiffPane.\u0101(this._toEditor, n8, n9, color2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        for (Difference difference : list) {
            DiffSpan diffSpan;
            int n10;
            Color color3;
            int n11 = difference.getDeletedStart();
            int n12 = difference.getDeletedEnd();
            int n13 = difference.getAddedStart();
            int n14 = difference.getAddedEnd();
            if (n12 == -1) {
                color3 = this._fromToDivider.getInsertedColor();
                for (n10 = n13; n10 < n14 + 1; ++n10) {
                    diffSpan = list3.get(n10);
                    try {
                        this._toEditor.getFixedHighlighter().addHighlight(n8 + diffSpan.getStartIndex(), n8 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (n14 == -1) {
                color3 = this._fromToDivider.getDeletedColor();
                for (n10 = n11; n10 < n12 + 1; ++n10) {
                    diffSpan = list2.get(n10);
                    try {
                        this._fromEditor.getFixedHighlighter().addHighlight(n6 + diffSpan.getStartIndex(), n6 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                continue;
            }
            color3 = this._fromToDivider.getChangedColor();
            for (n10 = n13; n10 < n14 + 1; ++n10) {
                diffSpan = list3.get(n10);
                try {
                    this._toEditor.getFixedHighlighter().addHighlight(n8 + diffSpan.getStartIndex(), n8 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            for (n10 = n11; n10 < n12 + 1; ++n10) {
                diffSpan = list2.get(n10);
                try {
                    this._fromEditor.getFixedHighlighter().addHighlight(n6 + diffSpan.getStartIndex(), n6 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this._fromEditor.getMarkerModel().addMarker(n6, n7 + 1, 124, "");
        this._toEditor.getMarkerModel().addMarker(n8, n9, 124, string);
    }

    private boolean \u0101(char c2) {
        return Arrays.binarySearch(separators, c2) >= 0;
    }

    protected DiffTokens getDiffTokens(Segment segment) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        ArrayList<DiffSpan> arrayList2 = new ArrayList<DiffSpan>();
        boolean bl = false;
        char c2 = segment.first();
        int n2 = 0;
        int n3 = 0;
        while (c2 != '\uffff') {
            if (n3 - n2 != 0) {
                if (this.\u0101(segment.charAt(n3 - 1))) {
                    bl = true;
                } else if (Character.isWhitespace(segment.charAt(n3 - 1))) {
                    if (!Character.isWhitespace(c2)) {
                        bl = true;
                    }
                } else if (Character.isWhitespace(c2)) {
                    bl = true;
                } else if (this.\u0101(c2)) {
                    bl = true;
                }
            }
            if (bl) {
                if (!this.isIgnoreWhitespaces() || !Character.isWhitespace(segment.charAt(n3 - 1))) {
                    arrayList.add((Segment)segment.subSequence(n2, n3));
                    arrayList2.add(new DiffSpan(n2, n3));
                }
                n2 = n3;
                bl = false;
            }
            c2 = segment.next();
            ++n3;
        }
        if (!(n2 == segment.length() - 1 || this.isIgnoreWhitespaces() && Character.isWhitespace(segment.charAt(n2)))) {
            arrayList.add((Segment)segment.subSequence(n2, segment.length() - 1));
            arrayList2.add(new DiffSpan(n2, segment.length() - 1));
        }
        return new DiffTokens(arrayList, arrayList2);
    }

    @Override
    public void highlightChanged(int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        try {
            Difference difference = this.\u0103(0, n2);
            n2 = this._fromEditor.getLineStartOffset(n2);
            n3 = n3 >= 0 ? this._fromEditor.getLineEndOffset(n3) + 1 : 0;
            n4 = this._toEditor.getLineStartOffset(n4);
            n5 = n5 >= 0 ? this._toEditor.getLineEndOffset(n5) + 1 : 0;
            CodeEditorDiffPane.\u0101(this._fromEditor, n2, n3, color2);
            this._fromEditor.getFixedHighlighter().addHighlight(n2, n3, new G(color, this._fromToDivider, difference));
            this._fromEditor.getMarkerModel().addMarker(n2, n3 + 1, 124, "");
            CodeEditorDiffPane.\u0101(this._toEditor, n4, n5, color2);
            this._toEditor.getFixedHighlighter().addHighlight(n4, n5, new G(color, this._fromToDivider, difference));
            this._toEditor.getMarkerModel().addMarker(n4, n5, 124, string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    static void \u0101(CodeEditor codeEditor, int n2, int n3, Color color) throws BadLocationException {
        E e2 = new E(color);
        if (n2 != n3) {
            e2.\u0101(n2);
        } else if (n2 >= codeEditor.getDocumentLength()) {
            n2 = codeEditor.getLineStartOffset(codeEditor.getLineCount() - 1);
            n3 = codeEditor.getLineEndOffset(codeEditor.getLineCount() - 1);
        } else {
            n3 = codeEditor.getLineEndOffset(codeEditor.getLineNumber(n2));
        }
        e2.\u0102(n3);
        codeEditor.getFixedHighlighter().addHighlight(n2, n3, e2);
    }

    @Override
    public void highlightInserted(int n2, int n3, int n4, Color color, Color color2, String string) {
        try {
            Difference difference = this.\u0103(0, n2);
            int n5 = this._fromEditor.getLineStartOffset(n2);
            int n6 = this._toEditor.getLineStartOffset(n3);
            int n7 = n4 >= 0 ? this._toEditor.getLineEndOffset(n4) + 1 : 0;
            CodeEditorDiffPane.\u0101(this._toEditor, n6, n7, color2);
            this._toEditor.getFixedHighlighter().addHighlight(n6, n7, new G(color, this._fromToDivider, difference));
            this._toEditor.getMarkerModel().addMarker(n6, n7, 125, string);
            CodeEditorDiffPane.\u0101(this._fromEditor, n5, n5, color2);
            this._fromEditor.getMarkerModel().addMarker(n5, n5, 126, "");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void highlightDeleted(int n2, int n3, int n4, Color color, Color color2, String string) {
        try {
            Difference difference = this.\u0103(0, n2);
            int n5 = this._fromEditor.getLineStartOffset(n2);
            int n6 = n3 >= 0 ? this._fromEditor.getLineEndOffset(n3) + 1 : 0;
            int n7 = this._toEditor.getLineStartOffset(n4);
            CodeEditorDiffPane.\u0101(this._fromEditor, n5, n6, color2);
            this._fromEditor.getFixedHighlighter().addHighlight(n5, n6, new G(color, this._fromToDivider, difference));
            this._fromEditor.getMarkerModel().addMarker(n5, n6, 125, "");
            CodeEditorDiffPane.\u0101(this._toEditor, n7, n7, color2);
            this._toEditor.getMarkerModel().addMarker(n7, n7 + 1, 126, string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected List<Difference> acceptDifference(List<Difference> list, Difference difference) {
        boolean bl = false;
        int n2 = 0;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference2 : list) {
            if (difference2.getDeletedStart() == difference.getDeletedStart() && difference2.getDeletedEnd() == difference.getDeletedEnd()) {
                bl = true;
                if (difference.getAddedEnd() == -1) {
                    n2 = -(difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                    continue;
                }
                if (difference.getDeletedEnd() == -1) {
                    n2 = difference.getAddedEnd() - difference.getAddedStart() + 1;
                    continue;
                }
                n2 = difference.getAddedEnd() - difference.getAddedStart() + 1 - (difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                continue;
            }
            if (bl && n2 != 0) {
                difference2.adjustAdded(-n2);
            }
            arrayList.add(difference2);
        }
        return arrayList;
    }

    private void \u0104() {
        if (this._differences == null || this._differences.size() == 0) {
            this.setMessage(this.getResourceString("DiffPane.noChange"));
        } else if (this._differences.size() == 1) {
            this.setMessage(this.getResourceString("DiffPane.oneChange"));
        } else {
            this.setMessage(MessageFormat.format(this.getResourceString("DiffPane.hasChanges"), this._differences.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(int n2, int n3, boolean bl) {
        if (n3 == -1) {
            return false;
        }
        int n4 = this._toEditor.getLineStartOffset(n2);
        int n5 = this._toEditor.getLineStartOffset(n2 + n3);
        this.\u0128 = true;
        try {
            if (n5 > this._toEditor.getDocumentLength()) {
                if (n2 > 0) {
                    n4 = this._toEditor.getLineEndOffset(n2 - 1);
                }
                n5 = this._toEditor.getDocumentLength();
            }
            this._toEditor.getDocument().remove(n4, n5 - n4);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.\u0128 = false;
        }
        if (bl && this._diffed) {
            this.runDiff();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(int n2, int n3, int n4, boolean bl) {
        int n5 = this._toEditor.getLineStartOffset(n2);
        int n6 = this._fromEditor.getLineStartOffset(n3);
        int n7 = this._fromEditor.getLineStartOffset(n3 + n4);
        String string = this._fromEditor.getText(n6, n7 - n6);
        this.\u0128 = true;
        try {
            this._toEditor.getDocument().insertString(n5, string, null);
            this._toEditor.select(n5);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.\u0128 = false;
        }
        if (bl && this._diffed) {
            this.runDiff();
        }
        return true;
    }

    @Deprecated
    public boolean isIgnoreLeadingTrailingSpaces() {
        return this.isIgnoreWhitespaces();
    }

    @Deprecated
    public void setIgnoreLeadingTrailingSpaces(boolean bl) {
        this.setIgnoreWhitespaces(bl);
    }

    static {
        Arrays.sort(separators);
    }

    private class A
    implements DocumentListener {
        private A() {
        }

        private void \u0101() {
            if (CodeEditorDiffPane.this.\u012c == null) {
                return;
            }
            if (CodeEditorDiffPane.this.\u012c.isRunning()) {
                CodeEditorDiffPane.this.\u012c.restart();
            } else {
                CodeEditorDiffPane.this.\u012c.setRepeats(false);
                CodeEditorDiffPane.this.\u012c.start();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this.\u0128) {
                this.\u0101();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this.\u0128) {
                this.\u0101();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this.\u0128) {
                this.\u0101();
            }
        }
    }
}

