/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.event.PointSelectionEvent;
import com.jidesoft.chart.event.RectangleSelectionEvent;
import com.jidesoft.chart.event.ZoomDirection;
import com.jidesoft.chart.event.ZoomListener;
import com.jidesoft.chart.event.ZoomOrientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;

public class RubberBandZoomer
implements Drawable,
MouseMotionListener,
MouseListener {
    public static final String PROPERTY_OUTLINE_STROKE = "Rubber Band Outline Stroke";
    public static final String PROPERTY_OUTLINE_COLOR = "Rubber Band Outline Color";
    public static final String PROPERTY_FILL = "Rubber Band Fill";
    public static final String PROPERTY_KEEP_RATIO = "Rubber Band Keep Ratio";
    public static final String PROPERTY_ZOOM_ORIENTATION = "Zoom Orientation";
    private Point \u01db;
    private boolean \u01dc = false;
    private Rectangle \u01da;
    private Rectangle \u01d9;
    private List<ZoomListener> \u01de = new CopyOnWriteArrayList<ZoomListener>();
    private JComponent \u01df;
    private Stroke \u01e3 = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private Color \u01e4 = Color.blue;
    private Paint \u01e2 = null;
    private boolean \u01dd = false;
    private ZoomOrientation \u01e0 = ZoomOrientation.BOTH;
    private PropertyChangeSupport \u01e1 = new PropertyChangeSupport(this);

    public RubberBandZoomer(JComponent jComponent) {
        this.\u01df = jComponent;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01e1.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01e1.removePropertyChangeListener(propertyChangeListener);
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.\u01de.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.\u01de.remove(zoomListener);
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.\u01e3;
        this.\u01e3 = stroke;
        this.\u01e1.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    public Stroke getOutlineStroke() {
        return this.\u01e3;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.\u01e4;
        this.\u01e4 = color;
        this.\u01e1.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, this.\u01e4);
    }

    public Paint getFill() {
        return this.\u01e2;
    }

    public void setFill(Paint paint) {
        Paint paint2 = this.\u01e2;
        this.\u01e2 = paint;
        this.\u01e1.firePropertyChange(PROPERTY_FILL, paint2, paint);
    }

    public boolean isKeepWidthHeightRatio() {
        return this.\u01dd;
    }

    public void setKeepWidthHeightRatio(boolean bl) {
        boolean bl2 = this.\u01dd;
        this.\u01dd = bl;
        this.\u01e1.firePropertyChange(PROPERTY_KEEP_RATIO, bl2, bl);
    }

    public ZoomOrientation getZoomOrientation() {
        return this.\u01e0;
    }

    public void setZoomOrientation(ZoomOrientation zoomOrientation) {
        ZoomOrientation zoomOrientation2 = this.\u01e0;
        this.\u01e0 = zoomOrientation;
        this.\u01e1.firePropertyChange(PROPERTY_ZOOM_ORIENTATION, (Object)zoomOrientation2, (Object)zoomOrientation);
    }

    protected void fireZoomIn(Rectangle rectangle) {
        RectangleSelectionEvent rectangleSelectionEvent = new RectangleSelectionEvent(this, rectangle);
        for (ZoomListener zoomListener : this.\u01de) {
            zoomListener.zoomChanged(rectangleSelectionEvent);
        }
    }

    protected void fireZoomOut(Point point) {
        PointSelectionEvent pointSelectionEvent = new PointSelectionEvent(this, point, ZoomDirection.OUT);
        for (ZoomListener zoomListener : this.\u01de) {
            zoomListener.zoomChanged(pointSelectionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.\u01db = new Point(n2, n3);
        boolean bl = this.\u01dc = (mouseEvent.getModifiers() & 4) == 4;
        if (this.\u01dc) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u01d9 = this.\u01da;
        this.\u01da = null;
        this.\u01db = null;
        if (this.\u01dc) {
            this.fireZoomOut(mouseEvent.getPoint());
        } else if (this.\u01d9 != null) {
            this.fireZoomIn(this.\u01d9);
            this.\u01df.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.\u01db != null) {
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = Math.min(n2, this.\u01db.x);
            int n5 = Math.min(n3, this.\u01db.y);
            int n6 = Math.max(n2, this.\u01db.x);
            int n7 = Math.max(n3, this.\u01db.y);
            int n8 = n6 - n4;
            int n9 = n7 - n5;
            if (this.\u01df instanceof Chart && this.\u01e0 != ZoomOrientation.BOTH) {
                Chart chart = (Chart)this.\u01df;
                if (this.\u01e0 == ZoomOrientation.HORIZONTAL) {
                    n5 = chart.getYEnd();
                    n7 = chart.getYStart();
                    n3 = n5;
                    n9 = n7 - n5;
                    this.\u01da = new Rectangle(n2 < this.\u01db.x ? this.\u01db.x - n8 : this.\u01db.x, n3, n8, n9);
                } else if (this.\u01e0 == ZoomOrientation.VERTICAL) {
                    n4 = chart.getXStart();
                    n6 = chart.getXEnd();
                    n2 = n4;
                    n8 = n6 - n4;
                    this.\u01da = new Rectangle(n2, n3 < this.\u01db.y ? this.\u01db.y - n9 : this.\u01db.y, n8, n9);
                }
            } else {
                if (this.\u01dd) {
                    int n10 = this.\u01df.getWidth();
                    int n11 = this.\u01df.getHeight();
                    if (this.\u01df instanceof Chart) {
                        n10 = ((Chart)this.\u01df).getChartWidth();
                        n11 = ((Chart)this.\u01df).getChartHeight();
                    }
                    double d2 = (double)n11 / (double)n10;
                    double d3 = d2 * (double)n8;
                    int n12 = n8;
                    double d4 = (double)n9 / d2;
                    int n13 = n9;
                    n8 = (int)(((double)n12 + d4) / 2.0);
                    n9 = (int)((d3 + (double)n13) / 2.0);
                }
                this.\u01da = new Rectangle(n2 < this.\u01db.x ? this.\u01db.x - n8 : this.\u01db.x, n3 < this.\u01db.y ? this.\u01db.y - n9 : this.\u01db.y, n8, n9);
            }
            this.\u01df.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.\u01da != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.\u01e2 != null) {
                graphics2D.setPaint(this.\u01e2);
                graphics2D.fillRect(this.\u01da.x, this.\u01da.y, this.\u01da.width, this.\u01da.height);
            }
            if (this.\u01e4 != null) {
                graphics2D.setColor(this.\u01e4);
                if (this.\u01e3 != null) {
                    graphics2D.setStroke(this.\u01e3);
                }
                graphics2D.drawRect(this.\u01da.x, this.\u01da.y, this.\u01da.width, this.\u01da.height);
            }
            graphics2D.dispose();
        }
    }
}

