/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.Header;
import com.install4j.runtime.installer.platform.macos.macho.LoadCommand;
import com.install4j.runtime.installer.platform.macos.macho.Part;
import com.install4j.runtime.installer.platform.macos.macho.SegmentCommand;
import com.install4j.runtime.installer.platform.macos.macho.VersionCommand;
import com.install4j.runtime.util.BinaryUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MachoFile
implements Part {
    private static int MH_MAGIC = -17958194;
    private static int MH_CIGAM = -822415874;
    private static int MH_MAGIC_64 = -17958193;
    private static int MH_CIGAM_64 = -805638658;
    private static String LINK_EDIT_SEGMENT_NAME = "__LINKEDIT";
    private int magic;
    private Header header;
    private List<LoadCommand> loadCommands = new ArrayList<LoadCommand>();
    private ByteBuffer byteBuffer;

    public MachoFile(ByteBuffer data) throws IOException {
        this.byteBuffer = data;
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.magic = this.byteBuffer.getInt();
        if (!MachoFile.isThinMagic(this.magic)) {
            throw new NoMachoException();
        }
        if (!this.isBigEndian()) {
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.read(this.byteBuffer, this.is64Bit());
    }

    static boolean isThinMagic(int magic) {
        return magic == MH_MAGIC || magic == MH_CIGAM || magic == MH_MAGIC_64 || magic == MH_CIGAM_64;
    }

    public void growLinkSegment(int size) throws IOException {
        for (LoadCommand loadCommand : this.loadCommands) {
            SegmentCommand segmentCommand;
            if (!(loadCommand.getContent() instanceof SegmentCommand) || !(segmentCommand = (SegmentCommand)loadCommand.getContent()).getSegmentName().equals(LINK_EDIT_SEGMENT_NAME)) continue;
            segmentCommand.setFilesize(segmentCommand.getFilesize() + (long)size);
            segmentCommand.setVmsize(segmentCommand.getVmsize() + BinaryUtil.align(size, 4096L));
            return;
        }
    }

    public boolean is64Bit() {
        return this.magic == MH_MAGIC_64 || this.magic == MH_CIGAM_64;
    }

    public boolean isBigEndian() {
        return this.magic == MH_MAGIC_64 || this.magic == MH_MAGIC;
    }

    @Override
    public void read(ByteBuffer buf, boolean bit64) throws IOException {
        this.header = new Header();
        this.header.read(buf, bit64);
        for (int i = 0; i < this.header.getNcmds(); ++i) {
            LoadCommand loadCommand = new LoadCommand();
            loadCommand.read(buf, bit64);
            this.loadCommands.add(loadCommand);
        }
    }

    @Override
    public void write(ByteBuffer buf, boolean bit64) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void appendOrReplaceLoadCommand(LoadCommand loadCommand) throws IOException {
        this.removeLoadCommand(loadCommand.getCmd());
        this.loadCommands.add(loadCommand);
    }

    public void removeLoadCommand(int cmd) throws IOException {
        Iterator<LoadCommand> iterator = this.loadCommands.iterator();
        while (iterator.hasNext()) {
            LoadCommand loadCommand = iterator.next();
            if (loadCommand.getCmd() != cmd) continue;
            iterator.remove();
        }
    }

    public void writeHeaderAndCommands() throws IOException {
        this.header.updateHeader(this.loadCommands);
        this.byteBuffer.position(4);
        this.header.write(this.byteBuffer, this.is64Bit());
        for (LoadCommand loadCommand : this.loadCommands) {
            loadCommand.write(this.byteBuffer, this.is64Bit());
        }
    }

    public void position(int pos) {
        this.byteBuffer.position(pos);
    }

    public void write(byte[] bytes) {
        this.byteBuffer.put(bytes);
    }

    public void setLength(int length) {
        if (this.byteBuffer.capacity() >= length) {
            this.byteBuffer.limit(length);
        } else {
            int pos = this.byteBuffer.position();
            ByteBuffer newBuffer = ByteBuffer.allocate(length);
            newBuffer.order(this.byteBuffer.order());
            newBuffer.put((ByteBuffer)this.byteBuffer.position(0));
            this.byteBuffer = newBuffer;
            this.byteBuffer.position(pos);
        }
    }

    public ByteBuffer getData() {
        return (ByteBuffer)this.byteBuffer.duplicate().position(0);
    }

    public void setMinimumSdkVersion(int version) throws IOException {
        for (LoadCommand loadCommand : this.loadCommands) {
            VersionCommand versionCommand;
            if (!(loadCommand.getContent() instanceof VersionCommand) || (versionCommand = (VersionCommand)loadCommand.getContent()).getSdk() >= version) continue;
            versionCommand.setSdk(version);
            versionCommand.write(this.byteBuffer, this.is64Bit());
        }
    }

    public static class NoMachoException
    extends IOException {
        public NoMachoException(File file) {
            super("no macho file: " + file);
        }

        public NoMachoException() {
            super("no macho file");
        }
    }
}

