/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.StandardDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class RunningProcessesDialog
extends StandardDialog {
    private String message;
    private Collection<String> processes;
    private List<String> buttonTexts;
    private List<JButton> buttons;
    private JList<String> lstProcesses;
    private JScrollPane scpProcesses;
    private int selectedButtonIndex;

    public RunningProcessesDialog(Window parentWindow, String message, Collection<String> processes, List<String> buttonTexts) {
        super(parentWindow);
        GUIHelper.setIconImages(this);
        this.message = message;
        this.processes = processes;
        this.buttonTexts = buttonTexts;
        this.setDefaultCloseOperation(0);
        this.init();
    }

    public int getSelectedButtonIndex() {
        return this.selectedButtonIndex;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int buttonIndex;
        Object source = event.getSource();
        if (source instanceof JButton && (buttonIndex = this.buttons.indexOf(source)) >= 0) {
            this.selectedButtonIndex = buttonIndex;
            this.doOk();
            return;
        }
        super.actionPerformed(event);
    }

    @Override
    protected void addScreenContent(JPanel panel) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.anchor = 23;
        gc.insets = new Insets(0, 0, 15, 0);
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.insets.right = 15;
        panel.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), gc);
        gc.insets.right = 0;
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        DisplayTextArea dtxa = new DisplayTextArea();
        dtxa.setText(this.message);
        panel.add((Component)dtxa, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets.bottom = 0;
        panel.add((Component)this.scpProcesses, gc);
        ++gc.gridy;
    }

    @Override
    protected boolean isFillVertical() {
        return true;
    }

    @Override
    protected JComponent createButtonBox() {
        ArrayList<JButton> allButtons = new ArrayList<JButton>(this.buttons);
        allButtons.add(this.getCancelButton());
        Box box = ButtonUtil.createHorizontalButtonBox(allButtons.toArray(new Component[0]), 0);
        Box buttonBox = new Box(2);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(box);
        return buttonBox;
    }

    @Override
    protected void doCancel() {
        if (GUIHelper.confirmCancel(this)) {
            super.doCancel();
        }
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.lstProcesses = new JList<String>(this.processes.toArray(new String[0]));
        this.scpProcesses = new JScrollPane(this.lstProcesses);
        this.buttons = new ArrayList<JButton>(this.buttonTexts.size());
        for (String buttonText : this.buttonTexts) {
            JButton button = GUIHelper.adjustButton(new JButton(buttonText));
            button.addActionListener(this);
            this.buttons.add(button);
        }
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getMessages().getString("RunningProcessesDetected"));
    }

    @Override
    protected int getFrameHeight() {
        return 300;
    }

    @Override
    protected int getFrameWidth() {
        return 500;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }
}

