/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.actions.UninstallAction;
import com.install4j.api.beans.ActionList;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.FileSetSetup;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.NotSupportedInElevationException;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.RemoteCallable;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerActionEvent;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.groups.ControlFlowGroup;
import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.IdWrapperContext;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WizardContextInt;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.FilesetConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.LinkBeanConfig;
import com.install4j.runtime.installer.config.RootConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ExecuteActionListCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.LoggerImpl;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.Script;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.impl.FinishError;
import com.install4j.runtime.installer.helper.comm.responses.Response;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacProcessHelper;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import com.install4j.runtime.util.ObjectUtil;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class ContextImpl
implements ContextInt {
    protected ScreenExecutor screenExecutor;
    private InstallerConfig config;
    private List<FileSetSetupImpl> fileSetSetups = new ArrayList<FileSetSetupImpl>();
    private List<InstallationComponentSetupImpl> installationComponentSetups = new ArrayList<InstallationComponentSetupImpl>();
    private List<LauncherSetupImpl> launcherSetups = new ArrayList<LauncherSetupImpl>();
    private String languageId;
    private boolean languageInitialized = false;
    private InstallationProperties installationProperties;
    protected static boolean cancelling = false;
    private static boolean askingForCancel = false;
    private static ContextInt singleContextInt;
    private static Context currentContext;
    protected Set<InstallerEventListener> listeners = new HashSet<InstallerEventListener>();
    private Action currentAction;
    private boolean errorOccurred = false;
    private boolean shouldReboot = false;
    private boolean askUserForReboot = true;
    private List<ScreenBeanConfig> screenConfigsFlat;
    private Object[] extraScriptParameters;

    public static ContextInt getContextInt(Context context) {
        if (context instanceof ContextInt) {
            return (ContextInt)context;
        }
        if (context instanceof IdWrapperContext) {
            return ((IdWrapperContext)context).getParentContext();
        }
        return null;
    }

    public static boolean runBooleanScript(Context context, ScriptProperty scriptProperty, Bean bean, Object ... parameters) {
        try {
            Boolean aBoolean = (Boolean)context.runScript(scriptProperty, bean, parameters);
            if (aBoolean == null) {
                return true;
            }
            return aBoolean;
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    protected abstract String getRebootMessageId();

    public static ContextInt getSingleContextInt() {
        return singleContextInt;
    }

    public static void clearContext() {
        singleContextInt = null;
        cancelling = false;
        askingForCancel = false;
    }

    public static Context getCurrentContext() {
        return currentContext == null ? singleContextInt : currentContext;
    }

    public static void setCurrentContext(Context currentContext) {
        ContextImpl.currentContext = currentContext;
    }

    public static void setSingleContextInt(ContextInt contextInt) {
        if (singleContextInt != null) {
            throw new UnsupportedOperationException("only one ContextInt can exist");
        }
        singleContextInt = contextInt;
    }

    public ContextImpl(ScreenExecutor screenExecutor) {
        this.screenExecutor = screenExecutor;
        this.config = InstallerConfig.getCurrentInstance();
        List<FilesetConfig> fileSets = this.config.getFilesets();
        for (FilesetConfig filesetConfig : fileSets) {
            FileSetSetupImpl fileSetSetup = new FileSetSetupImpl(filesetConfig);
            this.fileSetSetups.add(fileSetSetup);
        }
        List<ComponentConfig> installationComponents = this.config.getComponents();
        for (ComponentConfig componentConfig : installationComponents) {
            InstallationComponentSetupImpl installationComponentSetup = new InstallationComponentSetupImpl(componentConfig);
            this.installationComponentSetups.add(installationComponentSetup);
        }
        List<LauncherConfig> list = this.config.getLaunchers();
        for (LauncherConfig launcherConfig : list) {
            LauncherSetupImpl launcherSetup = new LauncherSetupImpl(launcherConfig);
            this.launcherSetups.add(launcherSetup);
        }
        ContextImpl.setSingleContextInt(this);
        this.addInstallerEventListener(Logger.getImpl());
        InstallerVariables.registerVariableProvider("sys.contentDir", new InstallerVariables.ReadOnlyVariableProvider(){

            @Override
            public Object getVariable() {
                return ContextImpl.this.getContentDirectory().getPath();
            }
        });
        MsiHelper.addMsiVariables(this);
    }

    public abstract void applyToScreen(Screen var1, ScreenBeanConfig var2);

    @Override
    public abstract Context getIdWrapperContext(AbstractBeanConfig var1);

    protected abstract boolean performActionInt(ActionBeanConfig var1) throws UserCanceledException;

    protected abstract void rollbackActionInt(ActionBeanConfig var1);

    public List<AbstractBeanConfig> getScreenConfigs() {
        return this.config.getApplicationScreens();
    }

    public Map<String, AbstractBeanConfig> getId2BeanConfig() {
        return this.config.getCurrentApplicationConfig().getId2BeanConfig();
    }

    @Override
    public Object[] getExtraScriptParameters() {
        return this.extraScriptParameters;
    }

    @Override
    public void setExtraScriptParameters(Object ... extraScriptParameters) {
        this.extraScriptParameters = extraScriptParameters;
    }

    @Override
    public Object runScript(ScriptProperty scriptProperty, Bean bean, Object ... parameters) throws Exception {
        return ContextImpl.runScript(scriptProperty, bean, parameters, this);
    }

    public static Object runScript(ScriptProperty scriptProperty, Bean bean, Object[] parameters, Context context) throws Exception {
        if (scriptProperty != null && !Objects.equals(scriptProperty.getValue(), "")) {
            Class<?> scriptClass = Class.forName(scriptProperty.getValue(), true, Install4jClassLoader.getInstance());
            return ((Script)scriptClass.newInstance()).evaluate(context, bean, ObjectUtil.concat(singleContextInt.getExtraScriptParameters(), parameters));
        }
        return null;
    }

    public boolean checkGroupCondition(GroupBeanConfig groupBeanConfig) {
        Group group = groupBeanConfig.getOrInstantiateGroup(false);
        if (group instanceof ControlFlowGroup) {
            try {
                Object scriptReturn = this.runScript(((ControlFlowGroup)group).getConditionExpression(), group, new Object[0]);
                if (scriptReturn instanceof Boolean) {
                    return (Boolean)scriptReturn;
                }
                return true;
            }
            catch (Exception e) {
                InstallerUtil.reportException(e);
                return false;
            }
        }
        return true;
    }

    public boolean runBooleanScript(ScriptProperty scriptProperty, Bean bean) {
        if (scriptProperty == null) {
            return false;
        }
        return this.runBooleanScript(scriptProperty.getValue(), bean, new Object[0]);
    }

    @Override
    public boolean runBooleanScript(String className, Bean bean, Object ... parameters) {
        return ContextImpl.runBooleanScript(this, new ScriptProperty(className), bean, parameters);
    }

    @Override
    public File getDestinationFile(File archiveFile) {
        if (archiveFile == null) {
            return null;
        }
        return this.getDestinationFile(archiveFile.getPath());
    }

    @Override
    public File getDestinationFile(String archivePath) {
        if (archivePath == null) {
            return null;
        }
        return this.getDestinationFileInfo(archivePath).getDestinationFile();
    }

    @Override
    public FileInfo getDestinationFileInfo(String archivePath) {
        return this.getDestinationFileInfo(archivePath, true);
    }

    @Override
    public FileInfo getDestinationFileInfo(String archivePath, boolean resolveInSingleBundle) {
        FileInfoImpl fileInfo = new FileInfoImpl();
        fileInfo.relativeFilePath = archivePath;
        if (new File(archivePath).isAbsolute()) {
            fileInfo.rootUnresolved = "";
            return fileInfo;
        }
        if (Util.isMacosInstaller() && archivePath.startsWith(".install4j")) {
            fileInfo.relativeFilePath = this.config.getMacSpecificConfig().getRuntimeDirParent() + archivePath;
            return fileInfo;
        }
        String externalTestName = archivePath;
        if (Objects.equals(this.config.getType(), "macos") && this.config.getMacSpecificConfig().isSingleBundle()) {
            String appPrefix = this.config.getMacSpecificConfig().getRuntimeDirParent();
            if (archivePath.startsWith(appPrefix)) {
                externalTestName = archivePath.substring(appPrefix.length());
                if (!resolveInSingleBundle) {
                    fileInfo.relativeFilePath = externalTestName;
                }
            } else if (resolveInSingleBundle && !archivePath.startsWith(this.config.getMacSpecificConfig().getSingleBundleName())) {
                fileInfo.relativeFilePath = new File(appPrefix, archivePath).getPath();
            }
        }
        if (externalTestName.startsWith(".i4j_external_")) {
            int separator = externalTestName.indexOf(47);
            if (separator == -1) {
                separator = externalTestName.indexOf(92);
            }
            if (separator != -1) {
                String rootId = externalTestName.substring(".i4j_external_".length(), separator);
                fileInfo.relativeFilePath = externalTestName.substring(separator + 1);
                RootConfig rootConfig = this.config.getRootById(rootId);
                fileInfo.rootUnresolved = rootConfig.getLocation();
                if (fileInfo.rootUnresolved != null && fileInfo.rootUnresolved.trim().length() == 0 && Objects.equals(this.config.getType(), "macos") && this.config.getMacSpecificConfig().isSingleBundle() && resolveInSingleBundle) {
                    String appPrefix = this.config.getMacSpecificConfig().getRuntimeDirParent();
                    fileInfo.relativeFilePath = new File(appPrefix, fileInfo.relativeFilePath).getPath();
                }
                fileInfo.filesetId = rootConfig.getFileset();
                return fileInfo;
            }
        }
        return fileInfo;
    }

    @Override
    public String getLanguageId() {
        if (!this.languageInitialized) {
            String installerLanguage;
            Object var;
            this.languageInitialized = true;
            String externalLanguageId = System.getProperty("install4j.language");
            if (externalLanguageId != null) {
                this.setLanguageId(externalLanguageId);
            }
            if ((var = this.getVariable("sys.languageId")) instanceof String) {
                this.setLanguageId((String)var);
            }
            InstallerVariables.registerVariableProvider("sys.languageId", new InstallerVariables.VariableProvider(){

                @Override
                public Object getVariable() {
                    return ContextImpl.this.getLanguageId();
                }

                @Override
                public void setVariable(Object value) {
                }
            });
            this.registerResponseFileVariable("sys.languageId");
            if (this.languageId == null && !InstallerConfig.isInstaller() && (installerLanguage = this.getInstallerLanguageId()) != null) {
                this.setLanguageId(installerLanguage);
            }
        }
        return this.languageId;
    }

    @Override
    public String getMessage(String key) throws MissingResourceException {
        return Messages.getMessages().getString(key);
    }

    @Override
    public String getMessage(String key, Object ... arguments) throws MissingResourceException {
        return Messages.format(Messages.getMessages().getString(key), arguments);
    }

    public void setLanguageId(String languageId) {
        if (this.config.getLanguageById(languageId) == null) {
            throw new RuntimeException("The language \"" + languageId + "\" is not available.");
        }
        this.languageId = languageId;
    }

    @Override
    public File getInstallationDirectory() {
        return this.config.getInstallationDirectory(this);
    }

    @Override
    public File getDefaultInstallationDirectory() {
        return this.config.getDefaultResolvedInstallationDirectory();
    }

    @Override
    public File getContentDirectory() {
        InstallerConfig config = this.config;
        if (Objects.equals(config.getType(), "macos") && config.getMacSpecificConfig().isSingleBundle()) {
            return new File(this.getInstallationDirectory(), config.getMacSpecificConfig().getRuntimeDirParent());
        }
        return this.getInstallationDirectory();
    }

    @Override
    public boolean isArchive() {
        return this.config.isArchive();
    }

    @Override
    public File getResourceDirectory() {
        return InstallerUtil.getInstallerFile("user");
    }

    @Override
    public Collection<LauncherSetup> getLaunchers() {
        return Collections.unmodifiableCollection(this.launcherSetups);
    }

    @Override
    public LauncherSetup getLauncherById(String id) {
        for (LauncherSetupImpl launcherSetup : this.launcherSetups) {
            if (!launcherSetup.getId().equals(id) && !launcherSetup.getInternalId().equals(id)) continue;
            return launcherSetup;
        }
        return null;
    }

    @Override
    public Collection<FileSetSetup> getFileSets() {
        return Collections.unmodifiableCollection(this.fileSetSetups);
    }

    @Override
    public FileSetSetup getFileSetById(String id) {
        for (FileSetSetupImpl fileSetSetup : this.fileSetSetups) {
            if (!fileSetSetup.getId().equals(id) && !fileSetSetup.getInternalId().equals(id)) continue;
            return fileSetSetup;
        }
        return null;
    }

    @Override
    public FileSetSetup getFileSetByName(String name) {
        for (FileSetSetupImpl fileSetSetup : this.fileSetSetups) {
            if (!Objects.equals(fileSetSetup.getName(), name)) continue;
            return fileSetSetup;
        }
        return null;
    }

    @Override
    public Collection<InstallationComponentSetup> getInstallationComponents() {
        return Collections.unmodifiableCollection(this.installationComponentSetups);
    }

    @Override
    public InstallationComponentSetup getInstallationComponentById(String id) {
        for (InstallationComponentSetupImpl installationComponentSetup : this.installationComponentSetups) {
            if (!installationComponentSetup.getId().equals(id) && !installationComponentSetup.getInternalId().equals(id)) continue;
            return installationComponentSetup;
        }
        return null;
    }

    @Override
    public String getCompilerVariable(String variableName) {
        return this.config.getCompilerVariables().get(variableName);
    }

    @Override
    public boolean isUnattended() {
        return this.screenExecutor.isUnattended();
    }

    @Override
    public boolean isConsole() {
        return this.screenExecutor.isConsole();
    }

    @Override
    public boolean isGui() {
        return !this.screenExecutor.isConsole() && !this.screenExecutor.isUnattended();
    }

    @Override
    public String getApplicationId() {
        return this.config.getApplicationId();
    }

    @Override
    public String getAddOnApplicationId() {
        return this.config.getAddonAppId();
    }

    @Override
    public void goForward(int numberOfScreens, boolean checkCondition, boolean executeActions) {
        this.screenExecutor.getCommandSink().returnToController(new GoForwardCommand(numberOfScreens, checkCondition, executeActions, this.screenExecutor.getActionCallback()));
    }

    @Override
    public void goBackInHistory(int numberOfScreens) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(numberOfScreens, true));
    }

    @Override
    public void goBack(int numberOfScreens) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(numberOfScreens, false));
    }

    @Override
    public void goBackInHistory(Screen targetScreen) {
        if (targetScreen == null) {
            throw new IllegalArgumentException("parameter targetScreen must not be null");
        }
        this.screenExecutor.getCommandSink().returnToController(new GoBackInHistoryToScreenCommand(targetScreen));
    }

    @Override
    public void gotoScreen(Screen screen) {
        this.gotoScreen(screen, false, false);
    }

    @Override
    public void gotoScreen(Screen screen, boolean checkCondition, boolean executeActions) throws NotSupportedInElevationException {
        if (screen == null) {
            throw new IllegalArgumentException("parameter screen must not be null");
        }
        this.screenExecutor.getCommandSink().returnToController(new GotoScreenCommand(screen, checkCondition, executeActions, this.screenExecutor.getActionCallback()));
    }

    @Override
    public WizardContextInt getWizardContext() {
        return this.screenExecutor.getWizardContext();
    }

    @Override
    public Screen getScreenById(String id) {
        AbstractBeanConfig beanConfig = this.getId2BeanConfig().get(id);
        if (beanConfig instanceof ScreenBeanConfig && beanConfig.isInstantiated()) {
            return ((ScreenBeanConfig)beanConfig).getOrInstantiateScreen(false);
        }
        return null;
    }

    @Override
    public Screen[] getScreens() {
        return this.getScreens(null);
    }

    @Override
    public Screen getFirstScreen(Class screenClass) {
        Screen[] screens = this.getScreens(screenClass);
        if (screens.length > 0) {
            return screens[0];
        }
        return null;
    }

    @Override
    public Screen[] getScreens(Class screenClass) {
        ArrayList<Screen> screens = new ArrayList<Screen>();
        this.addScreens(screenClass, screens, this.getScreenConfigs());
        return screens.toArray(new Screen[0]);
    }

    public List<ScreenBeanConfig> getScreenConfigsFlat() {
        if (this.screenConfigsFlat == null) {
            this.screenConfigsFlat = new ArrayList<ScreenBeanConfig>();
            this.addScreenConfigs(null, this.screenConfigsFlat, this.getScreenConfigs());
        }
        return this.screenConfigsFlat;
    }

    private void addScreenConfigs(Class screenClass, List<ScreenBeanConfig> flatScreenConfigs, List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                if (screenClass != null && (!screenConfig.isInstantiated() || screenConfig.getOrInstantiateScreen(false).getClass() != screenClass)) continue;
                flatScreenConfigs.add(screenConfig);
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            this.addScreenConfigs(screenClass, flatScreenConfigs, groupConfig.getBeanConfigs());
        }
    }

    private void addScreens(Class screenClass, List<Screen> screens, List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                if (!screenConfig.isInstantiated() || screenClass != null && screenConfig.getOrInstantiateScreen(false).getClass() != screenClass) continue;
                screens.add(screenConfig.getOrInstantiateScreen(false));
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            this.addScreens(screenClass, screens, groupConfig.getBeanConfigs());
        }
    }

    @Override
    public Action getActionById(String id) {
        AbstractBeanConfig beanConfig = this.getId2BeanConfig().get(id);
        if (beanConfig instanceof ActionBeanConfig && beanConfig.isInstantiated()) {
            return ((ActionBeanConfig)beanConfig).getOrInstantiateAction(false);
        }
        return null;
    }

    @Override
    public Action[] getActions(Screen screen) {
        return this.getActions(null, screen);
    }

    @Override
    public Action getFirstAction(Class<? extends Action> actionClass, Screen screen) {
        Action[] actions = this.getActions(actionClass, screen);
        if (actions.length > 0) {
            return actions[0];
        }
        return null;
    }

    @Override
    public Action[] getActions(Class<? extends Action> actionClass, Screen screen) {
        ArrayList actions = new ArrayList();
        this.addActionsFromScreenConfigs(actionClass, screen, actions, this.getScreenConfigs());
        return actions.toArray(new Action[0]);
    }

    private <T extends Action> void addActionsFromScreenConfigs(Class<T> actionClass, Screen screen, List<T> actions, List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                if (screen != null && (!screenConfig.isInstantiated() || screenConfig.getOrInstantiateScreen(false) != screen)) continue;
                this.addActions(actions, screenConfig.getActionConfigs(), actionClass, false);
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            this.addActionsFromScreenConfigs(actionClass, screen, actions, groupConfig.getBeanConfigs());
        }
    }

    @Override
    public <T extends Action> List<T> getExecutableActionsStartingFrom(Class<T> actionClass, Screen screen) {
        boolean barrierReached = screen == null;
        ArrayList actions = new ArrayList();
        this.addExecutableActionsFrom(actionClass, screen, barrierReached, actions, this.getScreenConfigs());
        return actions;
    }

    private <T extends Action> boolean addExecutableActionsFrom(Class<T> actionClass, Screen screen, boolean barrierReached, List<T> actions, List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                if (!barrierReached && screenConfig.isInstantiated() && screenConfig.getOrInstantiateScreen(false) == screen) {
                    barrierReached = true;
                }
                if (!barrierReached || screenConfig.isInstantiated() && !this.runBooleanScript(screenConfig.getConditionClassName(), screenConfig.getOrInstantiateScreen(false), new Object[0])) continue;
                this.addActions(actions, screenConfig.getActionConfigs(), actionClass, true);
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            if (!this.runBooleanScript(groupConfig.getConditionClassName(), groupConfig.getOrInstantiateGroup(false), new Object[0])) continue;
            barrierReached = this.addExecutableActionsFrom(actionClass, screen, barrierReached, actions, groupConfig.getBeanConfigs());
        }
        return barrierReached;
    }

    private <T extends Action> void addActions(List<T> actions, List<AbstractBeanConfig> actionsConfigs, Class<T> actionClass, boolean checkShouldRun) {
        for (AbstractBeanConfig beanConfig : actionsConfigs) {
            if (beanConfig instanceof ActionBeanConfig) {
                ActionBeanConfig actionConfig = (ActionBeanConfig)beanConfig;
                if (!actionConfig.isInstantiated() || actionClass != null && actionConfig.getOrInstantiateAction(false).getClass() != actionClass) continue;
                Action action = actionConfig.getOrInstantiateAction(false);
                if (checkShouldRun && !this.runBooleanScript(actionConfig.getConditionClassName(), action, new Object[0])) continue;
                actions.add(action);
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            if (checkShouldRun && !this.runBooleanScript(groupConfig.getConditionClassName(), groupConfig.getOrInstantiateGroup(false), new Object[0])) continue;
            this.addActions(actions, groupConfig.getBeanConfigs(), actionClass, checkShouldRun);
        }
    }

    @Override
    public String getId(Action action) {
        for (Map.Entry<String, AbstractBeanConfig> entry : this.getId2BeanConfig().entrySet()) {
            AbstractBeanConfig beanConfig = entry.getValue();
            if (!(beanConfig instanceof ActionBeanConfig) || !beanConfig.isInstantiated() || ((ActionBeanConfig)beanConfig).getOrInstantiateAction(true) != action) continue;
            return beanConfig.getDisplayedId();
        }
        return null;
    }

    @Override
    public String getId(Screen screen) {
        for (Map.Entry<String, AbstractBeanConfig> entry : this.getId2BeanConfig().entrySet()) {
            AbstractBeanConfig beanConfig = entry.getValue();
            if (!(beanConfig instanceof ScreenBeanConfig) || !beanConfig.isInstantiated() || ((ScreenBeanConfig)beanConfig).getOrInstantiateScreen(true) != screen) continue;
            return beanConfig.getDisplayedId();
        }
        return null;
    }

    public void registerScreens() {
        List<AbstractBeanConfig> screenConfigs = this.getScreenConfigs();
        this.registerScreens(screenConfigs);
        AbstractBeanConfig.finishBatch();
        this.initAllActions(screenConfigs);
        this.registerScreenConfigs(screenConfigs);
    }

    private void registerScreenConfigs(List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof LinkBeanConfig) continue;
            if (beanConfig instanceof ScreenBeanConfig) {
                Screen screen;
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                if (!screenConfig.isInstantiated() || (screen = screenConfig.getOrInstantiateScreen(false)) == null) continue;
                this.screenExecutor.register(screen, screenConfig);
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            this.registerScreenConfigs(groupConfig.getBeanConfigs());
        }
    }

    private void initAllActions(List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                this.initActionsForSingleScreen(screenConfig.getActionConfigs());
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            this.initAllActions(groupConfig.getBeanConfigs());
        }
    }

    private void registerScreens(List<AbstractBeanConfig> screenConfigs) {
        for (AbstractBeanConfig beanConfig : screenConfigs) {
            if (beanConfig instanceof ScreenBeanConfig) {
                ScreenBeanConfig screenConfig = (ScreenBeanConfig)beanConfig;
                screenConfig.batchInstantiate();
                this.registerActions(screenConfig.getActionConfigs());
                this.registerFormComponents(screenConfig.getFormComponentConfigs());
                continue;
            }
            GroupBeanConfig groupConfig = (GroupBeanConfig)beanConfig;
            groupConfig.batchInstantiate();
            this.registerScreens(groupConfig.getBeanConfigs());
        }
    }

    private void registerFormComponents(List<AbstractBeanConfig> formComponentConfigs) {
        for (AbstractBeanConfig beanConfig : formComponentConfigs) {
            if (beanConfig instanceof FormComponentBeanConfig) {
                FormComponentBeanConfig formComponentBeanConfig = (FormComponentBeanConfig)beanConfig;
                formComponentBeanConfig.batchInstantiate();
                continue;
            }
            GroupBeanConfig groupBeanConfig = (GroupBeanConfig)beanConfig;
            groupBeanConfig.batchInstantiate();
        }
    }

    private void initActionsForSingleScreen(List<AbstractBeanConfig> actionConfigs) {
        for (AbstractBeanConfig beanConfig : actionConfigs) {
            if (beanConfig instanceof ActionBeanConfig) {
                Action action;
                ActionBeanConfig actionBeanConfig = (ActionBeanConfig)beanConfig;
                if (actionBeanConfig.isInitialized() || (action = actionBeanConfig.getOrInstantiateAction(true)) == null) continue;
                action.init(this.getIdWrapperContext(actionBeanConfig));
                actionBeanConfig.setInitialized(true);
                if (!actionBeanConfig.isElevate() || !(action instanceof InstallFilesAction)) continue;
                ContentInstaller.setExecutionContext(ExecutionContext.MAXIMUM);
                continue;
            }
            GroupBeanConfig groupBeanConfig = (GroupBeanConfig)beanConfig;
            this.initActionsForSingleScreen(groupBeanConfig.getBeanConfigs());
        }
    }

    private void registerActions(List<AbstractBeanConfig> actionConfigs) {
        for (AbstractBeanConfig beanConfig : actionConfigs) {
            if (beanConfig instanceof ActionBeanConfig) {
                ActionBeanConfig actionBeanConfig = (ActionBeanConfig)beanConfig;
                actionBeanConfig.batchInstantiate();
                continue;
            }
            GroupBeanConfig groupBeanConfig = (GroupBeanConfig)beanConfig;
            this.registerActions(groupBeanConfig.getBeanConfigs());
        }
    }

    @Override
    public ProgressInterface getProgressInterface() {
        return this.screenExecutor.getProgressInterface();
    }

    public ProgressInterface getDefaultProgressInterface() {
        return this.screenExecutor.getDefaultProgressInterface();
    }

    public static void setAskingForCancel(final boolean askingForCancel) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new HelperCommunication.DirectRunAction(){

            @Override
            protected void run(Context context) {
                askingForCancel = askingForCancel;
            }
        });
    }

    public static void setCancelling() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new HelperCommunication.DirectRunAction(){

            @Override
            protected void run(Context context) {
                cancelling = true;
                askingForCancel = false;
            }
        });
    }

    @Override
    public boolean isCancelling() {
        return ContextImpl.isCancellingInt();
    }

    public static boolean isCancellingInt() {
        if (HelperCommunication.getInstance().isElevatedHelper() || !SwingUtilities.isEventDispatchThread()) {
            while (askingForCancel) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!HelperCommunication.getInstance().isElevatedHelper()) continue;
                HelperCommunication.getInstance().checkWork();
            }
        }
        return cancelling;
    }

    protected void cleanup() {
        Logger.getInstance().info(null, "cleaning up");
        ProgressInterface progressInterface = this.getProgressInterface();
        String key = this instanceof UninstallerContext ? "UninstallerFinish" : (InstallerConfig.getCurrentApplication() instanceof InstallerApplication ? "StatusRunProgram" : "StatusRunProgramExecute");
        progressInterface.setStatusMessage(Messages.getMessages().getString(key));
        progressInterface.setPercentCompleted(0);
        progressInterface.setDetailMessage(" ");
        FileInstaller.getInstance().cleanup();
        ContentInstaller.getInstance().cleanup();
        if (InstallerUtil.isWindows()) {
            ShellLink.uninitialize();
        }
    }

    @Override
    public void handleCriticalException(Throwable e) {
        InstallerUtil.reportException(e);
        this.cleanup();
        this.immediateExit(1);
    }

    protected final String getInstallerLanguageId() {
        return this.getInstallationProperties().getLanguageId();
    }

    @Override
    public InstallationProperties getInstallationProperties() {
        if (this.installationProperties == null) {
            this.installationProperties = new InstallationProperties(this.getRuntimeDirectory());
        }
        return this.installationProperties;
    }

    public void setRollback() {
        this.screenExecutor.setRollback();
        this.shouldReboot = false;
    }

    @Override
    public void finish(int exitCode) {
        this.cleanup();
        this.fireInstallerEvent(new InstallerEvent(this, this, EventType.FINISHED));
        this.exit(exitCode);
    }

    @Override
    public boolean hasBeenElevated() {
        return false;
    }

    @Override
    public boolean runBooleanActivityWithFallback(RemoteCallable remoteCallable) {
        boolean success;
        try {
            success = (Boolean)remoteCallable.execute();
        }
        catch (Exception e) {
            success = false;
        }
        if (success) {
            return true;
        }
        if (Util.hasFullAdminRights()) {
            return false;
        }
        try {
            Serializable ret = this.runElevated(remoteCallable, false);
            return ret instanceof Boolean && (Boolean)ret != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Serializable runElevated(RemoteCallable remoteCallable, boolean alwaysExecute) {
        return ContextImpl.runElevatedInt(remoteCallable, alwaysExecute);
    }

    public static Serializable runElevatedInt(RemoteCallable remoteCallable, boolean alwaysExecute) {
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        if (helperCommunication.hasElevatedHelper()) {
            RemoteResponse remoteResponse = (RemoteResponse)helperCommunication.executeAction(ExecutionContext.MAXIMUM, new RemoteAction(remoteCallable));
            if (remoteResponse != null) {
                return remoteResponse.getReturnedObject();
            }
        } else if (alwaysExecute || Util.hasFullAdminRights()) {
            return remoteCallable.execute();
        }
        return null;
    }

    @Override
    public Serializable runUnelevated(RemoteCallable remoteCallable) {
        return ContextImpl.runUnelevatedInt(remoteCallable, true);
    }

    @Override
    public void initializeLazilyCreatedScreens() {
        this.screenExecutor.initializeLazilyLoadedScreens();
    }

    @Override
    public void addToClassPath(File file) {
        Install4jClassLoader.addClassPath(file);
    }

    @Override
    public String[] getExtraCommandLineArguments() {
        return InstallerUtil.getExtraCommandLineParameters();
    }

    @Override
    public String getMediaFileId() {
        return this.config.getMediaSetId();
    }

    @Override
    public String getVersion() {
        return this.config.getApplicationVersion();
    }

    @Override
    public String getApplicationName() {
        return this.config.getApplicationName();
    }

    @Override
    public boolean executeActionListSync(ActionList actionList, Object ... extraScriptParameters) throws UserCanceledException {
        return this.screenExecutor.getCommandSink().executeActionList(actionList, extraScriptParameters);
    }

    @Override
    public void executeActionListAsync(ActionList actionList, Object ... extraScriptParameters) {
        if (this.screenExecutor.getCommandSink().isExecutingActions()) {
            throw new IllegalStateException("Actions are currently executing, use executeActionListSync instead");
        }
        this.screenExecutor.getCommandSink().returnToController(new ExecuteActionListCommand(this.screenExecutor.getActionCallback(), actionList, extraScriptParameters));
    }

    @Override
    public void rollbackActionList(ActionList actionList) {
        this.screenExecutor.getCommandSink().rollbackActionList(actionList);
    }

    public static Serializable runUnelevatedInt(RemoteCallable remoteCallable, boolean alwaysRun) {
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        if (helperCommunication.isElevatedHelper()) {
            RemoteResponse remoteResponse = (RemoteResponse)helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RemoteAction(remoteCallable));
            if (remoteResponse != null) {
                return remoteResponse.getReturnedObject();
            }
        } else if (alwaysRun) {
            return remoteCallable.execute();
        }
        return null;
    }

    public void setupClasspath() {
        for (InstallationComponentSetupImpl installationComponentSetup : this.installationComponentSetups) {
            installationComponentSetup.initVariable();
        }
        Install4jClassLoader.addCustomJarsToClasspath(this);
    }

    public boolean checkStart() {
        return true;
    }

    @Override
    public Object getVariable(String variableName) {
        return InstallerVariables.getVariable(variableName);
    }

    @Override
    public boolean getBooleanVariable(String variableName) {
        Object value = this.getVariable(variableName);
        return Boolean.TRUE.equals(value) || "true".equals(value);
    }

    @Override
    public void setVariable(String variableName, Object value) {
        InstallerVariables.setVariable(variableName, value);
        this.variableChanged(variableName);
    }

    protected void variableChanged(String variableName) {
        this.fireInstallerEvent(new InstallerVariableEvent((Object)this, (Context)this, variableName));
    }

    @Override
    public Set<String> getVariableNames() {
        return InstallerVariables.getVariableNames();
    }

    @Override
    public void registerResponseFileVariable(String variableName) {
        InstallerVariables.registerResponseFileVariable(variableName);
    }

    @Override
    public void unregisterResponseFileVariable(String variableName) {
        InstallerVariables.unregisterResponseFileVariable(variableName);
    }

    @Override
    public void registerResponseFileComment(String variableName, String comment) {
        InstallerVariables.registerResponseFileComment(variableName, comment);
    }

    @Override
    public void registerHiddenVariable(String variableName) {
        InstallerVariables.registerHiddenVariable(variableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        if (action == null) {
            Logger.getInstance().error(null, "Could not instantiate action " + actionBeanConfig.getDisplayedId());
            return false;
        }
        long start = System.currentTimeMillis();
        boolean success = false;
        try {
            this.currentAction = action;
            FileInstaller.getInstance().setCurrentAction(actionBeanConfig);
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.BEFORE_EXECUTE_ACTION));
            boolean bl = success = this.performActionInt(actionBeanConfig);
            return bl;
        }
        catch (FinishError e) {
            this.finish(e.getExitCode());
            boolean bl = true;
            return bl;
        }
        catch (UserCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            InstallerUtil.reportException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.fireInstallerEvent(new InstallerActionEvent(action, this, EventType.AFTER_EXECUTE_ACTION, success, actionBeanConfig.getDisplayedId(), System.currentTimeMillis() - start));
            this.currentAction = null;
        }
    }

    public void rollbackAction(ActionBeanConfig actionBeanConfig) {
        Action eventSource = null;
        try {
            eventSource = this.currentAction = actionBeanConfig.getOrInstantiateAction(false);
            this.fireInstallerEvent(new InstallerEvent(eventSource, this, EventType.BEFORE_ROLLBACK_ACTION));
            this.rollbackActionInt(actionBeanConfig);
        }
        finally {
            if (eventSource != null) {
                this.fireInstallerEvent(new InstallerEvent(eventSource, this, EventType.AFTER_ROLLBACK_ACTION));
            }
            this.currentAction = null;
        }
    }

    @Override
    public void fireInstallerEvent(InstallerEvent event) {
        for (InstallerEventListener installerEventListener : new ArrayList<InstallerEventListener>(this.listeners)) {
            installerEventListener.installerEvent(event);
        }
    }

    @Override
    public void addInstallerEventListener(InstallerEventListener event) {
        this.listeners.add(event);
    }

    @Override
    public void removeInstallerEventListener(InstallerEventListener event) {
        this.listeners.remove(event);
    }

    @Override
    public Object getEventSource() {
        if (this.currentAction != null) {
            return this.currentAction;
        }
        return this;
    }

    @Override
    public File getExternalFile(ExternalFile externalFile, boolean installedLocation) {
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        if (externalFile.getPath().startsWith("icon:")) {
            return new ExternalFile(InstallerVariables.replaceVariables(externalFile.getPath()));
        }
        if (ContextImpl.isDistributionExternal(externalFile)) {
            return InstallerVariables.replaceVariables(externalFile);
        }
        return new File(this.getRuntimeDirectory(), externalFile.getPath());
    }

    @Override
    public File getExternalFile(LocalizedExternalFile localizedExternalFile, boolean installedLocation) {
        if (localizedExternalFile == null) {
            return null;
        }
        Map<String, ExternalFile> languageIdToExternalFile = localizedExternalFile.getLanguageIdToExternalFile();
        ExternalFile externalFile = languageIdToExternalFile.get(this.languageId);
        if (externalFile == null) {
            String principalLanguageId = this.config.getLanguages().get(0).getId();
            externalFile = languageIdToExternalFile.get(principalLanguageId);
        }
        return this.getExternalFile(externalFile, installedLocation);
    }

    protected static boolean isDistributionExternal(ExternalFile externalFile) {
        if (externalFile == null) {
            return false;
        }
        String path = externalFile.getPath().trim();
        return path.contains("${") || path.startsWith("icon:");
    }

    @Override
    public final File getRuntimeDirectory() {
        return this.getDestinationFile(".install4j");
    }

    @Override
    public void setErrorOccurred(boolean errorOccurred) {
        this.errorOccurred = errorOccurred;
    }

    @Override
    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public void immediateExit(final int value) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.out.flush();
                System.err.flush();
                HelperCommunication.getInstance().terminate();
                if (InstallerUtil.isInProcess()) {
                    ContextImpl.this.screenExecutor.closeWindows();
                }
                InstallerUtil.exit(value);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void exit(final int exitCode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ContextImpl.this.screenExecutor.closeWindows();
                if (!ContextImpl.this.checkReboot()) {
                    ContextImpl.this.waitForFinishExecutable();
                }
                LoggerImpl.getImpl().moveLogFileToFinalDestination();
                HelperCommunication.getInstance().terminate();
                InstallerUtil.exit(exitCode);
            }
        };
        GUIHelper.invokeOnEDT(runnable);
    }

    private void waitForFinishExecutable() {
        long delta;
        if (Util.isWindows() || Util.isMacOS()) {
            return;
        }
        long lastLaunchTime = LaunchHelper.getLastLaunchTime();
        if (lastLaunchTime != 0L && (delta = System.currentTimeMillis() - lastLaunchTime) < 10000L) {
            try {
                Thread.sleep(10000L - delta);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void triggerReboot(boolean askUser) {
        if (!Boolean.getBoolean("install4j.preventReboot")) {
            this.shouldReboot = true;
            if (!askUser) {
                this.askUserForReboot = false;
            }
        }
    }

    @Override
    public boolean isRebootRequired() {
        return this.shouldReboot;
    }

    protected ExecutionContext getWinDelExecutionContext() {
        return ExecutionContext.UNELEVATED;
    }

    private void doReboot() {
        if (Util.isWindows()) {
            ContextImpl.rebootWindows(this.getWinDelExecutionContext());
        } else if (Util.isMacOS()) {
            MacProcessHelper.reboot();
        }
    }

    private static void rebootWindows(ExecutionContext executionContext) {
        HelperCommunication.getInstance().executeAction(executionContext, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                if (WinDel.isUsed()) {
                    WinDel.setReboot(true);
                } else {
                    Misc.reboot();
                }
            }
        });
    }

    private static void setWinDelRebootMessage(final String rebootMessage, final String rebootErrorMessage) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                WinDel.setRebootMessage(rebootMessage, rebootErrorMessage);
            }
        });
    }

    private boolean checkReboot() {
        VariableResourceBundleWrapper messages = Messages.getMessages();
        String rebootMessage = Messages.format(messages.getString(this.getRebootMessageId()), this.config.getApplicationName());
        if (Util.isWindows() && !this.isUnattended() && !this.isConsole()) {
            ContextImpl.setWinDelRebootMessage(rebootMessage, messages.getString("ErrorRestartingComputer"));
        }
        if (this.isRebootSupported() && this.shouldReboot) {
            if (Boolean.getBoolean("install4j.suppressReboot")) {
                return false;
            }
            if (this.isUnattended() || !this.askUserForReboot) {
                if (this.isUnattended() && Boolean.getBoolean("install4j.suppressUnattendedReboot")) {
                    return false;
                }
                this.doReboot();
                return true;
            }
            try {
                int result = Util.showOptionDialog(rebootMessage, new String[]{messages.getString("ButtonYes"), messages.getString("ButtonNo")}, 3);
                if (result == 0) {
                    this.doReboot();
                    return true;
                }
                if (Util.isWindows()) {
                    ContextImpl.setWinDelRebootMessage("", "");
                }
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isRebootSupported() {
        return Util.isWindows() || Util.isMacOS();
    }

    public void initLoopIndex(GroupBeanConfig groupConfig, GroupState groupState) {
        Group group = (Group)groupConfig.getOrInstantiateBean();
        if (group instanceof ControlFlowGroup) {
            ControlFlowGroup controlFlowGroup = (ControlFlowGroup)group;
            groupState.loopIndex = controlFlowGroup.getLoopIndexStart();
            this.setLoopIndexInstallerVariable(controlFlowGroup, groupState);
        }
    }

    public void setLoopIndexInstallerVariable(ControlFlowGroup controlFlowGroup, GroupState groupState) {
        String loopIndexVariableName = controlFlowGroup.getLoopIndexVariableName();
        if (loopIndexVariableName.trim().length() > 0) {
            Integer index = groupState.loopIndex;
            this.setVariable(loopIndexVariableName, index);
        }
    }

    public boolean isGroupLoop(GroupBeanConfig groupConfig, GroupState groupState) {
        Group group = groupConfig.getOrInstantiateGroup(false);
        if (group instanceof ControlFlowGroup && groupState != null) {
            ControlFlowGroup controlFlowGroup = (ControlFlowGroup)group;
            groupState.loopIndex += controlFlowGroup.getLoopIndexStep();
            this.setLoopIndexInstallerVariable(controlFlowGroup, groupState);
            return this.isGroupLoop(controlFlowGroup, groupState);
        }
        return false;
    }

    private boolean isGroupLoop(ControlFlowGroup controlFlowGroup, GroupState groupState) {
        if (!controlFlowGroup.isLoop()) {
            return false;
        }
        try {
            Object scriptReturn = this.runScript(controlFlowGroup.getLoopExpression(), controlFlowGroup, groupState.loopIndex);
            if (scriptReturn instanceof Boolean) {
                return (Boolean)scriptReturn;
            }
            return false;
        }
        catch (Exception e) {
            InstallerUtil.reportException(e);
            return false;
        }
    }

    protected static boolean performActionIntStatic(ActionBeanConfig config, Context currentContext) throws UserCanceledException {
        ContextImpl.setCurrentContext(currentContext);
        final Action action = config.getOrInstantiateAction(false);
        final Map<String, String> textOverrides = config.getTextOverrides();
        try {
            PostActionExecutionState postActionExecutionState = HelperCommunication.getInstance().fetchObjectChecked(config.getExecutionContext(), new FetchObjectAction<PostActionExecutionState>(){

                @Override
                protected PostActionExecutionState fetchValue(Context context) throws UserCanceledException {
                    return new PostActionExecutionState(action, this.executeAction(context));
                }

                private boolean executeAction(Context context) throws UserCanceledException {
                    AbstractBeanConfig.registerTextOverrides(action, textOverrides);
                    ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(action.getClass().getClassLoader());
                        if (action instanceof InstallAction && context instanceof InstallerContext) {
                            boolean bl = ((InstallAction)action).install((InstallerContext)context);
                            return bl;
                        }
                        if (action instanceof UninstallAction && context instanceof UninstallerContext) {
                            boolean bl = ((UninstallAction)action).uninstall((UninstallerContext)context);
                            return bl;
                        }
                        throw new IllegalArgumentException(action.getClass().getName() + "/ " + context.getClass().getName());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
                    }
                }
            });
            config.setInstance(postActionExecutionState.getAction());
            boolean bl = postActionExecutionState.isSuccess();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    public static class GroupState
    implements Cloneable {
        int loopIndex;

        public String toString() {
            return "Group state " + this.loopIndex;
        }

        public GroupState copy() {
            try {
                return (GroupState)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    protected static class PostActionExecutionState
    implements Serializable {
        private boolean success;
        private Action action;

        public PostActionExecutionState(Action action, boolean success) {
            this.success = success;
            this.action = action;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Action getAction() {
            return this.action;
        }
    }

    public static class FileInfoImpl
    implements FileInfo,
    Serializable {
        private String rootUnresolved;
        private String relativeFilePath;
        private String filesetId = "";

        @Override
        public File getDestinationFile() {
            String rootResolved = this.getRootResolvedString();
            if (rootResolved == null) {
                return null;
            }
            if (Objects.equals(rootResolved, "")) {
                File relativeFile = new File(this.relativeFilePath);
                if (relativeFile.isAbsolute()) {
                    return relativeFile;
                }
                return new File(ContextImpl.getCurrentContext().getInstallationDirectory().getAbsoluteFile(), this.relativeFilePath);
            }
            return new File(rootResolved, this.relativeFilePath);
        }

        @Override
        public String getRootUnresolved() {
            return this.rootUnresolved;
        }

        @Override
        public File getRootResolved() {
            String rootResolvedString = this.getRootResolvedString();
            if (rootResolvedString == null) {
                return null;
            }
            if (Objects.equals(rootResolvedString, "") && !new File(this.relativeFilePath).isAbsolute()) {
                return ContextImpl.getCurrentContext().getInstallationDirectory().getAbsoluteFile();
            }
            return new File(rootResolvedString);
        }

        private String getRootResolvedString() {
            if (this.rootUnresolved == null) {
                return ContextImpl.getCurrentContext().getInstallationDirectory().getAbsolutePath();
            }
            try {
                return InstallerVariables.replaceVariables(this.rootUnresolved).replace('/', File.separatorChar).replace('\\', File.separatorChar);
            }
            catch (UndefinedVariableException e) {
                return null;
            }
        }

        @Override
        public String getRelativeFilePath() {
            return this.relativeFilePath;
        }

        @Override
        public String getFilesetId() {
            return this.filesetId;
        }

        @Override
        public String getFilesetName() {
            if (this.filesetId == null || this.filesetId.length() == 0) {
                return "";
            }
            FileSetSetup fileSetSetup = ContextImpl.getCurrentContext().getFileSetById(this.filesetId);
            if (fileSetSetup == null) {
                return null;
            }
            return fileSetSetup.getName();
        }

        public String toString() {
            return "FileInfoImpl{rootUnresolved='" + this.rootUnresolved + '\'' + ", relativeFilePath='" + this.relativeFilePath + '\'' + ", filesetId='" + this.filesetId + '\'' + '}';
        }
    }

    public static class InstallationComponentSetupImpl
    implements InstallationComponentSetup,
    Serializable {
        public static final String VARIABLE_PREFIX = "sys.component.";
        private ComponentConfig componentConfig;

        public InstallationComponentSetupImpl(ComponentConfig componentConfig) {
            this.componentConfig = componentConfig;
        }

        @Override
        public boolean isSelected() {
            return this.componentConfig.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            HelperCommunication.helperUnsupported();
            this.componentConfig.setSelected(selected);
        }

        @Override
        public boolean isChangeable() {
            return this.componentConfig.isChangeable();
        }

        @Override
        public void setChangeable(boolean changeable) {
            HelperCommunication.helperUnsupported();
            this.componentConfig.setChangeable(changeable);
        }

        @Override
        public boolean isHidden() {
            return this.componentConfig.isHidden();
        }

        @Override
        public void setHidden(boolean hidden) {
            HelperCommunication.helperUnsupported();
            this.componentConfig.setHidden(hidden);
        }

        @Override
        public String getName() {
            return this.componentConfig.getName();
        }

        @Override
        public String getId() {
            return this.componentConfig.getDisplayedId();
        }

        @Override
        public boolean isDownloaded() {
            return this.componentConfig.isDownloaded();
        }

        public String getInternalId() {
            return this.componentConfig.getId();
        }

        public void initVariable() {
            HelperCommunication.helperUnsupported();
            String variableName = VARIABLE_PREFIX + this.getId();
            Object varValue = InstallerVariables.getVariable(variableName);
            if (varValue instanceof Boolean) {
                this.setSelected((Boolean)varValue);
            }
            InstallerVariables.registerVariableProvider(variableName, new InstallerVariables.VariableProvider(){

                @Override
                public Object getVariable() {
                    return InstallationComponentSetupImpl.this.isSelected();
                }

                @Override
                public void setVariable(Object value) {
                    if (value instanceof Boolean) {
                        InstallationComponentSetupImpl.this.setSelected((Boolean)value);
                    }
                }
            });
            InstallerVariables.registerResponseFileVariable(variableName);
        }
    }

    private static class FileSetSetupImpl
    implements FileSetSetup,
    Serializable {
        private FilesetConfig filesetConfig;

        public FileSetSetupImpl(FilesetConfig filesetConfig) {
            this.filesetConfig = filesetConfig;
        }

        @Override
        public boolean isSelected() {
            return this.filesetConfig.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            HelperCommunication.helperUnsupported();
            this.filesetConfig.setSelected(selected);
        }

        @Override
        public String getName() {
            return this.filesetConfig.getName();
        }

        @Override
        public String getId() {
            return this.filesetConfig.getDisplayedId();
        }

        public String getInternalId() {
            return this.filesetConfig.getId();
        }
    }

    public static class LauncherSetupImpl
    implements LauncherSetup,
    Serializable {
        private LauncherConfig launcherConfig;

        public LauncherSetupImpl(LauncherConfig launcherConfig) {
            this.launcherConfig = launcherConfig;
        }

        @Override
        public String getRelativeFileName() {
            if (InstallerUtil.isWindows()) {
                return this.launcherConfig.getFile().replace('/', '\\');
            }
            return this.launcherConfig.getFile().replace('\\', '/');
        }

        @Override
        public String getId() {
            return this.launcherConfig.getDisplayedId();
        }

        public String getInternalId() {
            return this.launcherConfig.getId();
        }

        @Override
        public LauncherType getType() {
            return this.launcherConfig.getType();
        }

        @Override
        public String getName() {
            return this.launcherConfig.getName();
        }

        public String getMenuName() {
            return this.launcherConfig.getMenuName();
        }

        @Override
        public boolean isExcludeFromMenu() {
            return this.launcherConfig.isExcludeFromMenu();
        }

        @Override
        public boolean isUninstaller() {
            return this.launcherConfig.isUninstaller();
        }

        public LauncherConfig getLauncherConfig() {
            return this.launcherConfig;
        }
    }

    public static class RemoteResponse
    extends Response {
        private Serializable returnedObject;

        public RemoteResponse(boolean success, Serializable returnedObject) {
            super(success);
            this.returnedObject = returnedObject;
        }

        public Serializable getReturnedObject() {
            return this.returnedObject;
        }
    }

    private static class RemoteAction
    extends CommunicationAction {
        private RemoteCallable remoteCallable;

        private RemoteAction(RemoteCallable remoteCallable) {
            this.remoteCallable = remoteCallable;
        }

        @Override
        public Response execute(Context context) {
            Serializable returnedObject;
            Logger.getInstance().info(null, "executing " + this.remoteCallable);
            try {
                returnedObject = this.remoteCallable.execute();
            }
            catch (Throwable t) {
                Logger.getInstance().log(t);
                return new RemoteResponse(false, null);
            }
            return new RemoteResponse(true, returnedObject);
        }
    }
}

