/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import de.javasoft.swing.table.AbstractTableCellEditor;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiLineTableCellEditor
extends AbstractTableCellEditor<JTextArea> {
    public MultiLineTableCellEditor(TableCellEditor tableCellEditor) {
        super(tableCellEditor);
    }

    @Override
    public JTextArea createEditorComponent() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.putClientProperty("Synthetica.opaque", false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jTextArea;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((JTextArea)MultiLineTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        return ((JTextArea)this.editorComponent).getText();
    }

    @Override
    public void setCellEditorValue(Object object) {
        ((JTextArea)this.editorComponent).setText(object == null ? "" : object.toString());
    }
}

