/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jytabbedpane;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYTabbedPanePainter;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import de.javasoft.swing.plaf.jytabbedpane.IButtonFactory;
import de.javasoft.swing.plaf.jytabbedpane.TabOverviewDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TabOverviewPreviewPanel
extends JPanel {
    private JYTabbedPane tabPane;
    private int tabIndex;
    private JLabel titleLabel;
    private BufferedImage previewImage;
    private int preferredImageWidth;
    private int preferredImageHeight;
    private boolean hover;

    public TabOverviewPreviewPanel(final JYTabbedPane jYTabbedPane, int n, IButtonFactory iButtonFactory) {
        this.tabPane = jYTabbedPane;
        this.tabIndex = n;
        this.setName("JYTabbedPane.TabOverviewPreviewPanel");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(TabOverviewPreviewPanel.getPreviewPanelInsets(jYTabbedPane)));
        this.titleLabel = new JLabel(jYTabbedPane.getTitleAt(n));
        this.titleLabel.setName("JYTabbedPane.TabOverviewPreviewTitle");
        this.titleLabel.setIcon(jYTabbedPane.getIconAt(n));
        this.updateTitleDefaults();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("JYTabbedPane.TabOverviewPreviewTitlePanel");
        jPanel.setOpaque(false);
        jPanel.add(this.titleLabel);
        jPanel.setMinimumSize(new Dimension());
        jPanel.setBorder(new EmptyBorder(SyntheticaLookAndFeel.getInsets("JYTabbedPane.tabOverview.previewTitlePane.insets", (Component)jYTabbedPane, new Insets(0, 2, 1, 2))));
        Action action = ((BasicJYTabbedPaneUI)jYTabbedPane.getUI()).getTabsPanel().getTab(n).getCloseButton().getAction();
        AbstractButton abstractButton = iButtonFactory.createTabOverviewPreviewCloseButton(jYTabbedPane, n, action);
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jYTabbedPane.getTabCount() == 1 || SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabOverview.closeDialogOnPreviewClose", jYTabbedPane, false)) {
                    TabOverviewPreviewPanel.this.closeDialog();
                } else {
                    final TabOverviewDialog tabOverviewDialog = (TabOverviewDialog)SwingUtilities.getWindowAncestor(TabOverviewPreviewPanel.this);
                    final Rectangle rectangle = tabOverviewDialog.getPreviewDialogScreenBounds(jYTabbedPane);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            tabOverviewDialog.installOverviewPanel(rectangle);
                        }
                    });
                }
            }
        });
        jPanel.add((Component)abstractButton, "After");
        JPanel jPanel2 = new JPanel(null){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (TabOverviewPreviewPanel.this.previewImage != null) {
                    graphics.drawImage(TabOverviewPreviewPanel.this.previewImage, 0, 0, this.getWidth(), this.getHeight(), null);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(TabOverviewPreviewPanel.this.preferredImageWidth, TabOverviewPreviewPanel.this.preferredImageHeight);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel2.setName("JYTabbedPane.TabOverviewPreviewImagePanel");
        if (jYTabbedPane.isEnabledAt(n)) {
            this.addMouseListener(new PreviewPanelMouseHandler());
        }
        this.add((Component)jPanel, "North");
        this.add(jPanel2);
        this.applyComponentOrientation(jYTabbedPane.getComponentOrientation());
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        JYTabbedPanePainter.getInstance().paintTabOverviewPreviewPanel(this.tabPane, this, this.getState(), this.tabIndex, graphics, 0, 0, this.getWidth(), this.getHeight());
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public JYTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    static Insets getPreviewPanelInsets(JTabbedPane jTabbedPane) {
        return SyntheticaLookAndFeel.getInsets("JYTabbedPane.tabOverview.previewPanel.insets", (Component)jTabbedPane, new Insets(2, 2, 2, 2));
    }

    public void setPreviewImage(BufferedImage bufferedImage, int n, int n2) {
        this.previewImage = bufferedImage;
        this.preferredImageWidth = n;
        this.preferredImageHeight = n2;
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getPreviewImage() {
        return this.previewImage;
    }

    public void closeDialog() {
        TabOverviewDialog tabOverviewDialog = (TabOverviewDialog)SwingUtilities.getAncestorOfClass(TabOverviewDialog.class, this);
        tabOverviewDialog.dispose();
    }

    public SyntheticaState getState() {
        SyntheticaState syntheticaState = new SyntheticaState(this.tabIndex == this.tabPane.getSelectedIndex() ? SyntheticaState.State.SELECTED : SyntheticaState.State.UNDEFINED);
        if (this.tabIndex > 0 && this.tabIndex < this.tabPane.getTabCount() && !this.tabPane.isEnabledAt(this.tabIndex)) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        if (this.hover) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        return syntheticaState;
    }

    private void updateTitleDefaults() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof SyntheticaLookAndFeel) {
            SyntheticaState syntheticaState = this.getState();
            SynthStyle synthStyle = SyntheticaLookAndFeel.getStyle(this.titleLabel, Region.LABEL);
            SynthContext synthContext = new SynthContext(this.titleLabel, Region.LABEL, synthStyle, syntheticaState.getState());
            this.titleLabel.setForeground(new Color(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND).getRGB()));
            Font font = SyntheticaLookAndFeel.getFont();
            Font font2 = synthStyle.getFont(synthContext);
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.font.enabled", this.titleLabel, true);
            this.titleLabel.setFont(bl ? new Font(font.getFamily(), font2.getStyle(), font.getSize()) : font2);
        }
    }

    private class PreviewPanelMouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            TabOverviewPreviewPanel.this.closeDialog();
            TabOverviewPreviewPanel.this.tabPane.setSelectedIndex(TabOverviewPreviewPanel.this.tabIndex, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TabOverviewPreviewPanel.this.hover = true;
            TabOverviewPreviewPanel.this.updateTitleDefaults();
            TabOverviewPreviewPanel.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TabOverviewPreviewPanel.this.hover = false;
            TabOverviewPreviewPanel.this.updateTitleDefaults();
            TabOverviewPreviewPanel.this.repaint();
        }
    }
}

