/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IRegionChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class RegionChecker
implements IRegionChecker,
IDockingConstants {
    RegionChecker() {
    }

    public String getRegion(Component component, Point point) {
        Rectangle rectangle;
        Serializable serializable;
        if (component == null || point == null) {
            return "UNKNOWN";
        }
        Rectangle rectangle2 = component.getBounds();
        if (component instanceof IDockingPort) {
            rectangle2.setLocation(0, 0);
        }
        Container container = component.getParent();
        if (DockingManager.isTabReorderByDraggingEnabled() && (container instanceof JTabbedPane || container != null && container.getParent() instanceof JYTabbedPane)) {
            serializable = container instanceof JTabbedPane ? (JTabbedPane)container : (JTabbedPane)container.getParent();
            Point point2 = SwingUtilities.convertPoint(component.getParent(), point, ((Component)serializable).getParent());
            rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle2, ((Component)serializable).getParent());
            if (((Component)serializable).getBounds().contains(point2) && !rectangle.contains(point2)) {
                return "CENTER";
            }
        }
        if (!rectangle2.contains(point)) {
            return "UNKNOWN";
        }
        if (component instanceof IDockingPort) {
            return "CENTER";
        }
        serializable = this.getNorthRegion(component);
        int n = ((Rectangle)serializable).x + ((Rectangle)serializable).width;
        if (((Rectangle)serializable).contains(point)) {
            rectangle = this.getWestRegion(component);
            if (rectangle.contains(point)) {
                Polygon polygon = new Polygon();
                polygon.addPoint(0, 0);
                polygon.addPoint(0, ((Rectangle)serializable).height);
                polygon.addPoint(rectangle.width, ((Rectangle)serializable).height);
                return polygon.contains(point) ? "WEST" : "NORTH";
            }
            Rectangle rectangle3 = this.getEastRegion(component);
            if (rectangle3.contains(point)) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n, 0);
                polygon.addPoint(n, ((Rectangle)serializable).height);
                polygon.addPoint(rectangle3.x, ((Rectangle)serializable).height);
                return polygon.contains(point) ? "EAST" : "NORTH";
            }
            return "NORTH";
        }
        rectangle = this.getSouthRegion(component);
        int n2 = rectangle.y + rectangle.height;
        if (rectangle.contains(point)) {
            Rectangle rectangle4 = this.getWestRegion(component);
            if (rectangle4.contains(point)) {
                Polygon polygon = new Polygon();
                polygon.addPoint(0, rectangle.y);
                polygon.addPoint(rectangle4.width, rectangle.y);
                polygon.addPoint(0, n2);
                return polygon.contains(point) ? "WEST" : "SOUTH";
            }
            Rectangle rectangle5 = this.getEastRegion(component);
            if (rectangle5.contains(point)) {
                Polygon polygon = new Polygon();
                polygon.addPoint(rectangle5.y, rectangle.y);
                polygon.addPoint(n, rectangle.y);
                polygon.addPoint(n, n2);
                return polygon.contains(point) ? "EAST" : "SOUTH";
            }
            return "SOUTH";
        }
        Rectangle rectangle6 = this.getEastRegion(component);
        if (rectangle6.contains(point)) {
            return "EAST";
        }
        Rectangle rectangle7 = this.getWestRegion(component);
        if (rectangle7.contains(point)) {
            return "WEST";
        }
        return "CENTER";
    }

    public Rectangle getNorthRegion(Component component) {
        return this.getRegionBounds(component, "NORTH");
    }

    public Rectangle getSouthRegion(Component component) {
        return this.getRegionBounds(component, "SOUTH");
    }

    public Rectangle getEastRegion(Component component) {
        return this.getRegionBounds(component, "EAST");
    }

    public Rectangle getWestRegion(Component component) {
        return this.getRegionBounds(component, "WEST");
    }

    public Rectangle getRegionBounds(Component component, String string) {
        if (component != null && string != null) {
            float f = this.getRegionSize(component, string);
            return this.calculateRegionalBounds(component, string, f);
        }
        return null;
    }

    public float getRegionSize(Component component, String string) {
        IDockable iDockable = DockingManager.getDockable(component);
        return RegionChecker.getRegionPreference(iDockable, string);
    }

    public Rectangle getSiblingBounds(Component component, String string) {
        if (component != null && string != null) {
            float f = this.getSiblingSize(component, string);
            return this.calculateRegionalBounds(component, string, f);
        }
        return null;
    }

    public float getSiblingSize(Component component, String string) {
        IDockable iDockable = DockingManager.getDockable(component);
        return RegionChecker.getSiblingPreference(iDockable, string);
    }

    protected Rectangle calculateRegionalBounds(Component component, String string, float f) {
        if (component == null || string == null) {
            return null;
        }
        Rectangle rectangle = component.getBounds();
        if ("NORTH".equals(string) || "SOUTH".equals(string)) {
            int n = (int)((float)rectangle.height * f);
            int n2 = "NORTH".equals(string) ? 0 : rectangle.height - n;
            return new Rectangle(0, n2, rectangle.width, n);
        }
        if ("WEST".equals(string) || "EAST".equals(string)) {
            int n = (int)((float)rectangle.width * f);
            int n3 = "WEST".equals(string) ? 0 : rectangle.width - n;
            return new Rectangle(n3, 0, n, rectangle.height);
        }
        return null;
    }

    protected static float getDockingInset(Float f, float f2, float f3, float f4) {
        float f5;
        float f6 = f5 = f == null ? -1.0f : f.floatValue();
        if (f5 == -1.0f) {
            f5 = f2;
        }
        return RegionChecker.checkBounds(f5, f3, f4);
    }

    protected static float checkBounds(float f, float f2, float f3) {
        f = Math.min(f, f2);
        return Math.max(f, f3);
    }

    public static float validateRegionSize(float f) {
        return RegionChecker.checkBounds(f, 0.5f, 0.0f);
    }

    public static float validateSiblingSize(float f) {
        return RegionChecker.checkBounds(f, 1.0f, 0.0f);
    }

    public static float getRegionPreference(IDockable iDockable, String string) {
        Float f = iDockable == null ? null : Float.valueOf(iDockable.getRegionInset(string));
        return RegionChecker.getDockingInset(f, 0.25f, 0.5f, 0.0f);
    }

    public static float getSiblingPreference(IDockable iDockable, String string) {
        Float f = iDockable == null ? null : Float.valueOf(iDockable.getSiblingSize(string));
        return RegionChecker.getDockingInset(f, DockingManager.getDefaultSiblingSize(), 1.0f, 0.0f);
    }
}

