/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DockingUtility
implements IDockingConstants {
    static String DOCKABLE_INDICATOR = "Dockable.DOCKABLE_INDICATOR";

    private DockingUtility() {
    }

    public static IDockingPort getParentDockingPort(IDockable iDockable) {
        return iDockable == null ? null : DockingUtility.getParentDockingPort(iDockable.getComponent());
    }

    public static IDockingPort getParentDockingPort(Component component) {
        IDockingPort iDockingPort;
        IDockingPort iDockingPort2 = iDockingPort = component == null ? null : (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, component));
        if (iDockingPort == null) {
            return null;
        }
        return iDockingPort.isParentDockingPort(component) ? iDockingPort : null;
    }

    public static boolean isSubport(IDockingPort iDockingPort) {
        return iDockingPort == null ? false : SwingUtilities.getAncestorOfClass(IDockingPort.class, iDockingPort.getComponent()) != null;
    }

    public static IDockingPort findDockingPort(Container container, Point point) {
        if (container == null || point == null) {
            return null;
        }
        Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        if (component == null) {
            return null;
        }
        if (component instanceof IDockingPort) {
            return (IDockingPort)((Object)component);
        }
        return (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, component));
    }

    public static Component getDeepestComponentAt(int n, Component component, int n2, int n3) {
        ++n;
        if (!component.contains(n2, n3)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n4 = componentArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Component component2 = componentArray[n5];
                if (component2 != null && component2.isVisible()) {
                    Point point = component2.getLocation();
                    if ((component2 = component2 instanceof Container ? DockingUtility.getDeepestComponentAt(n, component2, n2 - point.x, n3 - point.y) : component2.getComponentAt(n2 - point.x, n3 - point.y)) != null) {
                        return component2;
                    }
                }
                ++n5;
            }
        }
        return component;
    }

    public static String translateRegionAxis(JSplitPane jSplitPane, String string) {
        boolean bl;
        if (jSplitPane == null || !DockingManager.isValidDockingRegion(string)) {
            return null;
        }
        boolean bl2 = bl = jSplitPane.getOrientation() == 1;
        if (bl) {
            if ("NORTH".equals(string)) {
                string = "WEST";
            } else if ("SOUTH".equals(string)) {
                string = "EAST";
            }
        } else if ("WEST".equals(string)) {
            string = "NORTH";
        } else if ("EAST".equals(string)) {
            string = "SOUTH";
        }
        return string;
    }

    public static String flipRegion(String string) {
        if (!DockingManager.isValidDockingRegion(string) || "CENTER".equals(string)) {
            return "CENTER";
        }
        if ("NORTH".equals(string)) {
            return "SOUTH";
        }
        if ("SOUTH".equals(string)) {
            return "NORTH";
        }
        if ("EAST".equals(string)) {
            return "WEST";
        }
        return "EAST";
    }

    public static boolean isAxisEquivalent(String string, String string2) {
        if (!DockingManager.isValidDockingRegion(string) || !DockingManager.isValidDockingRegion(string2)) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        if ("CENTER".equals(string)) {
            return false;
        }
        if ("NORTH".equals(string)) {
            return "WEST".equals(string2);
        }
        if ("SOUTH".equals(string)) {
            return "EAST".equals(string2);
        }
        if ("EAST".equals(string)) {
            return "SOUTH".equals(string2);
        }
        if ("WEST".equals(string)) {
            return "NORTH".equals(string2);
        }
        return false;
    }

    public static boolean isRegionTopLeft(String string) {
        return "NORTH".equals(string) || "WEST".equals(string);
    }

    public static String getRegion(int n) {
        switch (n) {
            case 2: {
                return "WEST";
            }
            case 4: {
                return "EAST";
            }
            case 1: {
                return "NORTH";
            }
            case 3: {
                return "SOUTH";
            }
            case 0: {
                return "CENTER";
            }
        }
        return "UNKNOWN";
    }

    public static int getPlacement(IDockable iDockable) {
        int n = -1;
        DockingState dockingState = iDockable == null ? null : DockingManager.getDockingState(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective());
        return dockingState == null ? n : dockingState.getPlacement();
    }

    public static void setSplitProportion(IDockingPort iDockingPort, float f) {
        if (iDockingPort == null) {
            return;
        }
        JComponent jComponent = iDockingPort.getDockedComponent();
        if (jComponent instanceof JSplitPane) {
            DockingUtility.setSplitDivider((JSplitPane)jComponent, f);
        }
    }

    public static void setSplitProportion(IDockable iDockable, float f) {
        if (iDockable == null) {
            return;
        }
        JComponent jComponent = iDockable.getComponent();
        Container container = jComponent.getParent();
        if (container.getParent() instanceof JYTabbedPane) {
            container = container.getParent().getParent();
        } else if (container instanceof JTabbedPane) {
            container = container.getParent();
        }
        if (!(container instanceof IDockingPort)) {
            return;
        }
        Container container2 = container.getParent();
        if (container2 instanceof JSplitPane) {
            DockingUtility.setSplitDivider((JSplitPane)container2, f);
        }
    }

    private static void setSplitDivider(final JSplitPane jSplitPane, float f) {
        if (jSplitPane == null) {
            return;
        }
        f = Math.max(0.0f, f);
        final float f2 = Math.min(1.0f, f);
        int n = DockingUtility.getSplitPaneSize(jSplitPane);
        if (jSplitPane.isVisible() && n > 0 && EventQueue.isDispatchThread()) {
            jSplitPane.setDividerLocation(f);
            jSplitPane.validate();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockingUtility.setSplitDivider(jSplitPane, f2);
            }
        });
    }

    private static int getSplitPaneSize(JSplitPane jSplitPane) {
        if (jSplitPane == null) {
            return 0;
        }
        boolean bl = jSplitPane.getOrientation() == 1;
        return bl ? jSplitPane.getWidth() : jSplitPane.getHeight();
    }

    public static IDockable getAncestorDockable(Component component) {
        if (component == null) {
            return null;
        }
        if (DockingUtility.isDockable(component)) {
            return DockingManager.getDockable(component);
        }
        Container container = component.getParent();
        while (container != null && !(container instanceof JRootPane)) {
            if (DockingUtility.isDockable(container)) {
                return DockingManager.getDockable(container);
            }
            container = container.getParent();
        }
        return null;
    }

    static boolean isDockable(Object object) {
        if (object instanceof IDockable) {
            return true;
        }
        if (object instanceof JComponent) {
            return ((JComponent)object).getClientProperty(DOCKABLE_INDICATOR) == Boolean.TRUE;
        }
        return false;
    }

    public static float calcSplitRatio(JSplitPane jSplitPane) {
        if (jSplitPane == null) {
            return 0.0f;
        }
        int n = jSplitPane.getOrientation() == 1 ? jSplitPane.getWidth() : jSplitPane.getHeight();
        int n2 = jSplitPane.getDividerLocation();
        return n == 0 ? 0.0f : (float)n2 / (float)(n - jSplitPane.getDividerSize());
    }

    public static int calcDividerLocation(JSplitPane jSplitPane, float f) {
        if (jSplitPane == null) {
            return 0;
        }
        int n = jSplitPane.getOrientation() == 1 ? jSplitPane.getWidth() : jSplitPane.getHeight();
        return (int)((float)(n - jSplitPane.getDividerSize()) * f);
    }

    public static Window getActiveWindow() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getActiveWindow();
    }

    public static Container getContentPane(Component component) {
        RootWindow rootWindow = RootWindow.getRootWindow(component);
        return rootWindow == null ? null : rootWindow.getContentPane();
    }

    public static Object getInstance(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return DockingUtility.createInstance(string);
        }
    }

    public static Object createInstance(String string) {
        return DockingUtility.createInstance(string, null);
    }

    public static Object createInstance(String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz2 = Class.forName(string);
            if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
                throw new ClassCastException("'" + clazz2.getName() + "' is not a type of " + clazz + ".");
            }
            return clazz2.newInstance();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static boolean isChanged(Object object, Object object2) {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return true;
        }
        return !object.equals(object2);
    }

    public static String nodeToString(TreeNode treeNode, int n, StringBuilder stringBuilder) {
        if (treeNode == null) {
            return stringBuilder.toString();
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("  ");
            ++n2;
        }
        stringBuilder.append(treeNode);
        stringBuilder.append("\n");
        n2 = 0;
        while (n2 < treeNode.getChildCount()) {
            DockingUtility.nodeToString(treeNode.getChildAt(n2), n + 1, stringBuilder);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static void printComponentTreeUp(int n, Container container) {
        ++n;
        int n2 = 0;
        while (n2 < n) {
            System.err.print("  ");
            ++n2;
        }
        System.err.print(container.getClass());
        System.err.println();
        Container container2 = container.getParent();
        if (container2 != null) {
            DockingUtility.printComponentTreeUp(n, container2);
        }
    }

    public static void printComponentTreeDown(int n, Container container) {
        ++n;
        int n2 = 0;
        while (n2 < n) {
            System.err.print("  ");
            ++n2;
        }
        System.err.print(container.getClass());
        System.err.println();
        Component[] componentArray = container.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            DockingUtility.printComponentTreeDown(n, (Container)component);
            ++n4;
        }
    }
}

