/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.swing.JYDockingView;
import de.javasoft.swing.jydocking.BorderManager;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPort;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYDockingPort
extends DockingPort
implements IDockingConstants {
    private static final long serialVersionUID = -4694207726734641902L;
    protected HashSet<String> blockedRegions = new HashSet(5);

    static {
        if (DockingManager.getDockingStrategy(JYDockingPort.class) == null) {
            DockingManager.setDockingStrategy(JYDockingPort.class, JYDockingView.VIEW_DOCKING_STRATEGY);
        }
    }

    public JYDockingPort() {
        this(UUID.randomUUID().toString());
    }

    public JYDockingPort(String string) {
        super(string);
        this.setBorderManager(new BorderManager());
    }

    public void setRegionBlocked(String string, boolean bl) {
        if (bl) {
            this.blockedRegions.add(string);
        } else {
            this.blockedRegions.remove(string);
        }
    }

    public boolean isRegionBlocked(String string) {
        return this.blockedRegions.contains(string);
    }

    public Set<IDockable> getViewset(int n) {
        return this.getDockables(n, 0, JYDockingView.class);
    }

    @Override
    public boolean isDockingAllowed(Component component, String string) {
        if (!super.isDockingAllowed(component, string)) {
            return false;
        }
        if (!"CENTER".equals(string)) {
            return true;
        }
        IDockable iDockable = this.getCenterDockable();
        if (iDockable == null) {
            return true;
        }
        return true;
    }

    @Override
    protected String paramString() {
        return "id=" + this.getID() + "," + super.paramString();
    }
}

