/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.SyntheticaIconPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaSoftCache;
import de.javasoft.util.OS;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaBasicIconPainter
extends SyntheticaIconPainter
implements Cacheable {
    private SynthContext sc;
    private int width;
    private int height;
    private static final boolean OS_X_QUARTZ_ENABLED = SyntheticaLookAndFeel.isSystemPropertySet("apple.awt.graphics.UseQuartz");

    public SyntheticaBasicIconPainter() {
        this(null, 16, 16);
    }

    public SyntheticaBasicIconPainter(SynthContext synthContext, int n, int n2) {
        this.sc = synthContext;
        this.width = n;
        this.height = n2;
    }

    protected float getScale() {
        return 1.0f;
    }

    protected BasicStroke createStroke(SynthContext synthContext) {
        return new BasicStroke(1.0f);
    }

    public int getIconHeight() {
        return (int)((float)this.height * this.getScale());
    }

    public int getIconWidth() {
        return (int)((float)this.width * this.getScale());
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        SynthContext synthContext = this.sc;
        if (synthContext == null && component instanceof AbstractButton && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            AbstractButton abstractButton = (AbstractButton)component;
            SynthStyle synthStyle = SyntheticaLookAndFeel.getStyle(abstractButton, Region.BUTTON);
            int n3 = 0;
            n3 |= abstractButton.getModel().isPressed() ? 4 : 0;
            n3 |= abstractButton.getModel().isSelected() ? 512 : 0;
            n3 |= !abstractButton.getModel().isEnabled() ? 8 : 0;
            synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, n3 |= abstractButton.getModel().isRollover() ? 2 : 0);
        }
        this.paintIcon(synthContext, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
    }

    public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.paintCachedImage(synthContext, graphics, n, n2, n3, n4)) {
            this.paintIcon_(synthContext, graphics, n, n2, n3, n4);
        }
    }

    private void paintIcon_(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        AffineTransform affineTransform = graphics2D.getTransform();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        BasicStroke basicStroke = this.createStroke(synthContext);
        graphics2D.setStroke(basicStroke);
        AffineTransform affineTransform2 = new AffineTransform();
        if (OS.getCurrentOS() == OS.Mac && OS_X_QUARTZ_ENABLED) {
            affineTransform2.translate((long)n + Math.round((double)(this.getScale() / 2.0f) - 0.5), (long)n2 + Math.round((double)(this.getScale() / 2.0f) - 0.5));
        } else {
            affineTransform2.translate((float)n + this.getScale() / 2.0f, (float)n2 + this.getScale() / 2.0f);
        }
        affineTransform2.scale(this.getScale(), this.getScale());
        graphics2D.transform(affineTransform2);
        this.paint2D(synthContext, (Graphics2D)graphics, n, n2, this.width - 1, this.height - 1);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setTransform(affineTransform);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object2);
    }

    private boolean paintCachedImage(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (synthContext == null || !UIManager.getBoolean("Synthetica.cache.enabled") || (n5 = this.getCacheHash(synthContext, n3, n4, 0, "")) == -1 || !SyntheticaSoftCache.getInstance().isCacheable(n3, n4)) {
            return false;
        }
        VolatileImage volatileImage = this.getCachedImage(n5, synthContext, graphics, n3, n4);
        boolean bl = volatileImage == null ? false : graphics.drawImage(volatileImage, n, n2, null);
        return bl;
    }

    private VolatileImage getCachedImage(int n, SynthContext synthContext, Graphics graphics, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = ((Graphics2D)graphics).getDeviceConfiguration();
        SyntheticaSoftCache syntheticaSoftCache = SyntheticaSoftCache.getInstance();
        VolatileImage volatileImage = (VolatileImage)syntheticaSoftCache.getImage(n);
        do {
            int n4;
            int n5 = n4 = volatileImage == null ? 2 : volatileImage.validate(graphicsConfiguration);
            if (n4 != 2 && n4 != 1) continue;
            if (n4 == 2 || volatileImage.getWidth() != n2 || volatileImage.getHeight() != n3) {
                if (volatileImage != null) {
                    volatileImage.flush();
                    volatileImage = null;
                }
                volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n2, n3, 3);
                syntheticaSoftCache.setImage(volatileImage, n);
            }
            Graphics2D graphics2D = volatileImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n2, n3);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            this.paintIcon_(synthContext, graphics2D, 0, 0, n2, n3);
            graphics2D.dispose();
        } while (volatileImage.contentsLost());
        return volatileImage;
    }

    public void paint2D(SynthContext synthContext, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
    }

    protected Rectangle2D.Float calc2DBounds(Graphics2D graphics2D, float f, float f2) {
        float f3 = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
        float f4 = f3 / 2.0f - 0.5f;
        return new Rectangle2D.Float(f4, f4, f - f3 + 1.0f, f2 - f3 + 1.0f);
    }

    protected static Shape subtractStroke(Graphics2D graphics2D, Shape shape) {
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.2D.subtractStrokeEnabled", null)) {
            return shape;
        }
        Area area = new Area(((BasicStroke)graphics2D.getStroke()).createStrokedShape(shape));
        Area area2 = new Area(shape);
        area2.subtract(area);
        return area2;
    }

    protected Color getSyntheticaBackgroundColor(JComponent jComponent) {
        Color color = (Color)jComponent.getClientProperty("Synthetica.background");
        if (color != null) {
            float f = jComponent.getClientProperty("Synthetica.background.alpha") == null ? 0.1f : ((Float)jComponent.getClientProperty("Synthetica.background.alpha")).floatValue();
            int n = color.getRGB() & ((int)(f * 255.0f) << 24 | 0xFFFFFF);
            color = new Color(n, true);
        }
        return color;
    }

    protected Paint createLinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        return SyntheticaLookAndFeel.createLinearGradientPaint(f, f2, f3, f4, fArray, colorArray);
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        int n4 = string.hashCode();
        n4 = 31 * n4 + n;
        n4 = 31 * n4 + n2;
        n4 = 31 * n4 + n3;
        n4 = 31 * n4 + (int)this.getScale() * 100;
        n4 = 31 * n4 + this.getClass().hashCode();
        if (synthContext != null) {
            JComponent jComponent = synthContext.getComponent();
            String string2 = SyntheticaLookAndFeel.getStyleName(jComponent);
            Color color = (Color)jComponent.getClientProperty("Synthetica.background");
            Float f = (Float)jComponent.getClientProperty("Synthetica.background.alpha");
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            n4 = 31 * n4 + jComponent.getClass().hashCode();
            n4 = 31 * n4 + synthContext.getComponentState();
            n4 = string2 == null ? n4 : 31 * n4 + string2.hashCode();
            n4 = color == null ? n4 : n4 * 31 + color.getRGB();
            n4 = f == null ? n4 : n4 * 31 + (int)(f.floatValue() * 100.0f);
            n4 = 31 * n4 + (window == null || window.isActive() ? 0 : 1);
        }
        return n4;
    }

    public Cacheable.ScaleType getCacheScaleType(String string) {
        return Cacheable.ScaleType.NONE;
    }

    public Insets getCacheScaleInsets(SynthContext synthContext, String string) {
        int n = (int)(this.getScale() * 10.0f);
        return new Insets(n, n, n, n);
    }
}

