/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;

public class JYTabbedPanePainter
extends SyntheticaComponentPainter {
    public static final String JYTABBEDPANE_PAINTER = "Synthetica.JYTabbedPanePainter";
    private int[] xCrop;
    private int[] yCrop;
    private int cropSegmentSize;

    protected JYTabbedPanePainter() {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        this.xCrop = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 6;
        nArray2[5] = 9;
        nArray2[6] = 9;
        nArray2[7] = 12;
        this.yCrop = nArray2;
        this.cropSegmentSize = 12;
    }

    public static JYTabbedPanePainter getInstance() {
        return JYTabbedPanePainter.getInstance(null);
    }

    public static JYTabbedPanePainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(JYTabbedPanePainter.getPainterClassName(synthContext, JYTabbedPanePainter.class, JYTABBEDPANE_PAINTER));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = JYTabbedPanePainter.getInstance(synthContext, JYTabbedPanePainter.class, JYTABBEDPANE_PAINTER);
        }
        return (JYTabbedPanePainter)syntheticaComponentPainter;
    }

    public void paintTabbedPaneTabAreaBackground(JComponent jComponent, SyntheticaState syntheticaState, int n, int n2, Graphics graphics, int n3, int n4, int n5, int n6) {
        TabbedPanePainter.getInstance().paintTabbedPaneTabAreaBackground(jComponent, syntheticaState, n, n2, graphics, n3, n4, n5, n6);
    }

    public void paintTabbedPaneContentBorder(JComponent jComponent, SyntheticaState syntheticaState, int n, boolean bl, int n2, Graphics graphics, int n3, int n4, int n5, int n6) {
        TabbedPanePainter.getInstance().paintTabbedPaneContentBorder(jComponent, syntheticaState, n, bl, n2, graphics, n3, n4, n5, n6);
    }

    public void paintTabbedPaneTab(JComponent jComponent, SyntheticaState syntheticaState, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6, int n7, int n8) {
        TabbedPanePainter.getInstance().paintTabbedPaneTab(jComponent, syntheticaState, n, n2, n3, n4, graphics, n5, n6, n7, n8);
    }

    public void paintCroppedEdge(JComponent jComponent, SyntheticaState syntheticaState, int n, boolean bl, Graphics graphics, int n2, int n3, int n4, int n5, Color color, Color color2) {
        boolean bl2 = n == 2 || n == 4;
        boolean bl3 = jComponent.getComponentOrientation().isLeftToRight();
        String string = "JYTabbedPane.tabsPanel.croppedEdge.image";
        string = bl2 ? String.valueOf(string) + (n == 2 ? (bl ? ".trailing" : ".leading") : (bl ? ".leading" : ".trailing")) : String.valueOf(string) + (bl3 ? (bl ? ".leading" : ".trailing") : (bl ? ".trailing" : ".leading"));
        Insets insets = SyntheticaLookAndFeel.getInsets(String.valueOf(string) + ".insets", jComponent);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = insets;
        if ((string = SyntheticaLookAndFeel.getString(string, jComponent)) != null) {
            Boolean bl4 = (Boolean)jComponent.getClientProperty("Synthetica.flipVertical");
            jComponent.putClientProperty("Synthetica.flipVertical", n == 3 || n == 2 && !bl3 || n == 4 && !bl3);
            ImagePainter imagePainter = new ImagePainter(jComponent, graphics, n2, n3, bl2 ? n5 : n4, bl2 ? n4 : n5, string, insets, insets2, 0, 0);
            if (n == 2) {
                imagePainter.setAngle(-90);
            } else if (n == 4) {
                imagePainter.setAngle(90);
            }
            imagePainter.draw();
            jComponent.putClientProperty("Synthetica.flipVertical", bl4);
        } else {
            Shape shape = this.createCroppedEdgeShape(n, bl, bl3, n2, n3, n4, n5);
            Graphics2D graphics2D = this.prepareGraphics2D(null, graphics, n2, n3, true);
            graphics2D.setPaint(color);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
            shape = this.createCroppedLineShape(n, bl, bl3, n2, n3, n4, n5);
            graphics2D.setPaint(color2);
            graphics2D.draw(shape);
            this.restoreGraphics2D(graphics2D);
        }
    }

    protected Shape createCroppedLineShape(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        GeneralPath generalPath = new GeneralPath();
        if (n == 2 || n == 4) {
            int n6 = bl ? n5 - 1 : 2;
            int n7 = n2;
            generalPath.moveTo(n7 + this.yCrop[0], (n3 += n6) - this.xCrop[0]);
            while (n7 <= n2 + n4) {
                int n8 = 0;
                while (n8 < this.xCrop.length) {
                    generalPath.lineTo(n7 + this.yCrop[n8 + 1] - 3, n3 - this.xCrop[n8 + 1]);
                    n8 += 2;
                }
                n7 += this.cropSegmentSize;
            }
        } else {
            int n9 = (bl ^= !bl2) ? n4 - 1 : 2;
            int n10 = n3;
            generalPath.moveTo((n2 += n9) - this.xCrop[0], n10 + this.yCrop[0]);
            while (n10 <= n3 + n5) {
                int n11 = 0;
                while (n11 < this.xCrop.length) {
                    generalPath.lineTo(n2 - this.xCrop[n11 + 1], n10 + this.yCrop[n11 + 1] - 3);
                    n11 += 2;
                }
                n10 += this.cropSegmentSize;
            }
        }
        return generalPath;
    }

    protected Shape createCroppedEdgeShape(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        GeneralPath generalPath = (GeneralPath)this.createCroppedLineShape(n, bl, bl2, n2, n3, n4, n5);
        if (n == 2 || n == 4) {
            int n6 = n3 + (bl ? 0 : n5 - 1);
            int n7 = n2 + n4 - 1;
            generalPath.lineTo(n7, n6);
            generalPath.lineTo(n2, n6);
        } else {
            int n8 = n2 + ((bl ^= !bl2) ? 0 : n4 - 1);
            int n9 = n3 + n5 - 1;
            generalPath.lineTo(n8, n9);
            generalPath.lineTo(n8, n3);
        }
        generalPath.closePath();
        return generalPath;
    }

    public void paintTabOverviewPreviewPanel(JComponent jComponent, JPanel jPanel, SyntheticaState syntheticaState, int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        UIKey uIKey = new UIKey("tabOverviewPreviewPanel", syntheticaState, "JYTabbedPane.");
        String string = (String)UIKey.findProperty(jComponent, uIKey.get(), "background.image", true, 2);
        if (string != null) {
            Serializable serializable;
            if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabOverviewPreviewPanel.colorizeSupport.enabled", jComponent)) {
                String string2 = "Synthetica.tabbedPane.tab." + n + ".background";
                Color color = (Color)jComponent.getClientProperty(string2);
                Color color2 = this.getTabBackgroundAt(jComponent, n);
                if (color == null && color2 != null && !(color2 instanceof UIResource)) {
                    color = color2;
                }
                if (color != null) {
                    int n6;
                    jPanel.putClientProperty("Synthetica.background", color);
                    serializable = null;
                    if (jComponent.getClientProperty(String.valueOf(string2) + ".alpha") != null) {
                        serializable = (Float)jComponent.getClientProperty(String.valueOf(string2) + ".alpha");
                    }
                    if ((n6 = SyntheticaLookAndFeel.getInt(syntheticaState.isSet(SyntheticaState.State.HOVER) ? "JYTabbedPane.tabOverviewPreviewPanel.hover.background.alpha" : "JYTabbedPane.tabOverviewPreviewPanel.background.alpha", jComponent, -1)) >= 0) {
                        serializable = Float.valueOf(new Float(n6).floatValue() / 100.0f);
                    }
                    jPanel.putClientProperty("Synthetica.background.alpha", serializable);
                }
            }
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jComponent, 1);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jComponent, 50);
            int n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, syntheticaState.isSet(SyntheticaState.State.HOVER) ? 1 : 2);
            serializable = SyntheticaLookAndFeel.getInsets("JYTabbedPane.tabOverviewPreviewPanel.background.image.insets", (Component)jComponent, new Insets(0, 0, 0, 0));
            Insets insets = (Insets)serializable.clone();
            ImagePainter imagePainter = new ImagePainter((JComponent)jPanel, n7, n8, n9, syntheticaState.getState(), graphics, n2, n3, n4, n5, string, (Insets)serializable, insets, 0, 0);
            imagePainter.draw();
        } else {
            Graphics2D graphics2D = this.prepareGraphics2D(null, graphics, n2, n3, true);
            float f = this.scaleArc(2.0f);
            Shape shape = this.createTabOverviewPreviewShape(0.0f, 0.0f, JYTabbedPanePainter.calcRelativeLength(graphics2D, n4, 0.0f), JYTabbedPanePainter.calcRelativeLength(graphics2D, n5, 0.0f), f);
            graphics2D.setPaint(this.getTabOverviewPreviewBackgroundColor(syntheticaState));
            graphics2D.fill(shape);
            if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabOverviewPreviewPanel.colorizeSupport.enabled", jComponent)) {
                String string3 = "Synthetica.tabbedPane.tab." + n + ".background";
                Color color = (Color)jComponent.getClientProperty(string3);
                Color color3 = this.getTabBackgroundAt(jComponent, n);
                if (color == null && color3 != null && !(color3 instanceof UIResource)) {
                    color = color3;
                }
                if (color != null) {
                    Float f2 = (Float)jComponent.getClientProperty(String.valueOf(string3) + ".alpha");
                    int n10 = SyntheticaLookAndFeel.getInt(syntheticaState.isSet(SyntheticaState.State.HOVER) ? "JYTabbedPane.tabOverviewPreviewPanel.hover.background.alpha" : "JYTabbedPane.tabOverviewPreviewPanel.background.alpha", jComponent, -1);
                    if (n10 >= 0) {
                        f2 = Float.valueOf(new Float(n10).floatValue() / 100.0f);
                    }
                    graphics2D.setPaint(this.createAlphaColor(color, f2));
                    graphics2D.fill(JYTabbedPanePainter.subtractStroke(graphics2D, shape));
                }
            }
            graphics2D.setPaint(this.getTabOverviewPreviewBorderColor(syntheticaState));
            graphics2D.draw(shape);
            this.restoreGraphics2D(graphics2D);
        }
    }

    private Color getTabBackgroundAt(JComponent jComponent, int n) {
        JTabbedPane jTabbedPane;
        Color color = null;
        if (jComponent instanceof JTabbedPane && n < (jTabbedPane = (JTabbedPane)jComponent).getTabCount()) {
            color = jTabbedPane.getBackgroundAt(n);
        }
        return color;
    }

    protected Color getTabOverviewPreviewBorderColor(SyntheticaState syntheticaState) {
        return syntheticaState.isSet(SyntheticaState.State.HOVER) ? new Color(-2147442448, true) : new Color(0x2F000000, true);
    }

    protected Color getTabOverviewPreviewBackgroundColor(SyntheticaState syntheticaState) {
        return syntheticaState.isSet(SyntheticaState.State.HOVER) ? new Color(1073783024, true) : new Color(0x1A000000, true);
    }

    protected Shape createTabOverviewPreviewShape(float f, float f2, float f3, float f4, float f5) {
        return new RoundRectangle2D.Float(f, f2, f3, f4, f5, f5);
    }
}

