/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.JBUI;
import java.awt.Font;
import javax.swing.plaf.UIResource;

public class JBFont
extends Font {
    private JBFont(Font font) {
        super(font);
    }

    public static JBFont create(Font font) {
        return JBFont.create(font, true);
    }

    public static JBFont create(Font font, boolean tryToScale) {
        if (font instanceof JBFont) {
            return (JBFont)font;
        }
        Font scaled = font;
        if (tryToScale) {
            scaled = font.deriveFont((float)font.getSize() * JBUI.scale(1.0f));
        }
        if (font instanceof UIResource) {
            return new JBFontUIResource(scaled);
        }
        return new JBFont(scaled);
    }

    public JBFont asBold() {
        return this.deriveFont(1, this.getSize());
    }

    public JBFont asItalic() {
        return this.deriveFont(2, this.getSize());
    }

    public JBFont asPlain() {
        return this.deriveFont(0, this.getSize());
    }

    @Override
    public JBFont deriveFont(int style, float size) {
        return JBFont.create(super.deriveFont(style, size), false);
    }

    @Override
    public JBFont deriveFont(float size) {
        return JBFont.create(super.deriveFont(size), false);
    }

    public JBFont biggerOn(float size) {
        return this.deriveFont((float)this.getSize() + JBUI.scale(size));
    }

    public JBFont lessOn(float size) {
        return this.deriveFont((float)this.getSize() - JBUI.scale(size));
    }

    private static class JBFontUIResource
    extends JBFont
    implements UIResource {
        private JBFontUIResource(Font font) {
            super(font);
        }
    }
}

