/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentSoftValueHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap", "<init>"));
        }
        super(map);
    }

    public ConcurrentSoftValueHashMap() {
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    @NotNull
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        MySoftReference mySoftReference = new MySoftReference(key, value, this.myQueue);
        if (mySoftReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        return mySoftReference;
    }

    private static class MySoftReference<K, V>
    extends SoftReference<V>
    implements ConcurrentRefValueHashMap.ValueReference<K, V> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull V referent, @NotNull ReferenceQueue<V> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/bulenkov/iconloader/util/ConcurrentSoftValueHashMap$MySoftReference", "getKey"));
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            Object v = this.get();
            Object thatV = that.get();
            return this.key.equals(that.getKey()) && v != null && thatV != null && v.equals(thatV);
        }
    }
}

