/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation.join;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.relation.join.ResizeableByteArrayOS;
import com.amazon.sqlengine.executor.etree.temptable.IRowBlock;
import com.amazon.sqlengine.executor.etree.temptable.InMemTable;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSliceBuilder;
import com.amazon.sqlengine.utilities.ExternalAlgorithmUtil;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;

public class RowFile
implements IRowBlock {
    private static final String PACKAGE_NAME = "com.amazon.sqlengine.executor.etree.relation.join";
    private static final String CLASS_NAME = "RowFile";
    private File m_tempFile;
    private FileOutputStream m_fileOut;
    private ResizeableByteArrayOS m_bos;
    private ObjectOutputStream m_objectOut;
    private ObjectInputStream m_objectIn;
    private ILogger m_logger;
    private final IColumn[] m_metadata;
    private int m_longDataBorder;
    private long m_rowCount;
    private long m_currentRow;
    private ColumnSliceArray m_row;
    private boolean m_isWriting;
    private boolean[] m_dataNeeded;

    public RowFile(IColumn[] iColumnArray, File file, ILogger iLogger, int n, boolean[] blArray) throws ErrorException {
        this.m_logger = iLogger;
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.m_metadata = (IColumn[])iColumnArray.clone();
        this.m_dataNeeded = (boolean[])blArray.clone();
        this.m_longDataBorder = n;
        this.m_rowCount = 0L;
        this.m_currentRow = -1L;
        this.m_row = ColumnSliceBuilder.buildColumnSliceArray(iColumnArray, blArray, 1, n);
        this.m_isWriting = true;
        this.m_tempFile = ExternalAlgorithmUtil.createTempFile(file, this.m_logger);
    }

    @Override
    public void close() {
        this.closeStreams();
        if (null != this.m_tempFile) {
            if (this.m_tempFile.exists() && !this.m_tempFile.delete() && null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "close", "Cannot delete temprary file: " + this.m_tempFile.getAbsolutePath());
            }
            this.m_tempFile = null;
        }
    }

    public IColumn[] getMetadata() {
        return (IColumn[])this.m_metadata.clone();
    }

    @Override
    public boolean isNull(int n) {
        return this.m_row.get(n).isNull(0);
    }

    public long getRowCount() {
        if (this.m_isWriting) {
            return -1L;
        }
        return this.m_rowCount;
    }

    @Override
    public long getBigInt(int n) {
        return this.m_row.get(n).getBigInt(0);
    }

    @Override
    public BigDecimal getExactNumber(int n) {
        return this.m_row.get(n).getExactNum(0);
    }

    @Override
    public double getDouble(int n) {
        return this.m_row.get(n).getDouble(0);
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        return this.m_row.get(n).getFileMarker(0);
    }

    @Override
    public float getReal(int n) {
        return this.m_row.get(n).getReal(0);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.m_row.get(n).getBoolean(0);
    }

    @Override
    public String getString(int n) {
        return this.m_row.get(n).getString(0);
    }

    @Override
    public Date getDate(int n) {
        return this.m_row.get(n).getDate(0);
    }

    @Override
    public Time getTime(int n) {
        return this.m_row.get(n).getTime(0);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        return this.m_row.get(n).getTimestamp(0);
    }

    @Override
    public UUID getGuid(int n) {
        return this.m_row.get(n).getGuid(0);
    }

    @Override
    public int getInteger(int n) {
        return this.m_row.get(n).getInteger(0);
    }

    @Override
    public short getSmallInt(int n) {
        return this.m_row.get(n).getSmallInt(0);
    }

    @Override
    public byte getTinyInt(int n) {
        return this.m_row.get(n).getTinyInt(0);
    }

    @Override
    public byte[] getBytes(int n) {
        return this.m_row.get(n).getBytes(0);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata[n];
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (this.m_isWriting) {
            this.m_isWriting = false;
        }
        if (null == this.m_objectIn) {
            this.prepareToRead();
        }
        if (this.m_currentRow + 1L >= this.m_rowCount) {
            return false;
        }
        ++this.m_currentRow;
        try {
            this.readRow();
            return true;
        }
        catch (Exception exception) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "moveToNextRow", exception.getMessage());
            }
            throw SQLEngineExceptionFactory.failedToReadData(exception);
        }
    }

    @Override
    public void reset() {
        this.m_isWriting = false;
        this.m_currentRow = -1L;
        this.closeStreams();
    }

    public void writeRows(InMemTable inMemTable, List<Integer> list, int n) throws ErrorException {
        assert (this.m_isWriting);
        this.resetOutStreams(n);
        try {
            long l = 0L;
            int n2 = 0;
            for (int n3 : list) {
                int n4;
                byte[] byArray = new byte[(this.m_metadata.length + 7) / 8];
                for (n4 = 0; n4 < this.m_metadata.length; ++n4) {
                    if (!this.m_dataNeeded[n4] || !inMemTable.isNull(n3, n4)) continue;
                    BitsUtil.setBit(byArray, n4);
                }
                this.m_objectOut.writeObject(byArray);
                for (n4 = 0; n4 < this.m_metadata.length; ++n4) {
                    if (!this.m_dataNeeded[n4] || BitsUtil.isSet(byArray, n4)) continue;
                    this.writeColumn(inMemTable, this.m_objectOut, n3, n4);
                }
                n4 = this.m_bos.size() - n2;
                if ((long)n4 > l) {
                    l = n4;
                }
                if ((long)this.m_bos.size() + l >= (long)n) {
                    this.m_objectOut.reset();
                    this.m_objectOut.flush();
                    this.m_bos.writeToOutputStream(this.m_fileOut);
                    this.m_bos.reset();
                }
                n2 = this.m_bos.size();
            }
            this.m_objectOut.reset();
            this.m_objectOut.flush();
            this.m_bos.writeToOutputStream(this.m_fileOut);
            this.m_rowCount += (long)list.size();
        }
        catch (IOException iOException) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "writeRow", "Could not create input stream.");
            }
            throw SQLEngineExceptionFactory.failedToWriteData(iOException);
        }
        finally {
            this.m_bos.destroyBuffer(0);
        }
    }

    private void resetOutStreams(int n) throws ErrorException {
        if (null == this.m_objectOut) {
            try {
                this.m_fileOut = new FileOutputStream(this.m_tempFile);
                this.m_bos = new ResizeableByteArrayOS(n);
                this.m_objectOut = new ObjectOutputStream(this.m_bos);
            }
            catch (Exception exception) {
                if (null != this.m_logger) {
                    this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, CLASS_NAME, "Could not create temporary file.");
                }
                throw SQLEngineExceptionFactory.failedToCreateFile(this.m_tempFile.getAbsolutePath(), exception.getLocalizedMessage());
            }
        } else {
            this.m_bos.destroyBuffer(n);
        }
    }

    private void prepareToRead() throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.m_currentRow = -1L;
        this.closeStreams();
        try {
            this.m_objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.m_tempFile)));
        }
        catch (Exception exception) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "prepareToRead", "Could not create input stream.");
            }
            throw SQLEngineExceptionFactory.failedToReadData(exception);
        }
    }

    private void writeColumn(InMemTable inMemTable, ObjectOutputStream objectOutputStream, int n, int n2) throws IOException {
        switch (this.m_metadata[n2].getTypeMetadata().getType()) {
            case -5: {
                objectOutputStream.writeLong(inMemTable.getBigInt(n, n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (ColumnSizeCalculator.isLongData(this.m_metadata[n2], this.m_longDataBorder)) {
                    TemporaryFile.FileMarker fileMarker = inMemTable.getFileMarker(n, n2);
                    objectOutputStream.writeLong(fileMarker.m_pos);
                    objectOutputStream.writeLong(fileMarker.m_length);
                    break;
                }
                objectOutputStream.writeObject(inMemTable.getBytes(n, n2));
                break;
            }
            case -7: 
            case 16: {
                objectOutputStream.writeBoolean(inMemTable.getBoolean(n, n2));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                if (ColumnSizeCalculator.isLongData(this.m_metadata[n2], this.m_longDataBorder)) {
                    TemporaryFile.FileMarker fileMarker = inMemTable.getFileMarker(n, n2);
                    objectOutputStream.writeLong(fileMarker.m_pos);
                    objectOutputStream.writeLong(fileMarker.m_length);
                    break;
                }
                objectOutputStream.writeObject(inMemTable.getString(n, n2));
                break;
            }
            case 91: {
                objectOutputStream.writeObject(inMemTable.getDate(n, n2));
                break;
            }
            case 6: 
            case 8: {
                objectOutputStream.writeDouble(inMemTable.getDouble(n, n2));
                break;
            }
            case 2: 
            case 3: {
                objectOutputStream.writeObject(inMemTable.getExactNum(n, n2));
                break;
            }
            case -11: {
                objectOutputStream.writeObject(inMemTable.getGuid(n, n2));
                break;
            }
            case 4: {
                objectOutputStream.writeInt(inMemTable.getInteger(n, n2));
                break;
            }
            case 7: {
                objectOutputStream.writeFloat(inMemTable.getReal(n, n2));
                break;
            }
            case 5: {
                objectOutputStream.writeShort(inMemTable.getSmallInt(n, n2));
                break;
            }
            case 92: {
                objectOutputStream.writeObject(inMemTable.getTime(n, n2));
                break;
            }
            case 93: {
                objectOutputStream.writeObject(inMemTable.getTimestamp(n, n2));
                break;
            }
            case -6: {
                objectOutputStream.writeByte(inMemTable.getTinyInt(n, n2));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown data type: %d.", this.m_metadata[n2].getTypeMetadata().getType()));
            }
        }
    }

    private void closeStreams() {
        try {
            if (null != this.m_objectIn) {
                this.m_objectIn.close();
            }
        }
        catch (IOException iOException) {
            this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "closeStreams", "Cannot close ObjectInputStream");
        }
        try {
            if (null != this.m_fileOut) {
                this.m_fileOut.close();
            }
        }
        catch (IOException iOException) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "closeStreams", "Cannot close ObjectOutputStream");
            }
        }
        finally {
            this.m_objectIn = null;
            this.m_fileOut = null;
            this.m_bos = null;
            this.m_objectOut = null;
        }
    }

    private void readRow() throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])this.m_objectIn.readObject();
        block16: for (int i = 0; i < this.m_metadata.length; ++i) {
            if (!this.m_dataNeeded[i]) continue;
            if (BitsUtil.isSet(byArray, i)) {
                this.m_row.get(i).setNull(0);
                continue;
            }
            switch (this.m_metadata[i].getTypeMetadata().getType()) {
                case -7: 
                case 16: {
                    this.m_row.get(i).setBoolean(0, this.m_objectIn.readBoolean());
                    continue block16;
                }
                case -5: {
                    this.m_row.get(i).setBigInt(0, this.m_objectIn.readLong());
                    continue block16;
                }
                case 6: 
                case 8: {
                    this.m_row.get(i).setDouble(0, this.m_objectIn.readDouble());
                    continue block16;
                }
                case 4: {
                    this.m_row.get(i).setInteger(0, this.m_objectIn.readInt());
                    continue block16;
                }
                case 7: {
                    this.m_row.get(i).setReal(0, this.m_objectIn.readFloat());
                    continue block16;
                }
                case 5: {
                    this.m_row.get(i).setSmallInt(0, this.m_objectIn.readShort());
                    continue block16;
                }
                case -6: {
                    this.m_row.get(i).setTinyInt(0, this.m_objectIn.readByte());
                    continue block16;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    long l;
                    long l2;
                    if (ColumnSizeCalculator.isLongData(this.m_metadata[i], this.m_longDataBorder)) {
                        l2 = this.m_objectIn.readLong();
                        l = this.m_objectIn.readLong();
                        this.m_row.get(i).setFileMarker(0, new TemporaryFile.FileMarker(l2, l));
                        continue block16;
                    }
                    this.m_row.get(i).setString(0, (String)this.m_objectIn.readObject());
                    continue block16;
                }
                case -4: 
                case -3: 
                case -2: {
                    long l;
                    long l2;
                    if (ColumnSizeCalculator.isLongData(this.m_metadata[i], this.m_longDataBorder)) {
                        l2 = this.m_objectIn.readLong();
                        l = this.m_objectIn.readLong();
                        this.m_row.get(i).setFileMarker(0, new TemporaryFile.FileMarker(l2, l));
                        continue block16;
                    }
                    this.m_row.get(i).setBytes(0, (byte[])this.m_objectIn.readObject());
                    continue block16;
                }
                case 2: 
                case 3: {
                    this.m_row.get(i).setExactNum(0, (BigDecimal)this.m_objectIn.readObject());
                    continue block16;
                }
                case -11: {
                    this.m_row.get(i).setGuid(0, (UUID)this.m_objectIn.readObject());
                    continue block16;
                }
                case 91: {
                    this.m_row.get(i).setDate(0, (Date)this.m_objectIn.readObject());
                    continue block16;
                }
                case 92: {
                    this.m_row.get(i).setTime(0, (Time)this.m_objectIn.readObject());
                    continue block16;
                }
                case 93: {
                    this.m_row.get(i).setTimestamp(0, (Timestamp)this.m_objectIn.readObject());
                    continue block16;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown data type: %d.", this.m_metadata[i].getTypeMetadata().getType()));
                }
            }
        }
    }
}

