/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.MachoFile;
import com.install4j.runtime.util.BinaryUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class FatMachoFile {
    public static final int FAT_MAGIC = -889275714;
    public static final int FAT_CIGAM = -1095041334;
    public static final int ALIGNMENT = 4096;
    private int magic;
    private int number;
    private FileChannel channel;
    private RandomAccessFile raFile;
    private List<Architecture> architectures = new ArrayList<Architecture>();

    public FatMachoFile(File file) throws IOException {
        this.raFile = new RandomAccessFile(file, "rw");
        this.magic = this.raFile.readInt();
        if (this.isFat()) {
            this.channel = this.raFile.getChannel();
            this.number = this.readInt();
            for (int i = 0; i < this.number; ++i) {
                Architecture architecture = new Architecture();
                this.architectures.add(architecture);
            }
        } else {
            this.raFile.close();
        }
    }

    private void writeInt(int v) throws IOException {
        this.raFile.writeInt(this.isBigEndian() ? v : BinaryUtil.swap(v));
    }

    private int readInt() throws IOException {
        int ret = this.raFile.readInt();
        return this.isBigEndian() ? ret : BinaryUtil.swap(ret);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
    }

    public void write() throws IOException {
        this.raFile.seek(0L);
        this.raFile.setLength(0L);
        this.raFile.writeInt(this.magic);
        this.writeInt(this.number);
        int offset = 4096;
        for (Architecture architecture : this.architectures) {
            offset = architecture.write(offset);
        }
        this.close();
    }

    public List<Architecture> getArchitectures() {
        return this.architectures;
    }

    public boolean isBigEndian() {
        return this.magic == -889275714;
    }

    public boolean isFat() {
        return FatMachoFile.isFatMagic(this.magic);
    }

    private static boolean isFatMagic(int magic) {
        return magic == -889275714 || magic == -1095041334;
    }

    public static boolean isAnyMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = FatMachoFile.isFatMagic(magic) || MachoFile.isThinMagic(magic);
                return bl;
            }
        }
        return false;
    }

    public class Architecture {
        private int cputype;
        private int cpusubtype;
        private int align;
        private ByteBuffer data;

        private Architecture() throws IOException {
            this.cputype = FatMachoFile.this.readInt();
            this.cpusubtype = FatMachoFile.this.readInt();
            int offset = FatMachoFile.this.readInt();
            int size = FatMachoFile.this.readInt();
            this.align = FatMachoFile.this.readInt();
            long pos = FatMachoFile.this.raFile.getFilePointer();
            FatMachoFile.this.raFile.seek(offset);
            this.data = ByteBuffer.allocate(size);
            BinaryUtil.readFully(FatMachoFile.this.channel, this.data);
            FatMachoFile.this.raFile.seek(pos);
        }

        public ByteBuffer getData() {
            return (ByteBuffer)this.data.duplicate().position(0);
        }

        public void setData(ByteBuffer data) {
            this.data = data;
        }

        private int write(int offset) throws IOException {
            FatMachoFile.this.writeInt(this.cputype);
            FatMachoFile.this.writeInt(this.cpusubtype);
            FatMachoFile.this.writeInt(offset);
            FatMachoFile.this.writeInt(this.data.limit());
            FatMachoFile.this.writeInt(this.align);
            long pos = FatMachoFile.this.raFile.getFilePointer();
            FatMachoFile.this.raFile.seek(offset);
            BinaryUtil.writeFully(FatMachoFile.this.channel, this.data);
            FatMachoFile.this.raFile.seek(pos);
            return (int)BinaryUtil.align(offset + this.data.limit(), 4096L);
        }
    }
}

