/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.console;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.UnattendedConsoleAccess;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.impl.HelperConsoleAccess;
import com.install4j.runtime.installer.helper.console.Console16Access;
import com.install4j.runtime.installer.helper.console.ConsoleAccess;
import com.install4j.runtime.installer.helper.console.SimpleConsoleAccess;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ConsoleImpl
implements Console {
    private static ConsoleImpl instance;
    private static final int HORIZONTAL_SIZE = 75;
    private static final int VERTICAL_SIZE = 25;
    private String lastStatusMessage;
    private String lastDetailMessage;
    private ConsoleAccess consoleAccess;
    private String lastVal;

    public static ConsoleImpl getInstance() {
        if (instance == null) {
            instance = new ConsoleImpl();
        }
        return instance;
    }

    public ConsoleImpl() {
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            this.consoleAccess = new HelperConsoleAccess();
        } else if (InstallerUtil.isUnattended()) {
            this.consoleAccess = new UnattendedConsoleAccess();
        } else {
            this.consoleAccess = System.console() != null ? new Console16Access() : new SimpleConsoleAccess();
            if (!Util.isWindows()) {
                this.consoleAccess.print("\u001b[?7h");
            }
        }
    }

    @Override
    public void waitForEnter() throws UserCanceledException {
        this.println("[" + this.getMessages().getString("ConsoleEnter") + "]");
        this.readLine();
    }

    @Override
    public void printHeader(String title) throws UserCanceledException {
        Application application = InstallerConfig.getCurrentApplication();
        try {
            ContextImpl.getSingleContextInt().runScript(application.getConsoleScreenChangeHandler(), application, this, title);
        }
        catch (UserCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void more(String text) throws UserCanceledException {
        if (text == null) {
            this.consoleAccess.println("null");
            this.consoleAccess.flush();
            return;
        }
        text = text.replaceAll("\u00a9", "(C)").replaceAll("\u00ae", "(R)").replaceAll("\u2022", "*").replace('\u2018', '\'').replace('\u2019', '\'').replace('\u201a', '\'').replace('\u201b', '\'').replace('\u201c', '\"').replace('\u201d', '\"').replace('\u201e', '\"').replace('\u201f', '\"');
        int lineCount = 0;
        boolean endedWithLineBreak = false;
        StringTokenizer lineTokenizer = new StringTokenizer(text, "\n\r", true);
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            if (line.length() == 1 && line.charAt(0) == '\n') {
                this.consoleAccess.println();
                endedWithLineBreak = true;
                if (++lineCount % 23 != 0) continue;
                this.waitForEnter();
                continue;
            }
            if (line.length() <= 1 && line.charAt(0) == '\r') continue;
            endedWithLineBreak = false;
            StringTokenizer wordTokenizer = new StringTokenizer(line, " ");
            int charCount = 0;
            while (wordTokenizer.hasMoreTokens()) {
                String word = wordTokenizer.nextToken();
                if (charCount == 0 || charCount + word.length() <= 75) {
                    if (charCount > 0) {
                        this.consoleAccess.print(" ");
                        ++charCount;
                    }
                } else {
                    this.consoleAccess.println();
                    charCount = 0;
                    if (++lineCount % 23 == 0) {
                        this.waitForEnter();
                    }
                }
                this.consoleAccess.print(word.replace('\u00a0', ' '));
                charCount += word.length();
            }
        }
        if (!endedWithLineBreak) {
            this.consoleAccess.println();
        }
    }

    @Override
    public void print(Object val) {
        this.print(val, false);
    }

    @Override
    public void println(Object val) {
        this.print(val, true);
    }

    private void print(Object val, boolean newLine) {
        String line = val == null ? "null" : val.toString().replace('\u00a0', ' ');
        if (this.lastVal != null && this.lastVal.startsWith("\r") && !line.startsWith("\r")) {
            this.consoleAccess.println();
        }
        if (newLine) {
            this.consoleAccess.println(line);
        } else {
            this.consoleAccess.print(line);
        }
        this.lastVal = line;
        this.consoleAccess.flush();
    }

    public void cleanup() {
        if (this.lastVal != null && this.lastVal.startsWith("\r")) {
            this.consoleAccess.println();
        }
    }

    public String askWithDefault(String message, String defaultValue) throws UserCanceledException {
        this.println(message);
        this.println("[" + defaultValue + "]");
        String answer = this.readLine();
        if (answer.trim().length() == 0) {
            return defaultValue;
        }
        return answer;
    }

    @Override
    public boolean askYesNo(String message) throws UserCanceledException {
        return this.askOption(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}) == 0;
    }

    @Override
    public boolean askYesNo(String message, boolean defaultValue) throws UserCanceledException {
        return this.askOption(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}, defaultValue ? 0 : 1) == 0;
    }

    @Override
    public boolean askOkCancel(String message) throws UserCanceledException {
        return this.askOption(message, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}) == 0;
    }

    @Override
    public boolean askOkCancel(String message, boolean defaultValue) throws UserCanceledException {
        return this.askOption(message, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}, defaultValue ? 0 : 1) == 0;
    }

    @Override
    public String askString(String message, String defaultValue) throws UserCanceledException {
        String answer;
        if (message != null && message.length() != 0) {
            this.println(message);
        }
        if (defaultValue != null) {
            this.println("[" + defaultValue + "]");
        }
        if ((answer = this.readLine()).trim().length() == 0 && defaultValue != null) {
            return defaultValue;
        }
        return answer;
    }

    @Override
    public String askPassword(String message, String defaultValue) throws UserCanceledException {
        String answer;
        if (message != null && message.length() != 0) {
            this.println(message);
        }
        if ((answer = this.consoleAccess.readPassword("")).trim().length() == 0 && defaultValue != null) {
            return defaultValue;
        }
        return answer;
    }

    @Override
    public int askOption(String message, String[] descriptions, String[] keys) throws UserCanceledException {
        return this.askOption(message, descriptions, keys, -1);
    }

    @Override
    public int askOption(String message, String[] descriptions, String[] keys, int defaultValue) throws UserCanceledException {
        return this.askOption(message, descriptions, keys, defaultValue, false, false);
    }

    @Override
    public int askOption(String message, String[] descriptions, String[] keys, int defaultValue, boolean allowNoSelection, boolean oneLinePerOption) throws UserCanceledException {
        if (keys == null) {
            keys = this.getDefaultKeys(descriptions.length);
        }
        String question = this.getQuestion(descriptions, keys, defaultValue, oneLinePerOption);
        while (true) {
            if (message != null && message.length() != 0) {
                this.println(message);
            }
            this.println(question);
            String answer = this.readLine().trim();
            for (int i = 0; i < descriptions.length; ++i) {
                if (!Objects.equals(keys[i], answer)) continue;
                return i;
            }
            if (answer.length() != 0) continue;
            if (defaultValue > -1) {
                return defaultValue;
            }
            if (allowNoSelection) break;
        }
        return -1;
    }

    private String getQuestion(String[] descriptions, String[] keys, int defaultValue, boolean oneLinePerOption) {
        StringBuilder question = new StringBuilder();
        for (int i = 0; i < descriptions.length; ++i) {
            question.append(descriptions[i]);
            question.append(" [");
            if (Objects.equals(keys[i], "")) {
                question.append(this.getMessages().getString("ConsoleEnter"));
            } else {
                question.append(keys[i]);
                if (defaultValue == i) {
                    question.append(", ");
                    question.append(this.getMessages().getString("ConsoleEnter"));
                }
            }
            question.append("]");
            if (i >= descriptions.length - 1) continue;
            if (oneLinePerOption) {
                question.append("\n");
                continue;
            }
            question.append(", ");
        }
        return question.toString();
    }

    @Override
    public int[] askMultipleSelection(String message, String[] descriptions, String[] keys, int[] defaultValues, boolean oneLinePerOption) throws UserCanceledException {
        HashSet<Integer> selectedItems;
        boolean allValid;
        if (keys == null) {
            keys = this.getDefaultKeys(descriptions.length);
        }
        StringBuilder defaultSelection = new StringBuilder();
        if (defaultValues != null) {
            for (int i = 0; i < defaultValues.length; ++i) {
                defaultSelection.append(keys[defaultValues[i]]);
                if (i >= defaultValues.length - 1) continue;
                defaultSelection.append(",");
            }
        }
        String question = this.getQuestion(descriptions, keys, -1, oneLinePerOption);
        question = question + "\n" + this.getMessages().getString("ConsoleMultipleSelectionLabel");
        block1: do {
            if (message != null && message.length() != 0) {
                this.println(message);
            }
            String answer = this.askString(question, defaultSelection.toString());
            allValid = true;
            selectedItems = new HashSet<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(answer, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken().trim();
                boolean found = false;
                for (int i = 0; i < keys.length; ++i) {
                    if (!Objects.equals(keys[i], token)) continue;
                    selectedItems.add(i);
                    found = true;
                    break;
                }
                if (found) continue;
                allValid = false;
                continue block1;
            }
        } while (!allValid);
        int[] ret = new int[selectedItems.size()];
        int i = 0;
        for (Integer selectedItem : selectedItems) {
            ret[i++] = selectedItem;
        }
        return ret;
    }

    private String[] getDefaultKeys(int length) {
        String[] keys = new String[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = String.valueOf(i + 1);
        }
        return keys;
    }

    @Override
    public void setStatusMessage(String message) {
        if (message != null && !Objects.equals(message.trim(), "") && !Objects.equals(message, this.lastStatusMessage)) {
            this.println(StringUtil.formatTextWithoutHtmlTags(message));
            this.lastStatusMessage = message;
        }
    }

    @Override
    public void setDetailMessage(String message) {
        if (message != null && (message.trim().length() > 0 || this.lastDetailMessage != null && this.lastDetailMessage.trim().length() > 0)) {
            this.print(StringUtil.padRight("\r  " + message, ' ', 76));
            this.lastDetailMessage = message;
        }
    }

    @Override
    public void setPercentCompleted(int value) {
    }

    @Override
    public int getPercentCompleted() {
        return 0;
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {
        if (this.lastDetailMessage != null && this.lastDetailMessage.trim().length() > 0) {
            this.printProgressMessage(value, this.lastDetailMessage);
        } else if (this.lastStatusMessage != null && this.lastStatusMessage.trim().length() > 0) {
            this.printProgressMessage(value, this.lastStatusMessage);
        }
    }

    private void printProgressMessage(int value, String message) {
        this.print(StringUtil.padRight("\r  " + message + " (" + value + " %)", ' ', 76));
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
    }

    @Override
    public void showFailure(String message) {
        this.println("ERROR: " + message);
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        String message = file.getPath() + "\n\n" + this.getMessages().getString("FileExists");
        int result = this.askOption(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonYesToAll"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonNoToAll")}, new String[]{"y", "ya", "n", "na"});
        switch (result) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        String message = Messages.format(this.getMessages().getString("AskRetryInstallFile"), file.getPath());
        if (ConsoleImpl.isRetryAllowNo()) {
            int result = this.askOption(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonCancel")}, new String[]{"y", "n", "c"});
            switch (result) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
        } else {
            int result = this.askOption(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonCancel")}, new String[]{"y", "c"});
            switch (result) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return 3;
    }

    public static boolean isRetryAllowNo() {
        Context currentContext = ContextImpl.getCurrentContext();
        return currentContext != null && currentContext.getBooleanVariable("sys.fileRetryAllowNo");
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        int result = this.askOption(Messages.format(this.getMessages().getString("AskContinue"), file.getPath()), new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"", "c"});
        return result == 0;
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }

    public void printStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        this.consoleAccess.print(stringWriter.toString());
        this.consoleAccess.flush();
    }

    public synchronized void cancel() {
        this.consoleAccess.cancel();
    }

    @Override
    public String readLine() throws UserCanceledException {
        return this.consoleAccess.readLine("");
    }

    public ConsoleAccess getConsoleAccess() {
        return this.consoleAccess;
    }
}

