/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.ejt.framework.CommonApplicationServices;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.ActionList;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.actions.FailureStrategy;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.groups.ActionGroup;
import com.install4j.runtime.beans.screens.BackButtonType;
import com.install4j.runtime.beans.screens.StartupScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ActionCallbackCommand;
import com.install4j.runtime.installer.controller.CheckingScreenChangeCommand;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.ExecuteActionListCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.Install4jRuntimeApplicationServices;
import com.install4j.runtime.installer.controller.LanguageSelector;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.controller.ScreenNavigator;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.LoggerImpl;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import com.install4j.runtime.installer.platform.win32.Win32Handle;
import com.install4j.runtime.launcher.integration.LockFile;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Controller {
    private static final int MSI_INSUFFICIENT_RIGHTS_EXIT_CODE = 25;
    private ScreenExecutor screenExecutor;
    private ContextImpl context;
    private List<ActionBeanConfig> startedActionsConfigs = new ArrayList<ActionBeanConfig>();
    private Map<ActionList, List<ActionBeanConfig>> startedActionListActions = new HashMap<ActionList, List<ActionBeanConfig>>();
    private int rollbackBarrierExitCode = 1;
    private ScreenNavigator screenNavigator;
    private boolean executingActions;

    public Controller(ScreenExecutor screenExecutor) {
        this.screenExecutor = screenExecutor;
        this.context = screenExecutor.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (MsiHelper.isStartedFromMsi() && this.screenExecutor.isUnattended() && MsiHelper.isMsiAllUsers(this.context) && !Util.hasFullAdminRights()) {
            System.exit(25);
        }
        LanguageSelector.initSystemAndDefaultLanguage();
        CommonApplicationServices.setInstance(new Install4jRuntimeApplicationServices());
        InstallerVariables.initUserVars();
        InstallerUtil.registerStarted(false);
        InstallerVariables.setReplaceI18nVariables(true);
        InstallerVariables.setReplaceInstallerAndCompilerVariables(true);
        LoggerImpl.getImpl().checkAlternativeLogfile();
        InstallerUtil.setConsole(this.screenExecutor.isConsole());
        InstallerUtil.setUnattended(this.screenExecutor.isUnattended());
        if (InstallerVariables.getBooleanVariable("sys.automaticUpdate")) {
            LockFile.waitForLockFile();
        }
        LanguageSelector.initLanguage(this.context, this.screenExecutor);
        if (!this.context.checkStart()) {
            this.context.exit(1);
        }
        if (MsiCommunication.connect()) {
            Logger.getInstance().info(null, "connected to MSI installer");
        }
        try {
            ((Runnable)Install4jClassLoader.getInstance().loadClass("AfterLafSet").newInstance()).run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Util.isWindows() && InstallerConfig.isInstaller()) {
            Win32Handle.closeInheritedModulesHandle(Logger.LAUNCHER_LOGGER);
        }
        this.context.registerScreens();
        if (this.getScreenConfigsFlat().size() == 0) {
            return;
        }
        this.screenNavigator = new ScreenNavigator(this.context);
        ScreenBeanConfig screenConfig = this.handleStartup();
        if (screenConfig == null && InstallerUtil.isInProcess()) {
            return;
        }
        ControllerCommand lastCommand = null;
        while (screenConfig != null) {
            CommandSink commandSink = new CommandSink(this);
            this.execute(screenConfig, commandSink, lastCommand);
            CommandSink commandSink2 = commandSink;
            synchronized (commandSink2) {
                while (commandSink.getCommand() == null) {
                    try {
                        commandSink.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            lastCommand = commandSink.getCommand();
            screenConfig = this.handleCommand(commandSink, screenConfig);
            if (commandSink.isFinished()) {
                return;
            }
            if (screenConfig == null) {
                Logger.getImpl().setCurrentScreen(null);
                commandSink.finished();
                continue;
            }
            Logger.getImpl().setCurrentScreen(screenConfig.getOrInstantiateScreen(false));
        }
        this.context.immediateExit(0);
    }

    private ScreenBeanConfig handleStartup() {
        ScreenBeanConfig startupScreenConfig = this.getScreenConfigsFlat().get(0);
        CommandSink commandSink = new CommandSink(this);
        commandSink.returnToController(new GoForwardCommand(1, true, true, null));
        this.screenExecutor.setCommandSink(commandSink);
        return this.handleCommand(commandSink, startupScreenConfig);
    }

    private void execute(final ScreenBeanConfig screenConfig, final CommandSink commandSink, final ControllerCommand lastCommand) {
        ArrayList<AbstractBeanConfig> hiddenForPreviousActionConfigs;
        ScreenBeanConfig previousScreenConfig;
        if (lastCommand == null || lastCommand.isAddHistoryEntry()) {
            this.screenNavigator.addHistory(screenConfig);
        }
        final boolean previousPossible = (previousScreenConfig = this.screenNavigator.findPreviousScreenConfigInHistory(false, hiddenForPreviousActionConfigs = new ArrayList<AbstractBeanConfig>(), 1)) != null && screenConfig.getBackButtonType() != BackButtonType.HIDDEN && (screenConfig.getBackButtonType() != BackButtonType.SAFE || !this.hasNonMultiExecActions(previousScreenConfig.getActionConfigs()) && !this.hasNonMultiExecActions(hiddenForPreviousActionConfigs));
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        this.context.fireInstallerEvent(new InstallerEvent(screen, this.context, EventType.SHOW_SCREEN));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.screenExecutor.execute(screenConfig, commandSink, previousPossible, lastCommand);
            }
        });
    }

    private boolean hasNonMultiExecActions(List<AbstractBeanConfig> actionConfigs) {
        for (AbstractBeanConfig beanConfig : actionConfigs) {
            if (!(beanConfig instanceof GroupBeanConfig ? this.hasNonMultiExecActions(((GroupBeanConfig)beanConfig).getBeanConfigs()) : beanConfig instanceof ActionBeanConfig && !((ActionBeanConfig)beanConfig).isMultiExec())) continue;
            return true;
        }
        return false;
    }

    private ScreenBeanConfig handleCommand(CommandSink commandSink, ScreenBeanConfig currentScreenConfig) {
        Logger.getImpl().resetOrigin();
        ControllerCommand command = commandSink.getCommand();
        ActionCallback actionCallback = null;
        try {
            Screen targetScreen;
            ScreenBeanConfig screenConfig;
            ScreenBeanConfig nextScreenConfig;
            ScreenBeanConfig screenBeanConfig;
            if (command instanceof ExecuteActionListCommand) {
                ExecuteActionListCommand executeActionListCommand = (ExecuteActionListCommand)command;
                ActionList actionList = executeActionListCommand.getActionList();
                actionCallback = ((ActionCallbackCommand)command).getActionCallback();
                commandSink.allowOverride();
                if (actionCallback != null) {
                    actionCallback.actionsStarted();
                }
                try {
                    this.executeActionList(actionList, executeActionListCommand.getExtraScriptParameters());
                }
                catch (UserCanceledException userCanceledException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (command == commandSink.getOverriddenCommand()) {
                    screenBeanConfig = currentScreenConfig;
                    return screenBeanConfig;
                }
                command = commandSink.getOverriddenCommand();
            } else if (command instanceof CheckingScreenChangeCommand && ((CheckingScreenChangeCommand)command).isExecuteActions() || command instanceof FinishCommand) {
                actionCallback = ((ActionCallbackCommand)command).getActionCallback();
                commandSink.allowOverride();
                if (actionCallback != null) {
                    actionCallback.actionsStarted();
                }
                try {
                    this.executeActions(currentScreenConfig.getActionConfigs(), "", false, this.startedActionsConfigs);
                    this.checkRollbackBarrier(currentScreenConfig, currentScreenConfig.getOrInstantiateScreen(false));
                }
                catch (ReturnToScreenException e) {
                    if (!(currentScreenConfig.getOrInstantiateScreen(false) instanceof StartupScreen)) {
                        this.context.goBackInHistory(0);
                    }
                }
                catch (UserCanceledException e) {
                    this.rollback(commandSink);
                    ScreenBeanConfig actionList = null;
                    if (actionCallback != null) {
                        actionCallback.actionsFinished();
                    }
                    return actionList;
                }
                command = commandSink.getOverriddenCommand();
            }
            Logger.getInstance().info(currentScreenConfig.getOrInstantiateScreen(false), "command: " + command);
            if (command instanceof GoForwardCommand) {
                GoForwardCommand goForwardCommand = (GoForwardCommand)command;
                nextScreenConfig = this.screenNavigator.findNextScreenConfig(currentScreenConfig, goForwardCommand.getNumber(), goForwardCommand.isCheckCondition());
                if (nextScreenConfig == null) {
                    this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                    commandSink.finished();
                    this.context.finish(0);
                }
                screenBeanConfig = nextScreenConfig;
                return screenBeanConfig;
            }
            if (command instanceof GoBackCommand) {
                GoBackCommand goBackCommand = (GoBackCommand)command;
                if (goBackCommand.isUseHistory()) {
                    this.screenNavigator.removeLastHistoryItem();
                    if (goBackCommand.getNumber() == 0) {
                        nextScreenConfig = currentScreenConfig;
                        return nextScreenConfig;
                    }
                    screenConfig = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, goBackCommand.getNumber());
                    if (screenConfig == null) {
                        throw new RuntimeException("Could not go back " + goBackCommand.getNumber() + " step in history from " + currentScreenConfig.getOrInstantiateScreen(true));
                    }
                    screenBeanConfig = screenConfig;
                    return screenBeanConfig;
                }
                screenConfig = this.screenNavigator.findPreviousScreenConfig(currentScreenConfig, goBackCommand.getNumber());
                return screenConfig;
            }
            if (command instanceof GoBackInHistoryToScreenCommand) {
                targetScreen = ((GoBackInHistoryToScreenCommand)command).getScreen();
                this.screenNavigator.removeLastHistoryItem();
                if (targetScreen == currentScreenConfig.getOrInstantiateScreen(false)) {
                    screenConfig = currentScreenConfig;
                    return screenConfig;
                }
                do {
                    if ((screenConfig = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, 1)) != null) continue;
                    throw new RuntimeException("Could not go back in history to screen " + targetScreen.toString());
                } while (screenConfig.getOrInstantiateScreen(false) != targetScreen);
                screenBeanConfig = screenConfig;
                return screenBeanConfig;
            }
            if (command instanceof FinishCommand) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                commandSink.finished();
                this.context.finish(0);
                targetScreen = null;
                return targetScreen;
            }
            if (command == ControllerCommand.CANCEL) {
                this.rollback(commandSink);
                targetScreen = null;
                return targetScreen;
            }
            if (command instanceof GotoScreenCommand) {
                GotoScreenCommand gotoScreenCommand = (GotoScreenCommand)command;
                screenConfig = this.findScreenConfig(gotoScreenCommand.getScreen());
                if (gotoScreenCommand.isCheckCondition() && !this.screenNavigator.shouldBeShown(screenConfig)) {
                    screenConfig = this.screenNavigator.findNextScreenConfig(screenConfig, 1, true);
                }
                this.screenNavigator.sync(screenConfig);
                screenBeanConfig = screenConfig;
                return screenBeanConfig;
            }
            throw new RuntimeException("Unknown command " + command.toString());
        }
        finally {
            if (actionCallback != null) {
                actionCallback.actionsFinished();
            }
        }
    }

    public void rollback(CommandSink commandSink) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELLING));
        Application currentApplication = InstallerConfig.getCurrentApplication();
        if (currentApplication != null && currentApplication.isRollback()) {
            FileInstaller fileInstaller = FileInstaller.getInstance();
            boolean rollbackFiles = fileInstaller.hasRollbackFiles();
            if (this.startedActionsConfigs.size() > 0 || rollbackFiles) {
                ServiceHandler.resetStopState();
                this.context.setRollback();
                this.context.getProgressInterface().setDetailMessage("");
                if (rollbackFiles) {
                    ServiceHandler.stopServices(this.context, true);
                }
                this.context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
                this.rollbackActions(this.startedActionsConfigs);
                if (rollbackFiles) {
                    fileInstaller.rollbackAll();
                }
            }
            if (fileInstaller.hasUnrollbackedFiles()) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
                commandSink.finished();
                this.context.finish(1);
            }
        }
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
        commandSink.finished();
        this.context.exit(this.rollbackBarrierExitCode);
    }

    private void rollbackActions(List<ActionBeanConfig> rollbackList) {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        boolean rollbackFiles = fileInstaller.hasRollbackFiles();
        for (int i = rollbackList.size() - 1; i >= 0; --i) {
            Logger.getImpl().resetOrigin();
            ActionBeanConfig actionBeanConfig = rollbackList.get(i);
            if (actionBeanConfig.isRolledBack()) continue;
            if (rollbackFiles) {
                fileInstaller.rollback(actionBeanConfig.getRollbackId());
            }
            this.context.rollbackAction(actionBeanConfig);
            actionBeanConfig.setRolledBack(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeActions(List<AbstractBeanConfig> actionConfigs, String defaultMessage, boolean parentBreakGroup, List<ActionBeanConfig> rollbackList) throws UserCanceledException {
        boolean oldExecutingActions = this.executingActions;
        this.executingActions = true;
        try {
            for (AbstractBeanConfig beanConfig : actionConfigs) {
                Logger.getImpl().resetOrigin();
                if (beanConfig instanceof ActionBeanConfig) {
                    if (this.executeAction((ActionBeanConfig)beanConfig, defaultMessage, parentBreakGroup, rollbackList)) continue;
                    boolean bl = false;
                    return bl;
                }
                GroupBeanConfig groupBeanConfig = (GroupBeanConfig)beanConfig;
                if (this.executeActionGroup(groupBeanConfig, defaultMessage, parentBreakGroup)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.executingActions = oldExecutingActions;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAction(ActionBeanConfig actionBeanConfig, String defaultMessage, boolean parentBreakGroup, List<ActionBeanConfig> rollbackList) throws UserCanceledException {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        boolean repeat = false;
        do {
            if (this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            if (!repeat && (!actionBeanConfig.isMultiExec() && actionBeanConfig.isExecuted() || !this.context.runBooleanScript(actionBeanConfig.getConditionClassName(), action, new Object[0]))) continue;
            if (!(actionBeanConfig.isExecuted() || action instanceof InstallAction && !this.isRollbackSupported(action))) {
                rollbackList.add(actionBeanConfig);
            }
            actionBeanConfig.setExecuted(true);
            try {
                Logger.getImpl().setCurrentAction(actionBeanConfig.getOrInstantiateAction(false));
                if (!this.context.performAction(actionBeanConfig)) {
                    repeat = this.handleFailure(actionBeanConfig, action.getClass(), defaultMessage);
                    if (repeat || !parentBreakGroup) continue;
                    boolean bl = false;
                    return bl;
                }
                repeat = false;
            }
            catch (UndefinedVariableException e) {
                Logger.getInstance().error(action, "undefined variable: " + e.getMessage());
                repeat = this.handleFailure(actionBeanConfig, action.getClass(), defaultMessage);
                if (repeat || !parentBreakGroup) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                this.checkRollbackBarrier(actionBeanConfig, action);
                Logger.getImpl().setCurrentAction(null);
            }
        } while (repeat);
        return true;
    }

    private boolean executeActionGroup(GroupBeanConfig groupBeanConfig, String defaultMessage, boolean parentBreakGroup) throws UserCanceledException {
        if (this.context.checkGroupCondition(groupBeanConfig)) {
            boolean forcedRepeat;
            ActionGroup actionGroup = (ActionGroup)groupBeanConfig.getOrInstantiateGroup(false);
            ContextImpl.GroupState groupState = new ContextImpl.GroupState();
            this.context.initLoopIndex(groupBeanConfig, groupState);
            do {
                forcedRepeat = false;
                String newDefaultMessage = actionGroup.getDefaultErrorMessage().trim();
                if (newDefaultMessage.length() == 0) {
                    newDefaultMessage = defaultMessage;
                }
                boolean breakGroup = actionGroup.isOnErrorBreakGroup();
                if (this.executeActions(groupBeanConfig.getBeanConfigs(), newDefaultMessage, breakGroup, this.startedActionsConfigs)) continue;
                if (breakGroup) {
                    if (this.context.runBooleanScript(actionGroup.getRetryExpression(), actionGroup) || this.handleFailure(actionGroup.getFailureStrategy(), actionGroup.getErrorMessage(), "Action group")) {
                        forcedRepeat = true;
                        continue;
                    }
                    if (!parentBreakGroup) continue;
                    return false;
                }
                if (!parentBreakGroup) continue;
                return false;
            } while (forcedRepeat || this.context.isGroupLoop(groupBeanConfig, groupState));
        }
        return true;
    }

    private boolean isRollbackSupported(Action action) {
        try {
            return ((InstallAction)action).isRollbackSupported();
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    private boolean handleFailure(ActionBeanConfig actionBeanConfig, Class actionClass, String defaultMessage) throws UserCanceledException {
        String errorMessage = actionBeanConfig.getErrorMessage().trim();
        if (errorMessage.length() == 0) {
            errorMessage = defaultMessage.trim();
        }
        return this.handleFailure(actionBeanConfig.getFailureStrategy(), errorMessage, actionClass.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleFailure(FailureStrategy failureStrategy, String errorMessage, String origin) throws UserCanceledException {
        boolean strategyReturnToScreen;
        this.context.setErrorOccurred(true);
        boolean strategyQuit = failureStrategy == FailureStrategy.QUIT;
        boolean bl = strategyReturnToScreen = failureStrategy == FailureStrategy.RETURN_TO_SCREEN;
        if (strategyReturnToScreen && InstallerUtil.isUnattended()) {
            strategyReturnToScreen = false;
            strategyQuit = true;
        }
        if (strategyQuit || strategyReturnToScreen || failureStrategy == FailureStrategy.CONTINUE) {
            if (errorMessage.length() > 0) {
                Util.showMessage(Controller.getPrefixedMessage(this.context, errorMessage), strategyQuit ? 0 : 2);
            }
            if (strategyQuit) {
                this.quitAndKeepLogFile();
                return false;
            }
            if (!strategyReturnToScreen) return false;
            throw new ReturnToScreenException();
        }
        if (this.context.isUnattended() && this.context.getBooleanVariable("sys.actionFailureUnattendedQuit")) {
            Util.showErrorMessage(errorMessage);
            this.quitAndKeepLogFile();
            return false;
        }
        VariableResourceBundleWrapper messages = Messages.getMessages();
        if (errorMessage.length() == 0) {
            errorMessage = Messages.format(messages.getString("ErrorFunctionFailedNoCode"), origin) + "\n";
        }
        errorMessage = Controller.getPrefixedMessage(this.context, errorMessage);
        if (failureStrategy == FailureStrategy.ASK_USER) {
            if (Util.showOptionDialog(errorMessage, new String[]{messages.getString("ButtonIgnore"), messages.getString("ButtonQuit")}, 0) != 1) return false;
            this.quitAndKeepLogFile();
            return false;
        }
        if (this.context.getBooleanVariable("sys.actionRetryDisableIgnore")) {
            int result = Util.showOptionDialog(errorMessage, new String[]{messages.getString("ButtonRetry"), messages.getString("ButtonQuit")}, 0);
            if (result != 1) return true;
            this.quitAndKeepLogFile();
            return false;
        }
        int result = Util.showOptionDialog(errorMessage, new String[]{messages.getString("ButtonIgnore"), messages.getString("ButtonRetry"), messages.getString("ButtonQuit")}, 0);
        if (result == 2) {
            this.quitAndKeepLogFile();
            return false;
        }
        if (result != 1) return false;
        return true;
    }

    private static String getPrefixedMessage(ContextImpl context, String errorMessage) {
        String prefix = (String)context.getVariable("sys.actionErrorMessagePrefix");
        if (prefix != null) {
            return prefix + errorMessage;
        }
        return errorMessage;
    }

    private void quitAndKeepLogFile() throws UserCanceledException {
        System.setProperty("install4j.keepLog", "true");
        throw new UserCanceledException();
    }

    private void checkRollbackBarrier(AbstractBeanConfig beanConfig, Bean source) {
        if (beanConfig.isRollbackBarrier()) {
            this.startedActionsConfigs.clear();
            this.startedActionListActions.clear();
            this.rollbackBarrierExitCode = beanConfig.getRollbackBarrierExitCode();
            FileInstaller.getInstance().setRollbackBarrier();
            Logger.getInstance().info(source, "Rollback barrier reached");
        }
    }

    private ScreenBeanConfig findScreenConfig(Screen screen) {
        for (ScreenBeanConfig screenConfig : this.getScreenConfigsFlat()) {
            if (screenConfig.getOrInstantiateScreen(false) != screen) continue;
            return screenConfig;
        }
        throw new RuntimeException("not in screen sequence; " + screen);
    }

    private List<ScreenBeanConfig> getScreenConfigsFlat() {
        return this.context.getScreenConfigsFlat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeActionList(ActionList actionList, Object ... extraScriptParameters) throws UserCanceledException {
        if (actionList == null) {
            throw new IllegalArgumentException("action list parameter must not be null");
        }
        List<AbstractBeanConfig> actionConfigs = AbstractBeanConfig.getActionListBeans(actionList.getId());
        if (actionConfigs == null) {
            throw new IllegalStateException("action list with ID " + actionList.getId() + " was not found");
        }
        ArrayList<ActionBeanConfig> rollbackList = new ArrayList<ActionBeanConfig>();
        this.startedActionListActions.put(actionList, rollbackList);
        Object[] oldExtraScriptParameters = this.context.getExtraScriptParameters();
        this.context.setExtraScriptParameters(extraScriptParameters);
        try {
            boolean bl = this.executeActions(actionConfigs, "", actionList.isBreakOnError(), rollbackList);
            return bl;
        }
        finally {
            this.context.setExtraScriptParameters(oldExtraScriptParameters);
        }
    }

    public void rollbackActionList(ActionList actionList) {
        List<ActionBeanConfig> rollbackList;
        if (InstallerConfig.getCurrentApplication().isRollback() && (rollbackList = this.startedActionListActions.get(actionList)) != null) {
            this.rollbackActions(rollbackList);
        }
    }

    public boolean isExecutingActions() {
        return this.executingActions;
    }

    private class ReturnToScreenException
    extends RuntimeException {
        private ReturnToScreenException() {
        }
    }
}

