/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnFactory;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.event.ExpressionListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionAnalyzer;
import java.util.BitSet;
import java.util.Set;

public class ExpressionColumn
extends AbstractColumn {
    private Expression \u0111;
    private Table \u010d;
    private Set \u010e;
    private BitSet \u010c;
    private Column \u0110;
    private A \u010f;

    public ExpressionColumn(Table table, Expression expression) {
        super(expression.getType(table.getSchema()));
        this.\u010d = table;
        this.\u0111 = expression;
        this.\u010f = new A();
        this.init();
        int n2 = this.\u010d.getRowCount();
        this.\u0110 = ColumnFactory.getColumn(this.getColumnType(), n2);
        this.\u010c = new BitSet(n2);
        this.\u0111.addExpressionListener(this.\u010f);
    }

    protected void init() {
        Column column;
        if (this.\u010e != null && this.\u010e.size() > 0) {
            for (String string : this.\u010e) {
                column = this.\u010d.getColumn(string);
                column.removeColumnListener(this.\u010f);
            }
        }
        this.\u010e = ExpressionAnalyzer.getReferencedColumns(this.\u0111);
        for (String string : this.\u010e) {
            if (this.\u010d.getColumn(string) != null) continue;
            throw new IllegalArgumentException("Table must contain all columns referenced by the expression. Bad column name: " + string);
        }
        for (String string : this.\u010e) {
            column = this.\u010d.getColumn(string);
            column.addColumnListener(this.\u010f);
        }
    }

    @Override
    public int getRowCount() {
        return this.\u0110.getRowCount();
    }

    @Override
    public void setMaximumRow(int n2) {
        this.\u0110.setMaximumRow(n2);
    }

    public boolean isCacheValid(int n2) {
        return this.\u010c.get(n2);
    }

    public void invalidateCache(int n2, int n3) {
        this.\u010c.clear(n2, n3 + 1);
    }

    @Override
    public void revertToDefault(int n2) {
    }

    @Override
    public boolean canSet(Class clazz) {
        return false;
    }

    @Override
    public Object get(int n2) {
        Class clazz;
        this.\u0102(n2);
        if (this.isCacheValid(n2)) {
            return this.\u0110.get(n2);
        }
        Object object = this.\u0111.get(this.\u010d.getTuple(n2));
        Class clazz2 = clazz = object == null ? Object.class : object.getClass();
        if (this.\u0110.canSet(clazz)) {
            this.\u0110.set(object, n2);
            this.\u010c.set(n2);
        }
        return object;
    }

    @Override
    public void set(Object object, int n2) throws DataTypeException {
        throw new UnsupportedOperationException();
    }

    private void \u0102(int n2) {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean getBoolean(int n2) throws DataTypeException {
        if (!this.canGetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.\u0102(n2);
        if (this.isCacheValid(n2)) {
            return this.\u0110.getBoolean(n2);
        }
        boolean bl = this.\u0111.getBoolean(this.\u010d.getTuple(n2));
        this.\u0110.setBoolean(bl, n2);
        this.\u010c.set(n2);
        return bl;
    }

    private void \u0101(int n2) {
        if (this.m_columnType == Integer.TYPE) {
            this.\u0110.setInt(this.\u0111.getInt(this.\u010d.getTuple(n2)), n2);
        } else if (this.m_columnType == Long.TYPE) {
            this.\u0110.setLong(this.\u0111.getLong(this.\u010d.getTuple(n2)), n2);
        } else if (this.m_columnType == Float.TYPE) {
            this.\u0110.setFloat(this.\u0111.getFloat(this.\u010d.getTuple(n2)), n2);
        } else {
            this.\u0110.setDouble(this.\u0111.getDouble(this.\u010d.getTuple(n2)), n2);
        }
        this.\u010c.set(n2);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        if (!this.canGetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.\u0102(n2);
        if (!this.isCacheValid(n2)) {
            this.\u0101(n2);
        }
        return this.\u0110.getInt(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        if (!this.canGetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.\u0102(n2);
        if (!this.isCacheValid(n2)) {
            this.\u0101(n2);
        }
        return this.\u0110.getDouble(n2);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (!this.canGetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.\u0102(n2);
        if (!this.isCacheValid(n2)) {
            this.\u0101(n2);
        }
        return this.\u0110.getFloat(n2);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        if (!this.canGetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.\u0102(n2);
        if (!this.isCacheValid(n2)) {
            this.\u0101(n2);
        }
        return this.\u0110.getLong(n2);
    }

    private class A
    implements ColumnListener,
    ExpressionListener {
        private A() {
        }

        public void \u0101(int n2, int n3) {
            if (n2 == n3 && ExpressionColumn.this.isCacheValid(n2)) {
                if (!ExpressionColumn.this.\u010d.isValidRow(n2)) {
                    return;
                }
                ExpressionColumn.this.invalidateCache(n2, n3);
                Class clazz = ExpressionColumn.this.getColumnType();
                if (Integer.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.getInt(n2));
                } else if (Long.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.getLong(n2));
                } else if (Float.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.getFloat(n2));
                } else if (Double.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.getDouble(n2));
                } else if (Boolean.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.getBoolean(n2));
                } else {
                    ExpressionColumn.this.fireColumnEvent(n2, ExpressionColumn.this.\u0110.get(n2));
                }
            } else {
                ExpressionColumn.this.invalidateCache(n2, n3);
                ExpressionColumn.this.fireColumnEvent(0, n2, n3);
            }
        }

        @Override
        public void columnChanged(Column column, int n2, boolean bl) {
            this.\u0101(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, double d2) {
            this.\u0101(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, float f2) {
            this.\u0101(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, int n3, int n4) {
            this.\u0101(n3, n4);
        }

        @Override
        public void columnChanged(Column column, int n2, int n3) {
            this.\u0101(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, long l2) {
            this.\u0101(n2, n2);
        }

        @Override
        public void columnChanged(Column column, int n2, Object object) {
            this.\u0101(n2, n2);
        }

        @Override
        public void expressionChanged(Expression expression) {
            this.\u0101(0, ExpressionColumn.this.\u0110.getRowCount());
            ExpressionColumn.this.init();
        }
    }
}

