/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnFactory;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnMetadata;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.event.TableListener;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ExpressionParser;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ParseException;
import com.jidesoft.thirdparty.prefuse.data.tuple.AbstractTupleSet;
import com.jidesoft.thirdparty.prefuse.data.tuple.TableTuple;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleManager;
import com.jidesoft.thirdparty.prefuse.data.util.FilterIteratorFactory;
import com.jidesoft.thirdparty.prefuse.data.util.Index;
import com.jidesoft.thirdparty.prefuse.data.util.RowManager;
import com.jidesoft.thirdparty.prefuse.data.util.TableIterator;
import com.jidesoft.thirdparty.prefuse.data.util.TreeIndex;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;
import com.jidesoft.thirdparty.prefuse.util.collections.IncompatibleComparatorException;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class Table
extends AbstractTupleSet
implements ColumnListener {
    protected CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected ArrayList m_columns;
    protected ArrayList m_names;
    protected HashMap m_entries;
    protected RowManager m_rows;
    protected TupleManager m_tuples;
    protected int m_modCount = 0;
    protected int m_lastCol = -1;
    protected Schema m_schema;

    public Table() {
        this(0, 0);
    }

    public Table(int n2, int n3) {
        this(n2, n3, TableTuple.class);
    }

    protected Table(int n2, int n3, Class clazz) {
        this.m_columns = new ArrayList(n3);
        this.m_names = new ArrayList(n3);
        this.m_rows = new RowManager(this);
        this.m_entries = new HashMap(n3 + 5);
        this.m_tuples = new TupleManager(this, clazz);
        if (n2 > 0) {
            this.addRows(n2);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public Class getColumnType(int n2) {
        return this.getColumn(n2).getColumnType();
    }

    public Class getColumnType(String string) {
        Column column = this.getColumn(string);
        return column == null ? null : column.getColumnType();
    }

    public int getRowCount() {
        return this.m_rows.getRowCount();
    }

    public int getMinimumRow() {
        return this.m_rows.getMinimumRow();
    }

    public int getMaximumRow() {
        return this.m_rows.getMaximumRow();
    }

    public boolean isCellEditable(int n2, int n3) {
        if (!this.m_rows.isValidRow(n2)) {
            return false;
        }
        return this.getColumn(n3).isCellEditable(n2);
    }

    public int getModificationCount() {
        return this.m_modCount;
    }

    public void setTupleManager(TupleManager tupleManager) {
        this.m_tuples.invalidateAll();
        this.m_tuples = tupleManager;
    }

    public Schema getSchema() {
        if (this.m_schema == null) {
            Schema schema = new Schema();
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                schema.addColumn(this.getColumnName(i2), this.getColumnType(i2), this.getColumn(i2).getDefaultValue());
            }
            schema.lockSchema();
            this.m_schema = schema;
        }
        return this.m_schema;
    }

    protected void invalidateSchema() {
        this.m_schema = null;
    }

    public int getColumnRow(int n2, int n3) {
        return this.m_rows.getColumnRow(n2, n3);
    }

    public int getTableRow(int n2, int n3) {
        return this.m_rows.getTableRow(n2, n3);
    }

    public int addRow() {
        int n2 = this.m_rows.addRow();
        this.updateRowCount();
        this.fireTableEvent(n2, n2, -1, 1);
        return n2;
    }

    public void addRows(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addRow();
        }
    }

    protected void updateRowCount() {
        int n2 = this.m_rows.getMaximumRow() + 1;
        Iterator iterator = this.getColumns();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            column.setMaximumRow(n2);
        }
    }

    public boolean removeRow(int n2) {
        if (this.m_rows.isValidRow(n2)) {
            this.fireTableEvent(n2, n2, -1, -1);
            this.m_tuples.invalidate(n2);
            this.m_rows.releaseRow(n2);
            Iterator iterator = this.getColumns();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                column.revertToDefault(n2);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        IntIterator intIterator = this.rows(true);
        while (intIterator.hasNext()) {
            this.removeRow(intIterator.nextInt());
        }
    }

    public boolean isValidRow(int n2) {
        return this.m_rows.isValidRow(n2);
    }

    protected boolean hasColumn(String string) {
        return this.getColumnNumber(string) != -1;
    }

    public String getColumnName(int n2) {
        return (String)this.m_names.get(n2);
    }

    public int getColumnNumber(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry == null ? -1 : columnEntry.colnum;
    }

    public int getColumnNumber(Column column) {
        return this.m_columns.indexOf(column);
    }

    public Column getColumn(int n2) {
        this.m_lastCol = n2;
        return (Column)this.m_columns.get(n2);
    }

    public Column getColumn(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry != null ? columnEntry.column : null;
    }

    @Override
    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    @Override
    public void addColumn(String string, Class clazz, Object object) {
        Column column = ColumnFactory.getColumn(clazz, this.m_rows.getMaximumRow() + 1, object);
        this.addColumn(string, column);
    }

    @Override
    public void addColumn(String string, String string2) {
        try {
            Expression expression = ExpressionParser.parse(string2);
            Throwable throwable = ExpressionParser.getError();
            if (throwable != null) {
                throw new RuntimeException(throwable);
            }
            this.addColumn(string, expression);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public void addColumn(String string, Expression expression) {
        this.addColumn(string, ColumnFactory.getColumn(this, expression));
    }

    public void addConstantColumn(String string, Class clazz, Object object) {
        this.addColumn(string, ColumnFactory.getConstantColumn(clazz, object));
    }

    protected void addColumn(String string, Column column) {
        int n2 = this.getColumnNumber(string);
        if (n2 >= 0 && n2 < this.m_columns.size()) {
            throw new IllegalArgumentException("Table already has column with name \"" + string + "\"");
        }
        this.m_columns.add(column);
        this.m_names.add(string);
        this.m_lastCol = this.m_columns.size() - 1;
        ColumnEntry columnEntry = new ColumnEntry(this.m_lastCol, column, new ColumnMetadata(this, string));
        ColumnEntry columnEntry2 = this.m_entries.put(string, columnEntry);
        if (columnEntry2 != null) {
            columnEntry2.dispose();
        }
        this.invalidateSchema();
        column.addColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), this.m_lastCol, 1);
    }

    protected Column removeColumn(int n2) {
        if (n2 < 0 || n2 >= this.m_columns.size()) {
            throw new IllegalArgumentException("Column index is not legal.");
        }
        String string = (String)this.m_names.get(n2);
        ((ColumnEntry)this.m_entries.get(string)).dispose();
        Column column = (Column)this.m_columns.remove(n2);
        this.m_entries.remove(string);
        this.m_names.remove(n2);
        this.renumberColumns();
        this.m_lastCol = -1;
        this.invalidateSchema();
        column.removeColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), n2, -1);
        return column;
    }

    public Column removeColumn(String string) {
        int n2 = this.m_names.indexOf(string);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        return this.removeColumn(n2);
    }

    public void removeColumn(Column column) {
        int n2 = this.m_columns.indexOf(column);
        if (n2 < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        this.removeColumn(n2);
    }

    protected void renumberColumns() {
        Iterator iterator = this.m_names.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
            columnEntry.colnum = n2++;
        }
    }

    protected Iterator getColumns() {
        return this.m_columns.iterator();
    }

    protected Iterator getColumnNames() {
        return this.m_names.iterator();
    }

    public ColumnMetadata getMetadata(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        return columnEntry.metadata;
    }

    public Index index(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        if (columnEntry.index != null) {
            return columnEntry.index;
        }
        Column column = columnEntry.column;
        try {
            columnEntry.index = new TreeIndex(this, this.m_rows, column, null);
        }
        catch (IncompatibleComparatorException incompatibleComparatorException) {
            // empty catch block
        }
        return columnEntry.index;
    }

    public Index getIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        return columnEntry.index;
    }

    protected Index getIndex(String string, Class clazz, boolean bl) {
        if (!clazz.equals(this.getColumnType(string))) {
            throw new IllegalArgumentException("Column type does not match.");
        }
        if (this.getIndex(string) == null && bl) {
            this.index(string);
        }
        return this.getIndex(string);
    }

    public boolean removeIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        if (columnEntry.index == null) {
            return false;
        }
        columnEntry.index.dispose();
        columnEntry.index = null;
        return true;
    }

    public Tuple getTuple(int n2) {
        return this.m_tuples.getTuple(n2);
    }

    @Override
    public Tuple addTuple(Tuple tuple) {
        if (tuple.getTable() == this) {
            return null;
        }
        Schema schema = tuple.getSchema();
        if (this.getSchema().isAssignableFrom(schema)) {
            int n2 = this.addRow();
            for (int i2 = 0; i2 < schema.getColumnCount(); ++i2) {
                String string = schema.getColumnName(i2);
                this.set(n2, string, tuple.getValueAt(i2));
            }
            return this.getTuple(n2);
        }
        return null;
    }

    @Override
    public Tuple setTuple(Tuple tuple) {
        this.clear();
        return this.addTuple(tuple);
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        if (this.containsTuple(tuple)) {
            this.removeRow(tuple.getRow());
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        return tuple.getTable() == this && this.isValidRow(tuple.getRow());
    }

    @Override
    public int getTupleCount() {
        return this.getRowCount();
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    public boolean canGet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGet(clazz);
    }

    public boolean canSet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSet(clazz);
    }

    public Object get(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).get(n2);
    }

    public void set(int n2, String string, Object object) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).set(object, n2);
    }

    public Object getValueAt(int n2, int n3) {
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).get(n2);
    }

    public void setValueAt(int n2, int n3, Object object) {
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).set(object, n2);
    }

    public Object getDefault(String string) {
        int n2 = this.getColumnNumber(string);
        return this.getColumn(n2).getDefaultValue();
    }

    public void revertToDefault(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).revertToDefault(n2);
    }

    public final boolean canGetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetInt();
    }

    public final boolean canSetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetInt();
    }

    public final int getInt(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getInt(n2);
    }

    public final void setInt(int n2, String string, int n3) {
        int n4 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n4);
        this.getColumn(n4).setInt(n3, n2);
    }

    public final boolean canGetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetLong();
    }

    public final boolean canSetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetLong();
    }

    public final long getLong(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getLong(n2);
    }

    public final void setLong(int n2, String string, long l2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setLong(l2, n2);
    }

    public final boolean canGetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetFloat();
    }

    public final boolean canSetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetFloat();
    }

    public final float getFloat(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getFloat(n2);
    }

    public final void setFloat(int n2, String string, float f2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setFloat(f2, n2);
    }

    public final boolean canGetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDouble();
    }

    public final boolean canSetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDouble();
    }

    public final double getDouble(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDouble(n2);
    }

    public final void setDouble(int n2, String string, double d2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDouble(d2, n2);
    }

    public final boolean canGetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetBoolean();
    }

    public final boolean canSetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetBoolean();
    }

    public final boolean getBoolean(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getBoolean(n2);
    }

    public final void setBoolean(int n2, String string, boolean bl) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setBoolean(bl, n2);
    }

    public final boolean canGetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetString();
    }

    public final boolean canSetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetString();
    }

    public final String getString(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getString(n2);
    }

    public final void setString(int n2, String string, String string2) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setString(string2, n2);
    }

    public final boolean canGetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDate();
    }

    public final boolean canSetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDate();
    }

    public final Date getDate(int n2, String string) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        return this.getColumn(n3).getDate(n2);
    }

    public final void setDate(int n2, String string, Date date) {
        int n3 = this.getColumnNumber(string);
        n2 = this.getColumnRow(n2, n3);
        this.getColumn(n3).setDate(date, n2);
    }

    public TableIterator iterator() {
        return this.iterator(this.rows());
    }

    public TableIterator iterator(IntIterator intIterator) {
        return new TableIterator(this, intIterator);
    }

    @Override
    public Iterator tuples() {
        return this.m_tuples.iterator(this.rows());
    }

    public Iterator tuplesReversed() {
        return this.m_tuples.iterator(this.rows(true));
    }

    public Iterator tuples(IntIterator intIterator) {
        return this.m_tuples.iterator(intIterator);
    }

    public IntIterator rows() {
        return this.m_rows.rows();
    }

    public IntIterator rows(Predicate predicate) {
        return FilterIteratorFactory.rows(this, predicate);
    }

    public IntIterator rows(boolean bl) {
        return this.m_rows.rows(bl);
    }

    public IntIterator rowsSortedBy(String string, boolean bl) {
        Class clazz = this.getColumnType(string);
        Index index = this.getIndex(string, clazz, true);
        int n2 = bl ? 32 : 16;
        return index.allRows(n2);
    }

    public IntIterator rangeSortedBy(String string, int n2, int n3, int n4) {
        Index index = this.getIndex(string, Integer.TYPE, true);
        return index.rows(n2, n3, n4);
    }

    public IntIterator rangeSortedBy(String string, long l2, long l3, int n2) {
        Index index = this.getIndex(string, Long.TYPE, true);
        return index.rows(l2, l3, n2);
    }

    public IntIterator rangeSortedBy(String string, float f2, float f3, int n2) {
        Index index = this.getIndex(string, Float.TYPE, true);
        return index.rows(f2, f3, n2);
    }

    public IntIterator rangeSortedBy(String string, double d2, double d3, int n2) {
        Index index = this.getIndex(string, Double.TYPE, true);
        return index.rows(d2, d3, n2);
    }

    public IntIterator rangeSortedBy(String string, Object object, Object object2, int n2) {
        Class clazz = TypeLib.getSharedType(object, object2);
        if (clazz == null) {
            throw new IllegalArgumentException("Incompatible arguments");
        }
        Index index = this.getIndex(string, clazz, true);
        return index.rows(object, object2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, boolean bl) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, double d2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, float f2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, long l2) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, Object object) {
        this.handleColumnChanged(column, n2, n2);
    }

    @Override
    public void columnChanged(Column column, int n2, int n3, int n4) {
        this.handleColumnChanged(column, n3, n4);
    }

    protected void handleColumnChanged(Column column, int n2, int n3) {
        while (!this.isValidRow(n2) && n2 <= n3) {
            ++n2;
        }
        if (n2 > n3) {
            return;
        }
        int n4 = this.m_lastCol != -1 && column == this.getColumn(this.m_lastCol) ? this.m_lastCol : this.getColumnNumber(column);
        if (n4 >= 0) {
            this.fireTableEvent(n2, n3, n4, 0);
        }
    }

    public void addTableListener(TableListener tableListener) {
        if (!this.m_listeners.contains(tableListener)) {
            this.m_listeners.add(tableListener);
        }
    }

    public void removeTableListener(TableListener tableListener) {
        this.m_listeners.remove(tableListener);
    }

    protected void fireTableEvent(int n2, int n3, int n4, int n5) {
        ++this.m_modCount;
        if (n5 != 0 && n4 == -1) {
            this.fireTupleEvent(this, n2, n3, n5);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] objectArray = this.m_listeners.getArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((TableListener)objectArray[i2]).tableChanged(this, n2, n3, n4, n5);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Table[");
        stringBuffer.append("rows=").append(this.getRowCount());
        stringBuffer.append(", cols=").append(this.getColumnCount());
        stringBuffer.append(", maxrow=").append(this.m_rows.getMaximumRow());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static class ColumnEntry {
        public int colnum;
        public Column column;
        public ColumnMetadata metadata;
        public Index index;

        public ColumnEntry(int n2, Column column, ColumnMetadata columnMetadata) {
            this.colnum = n2;
            this.column = column;
            this.metadata = columnMetadata;
            this.index = null;
        }

        public void dispose() {
            if (this.metadata != null) {
                this.metadata.dispose();
            }
            if (this.index != null) {
                this.index.dispose();
            }
        }
    }
}

