/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.filter.CustomFilterEditor;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactoryManager;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.ObjectGrouperSupport;
import com.jidesoft.filter.ValueEditor;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.FilterEditor;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.StyledListCellRenderer;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.StyleRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableCustomFilterEditor
extends AbstractDialogPage
implements TableModelListener,
FilterEditor {
    private TableModel \u10e9;
    private TableModel \u10eb;
    protected CustomFilterEditor _editor;
    private FilterFactoryManager \u10e8;
    private JComboBox \u10ef;
    protected JList _list;
    private DefaultListModel \u10e5;
    protected JLabel _filtersLabel;
    protected JButton _replaceButton;
    protected JButton _removeButton;
    protected JButton _applyButton;
    protected JButton _addButton;
    protected JButton _clearButton;
    private Boolean \u10e6;
    private boolean \u10e3 = false;
    private boolean \u10ec = true;
    protected int _style = 0;
    public static final int STYLE_FILTER_LIST = 0;
    public static final int STYLE_INLINE_EDITOR = 1;
    private String[] \u10f1;
    private IFilterableTableModel \u10ee;
    protected List<FilterPanel> _filterPanels;
    private ActionListener \u10e4;
    private ActionListener \u10f0;
    protected JToggleButton _andButton;
    public final String PROPERTY_COLLAPSIBLE = "collapsible";
    public final String PROPERTY_COLLAPSED = "collapsed";
    public static final int BUTTON_ALL = 255;
    public static final int BUTTON_CLEAR_FILTER = 1;
    public static final int BUTTON_APPLY_FILTER = 2;
    public static final int BUTTON_COMPOUND_METHOD = 4;
    public static final int BUTTON_REMOVE_ITEM = 8;
    private int[] \u10ea = null;
    private int \u10ed = 255;
    private ObjectGrouper \u10e7;

    public TableCustomFilterEditor(TableModel tableModel) {
        this(tableModel, 0);
    }

    public TableCustomFilterEditor(TableModel tableModel, int n2) {
        this._style = n2;
        this.\u10e9 = tableModel;
        this.\u10e5 = new DefaultListModel();
        this.\u10e9.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            this.lazyInitialize();
        }
    }

    @Override
    public void lazyInitialize() {
        this.initComponents();
    }

    protected void initComponents() {
        this.removeAll();
        IFilterableTableModel.FilterItem[] filterItemArray = this.\u0215();
        boolean bl = this.\u10ee != null && this.\u10ee.isAndMode();
        this.\u10e8 = this.createFilterFactoryManager();
        this.\u10eb = this.\u10e9;
        this.\u0250();
        this.\u10ee = this.createFilterableTableModel(this.\u10e9);
        if (this.\u10e6 == null) {
            this.\u10e6 = this.\u10ee.isAndMode();
        } else {
            this.\u10ee.setAndMode(this.\u10e6);
        }
        this.\u10e5.clear();
        switch (this._style) {
            case 0: {
                this.setLayout(new BorderLayout(6, 6));
                this.add(this.\u0251(), "First");
                this.add(this.createListPanel());
                this.setFilterItems(filterItemArray);
                this.\u0216();
                this.doLayout();
                this.revalidate();
                this.repaint();
                break;
            }
            case 1: {
                this.setLayout(new GridLayout(0, 1, 6, 6));
                this.setFilterItems(filterItemArray);
            }
        }
    }

    private void \u0250() {
        int[] nArray = this.getColumnIndices();
        if (nArray == null) {
            this.\u10f1 = new String[this.\u10eb.getColumnCount()];
            for (int i2 = 0; i2 < this.\u10f1.length; ++i2) {
                this.\u10f1[i2] = this.getColumnName(this.\u10eb, i2);
            }
        } else {
            this.\u10f1 = new String[nArray.length];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                this.\u10f1[i3] = this.getColumnName(this.\u10eb, nArray[i3]);
            }
        }
    }

    private void \u0101(IFilterableTableModel.FilterItem[] filterItemArray) {
        if (this._filterPanels == null) {
            this._filterPanels = new ArrayList<FilterPanel>();
        } else {
            for (FilterPanel filterPanel : this._filterPanels) {
                this.remove(filterPanel);
            }
            this._filterPanels.clear();
        }
        int n2 = filterItemArray.length > 1 && this.isCollapsed() ? 1 : filterItemArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            IFilterableTableModel.FilterItem filterItem = filterItemArray[i2];
            this.add(this.createFilterItemPanel(filterItem, i2, n2));
        }
        if (filterItemArray.length == 0) {
            this.add(this.createFilterItemPanel(null, filterItemArray.length, 1));
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return new FilterableTableModel(tableModel);
    }

    @Override
    public Filter[] getFilters() {
        Filter[] filterArray = null;
        IFilterableTableModel.FilterItem[] filterItemArray = this.\u0215();
        if (filterItemArray != null) {
            filterArray = new Filter[filterItemArray.length];
            for (int i2 = 0; i2 < filterItemArray.length; ++i2) {
                filterArray[i2] = filterItemArray[i2].getFilter();
                if (filterArray[i2] instanceof ObjectGrouperSupport) {
                    ((ObjectGrouperSupport)((Object)filterArray[i2])).setObjectGrouper(this.getObjectGrouper());
                }
                if (!(filterArray[i2] instanceof NotFilter) || !(((NotFilter)filterArray[i2]).getFilter() instanceof ObjectGrouperSupport)) continue;
                ((ObjectGrouperSupport)((Object)((NotFilter)filterArray[i2]).getFilter())).setObjectGrouper(this.getObjectGrouper());
            }
        }
        return filterArray;
    }

    @Override
    public void setFilters(Filter[] filterArray) {
        this.\u10e5.removeAllElements();
        if (filterArray != null && filterArray.length > 0) {
            for (Filter filter : filterArray) {
                if (filter instanceof IFilterableTableModel.FilterItem) {
                    this.\u10e5.addElement(filter);
                    continue;
                }
                IFilterableTableModel.FilterItem filterItem = new IFilterableTableModel.FilterItem(filter);
                if (this.getColumnIndices() != null && this.getColumnIndices().length > 0) {
                    for (int n2 : this.getColumnIndices()) {
                        if (n2 < 0) continue;
                        filterItem.setColumn(n2);
                    }
                }
                this.\u10e5.addElement(filterItem);
            }
        }
    }

    @Deprecated
    public int[] getColumnIndex() {
        return this.\u10ea;
    }

    @Deprecated
    public void setColumnIndex(int[] nArray) {
        this.\u10ea = nArray;
        Object object = null;
        if (this.\u10ef != null) {
            object = this.\u10ef.getSelectedItem();
        }
        this.\u0250();
        if (this.\u10ef != null) {
            this.\u10ef.setModel(new DefaultComboBoxModel<String>(this.\u10f1));
            if (this.\u10f1.length >= 1) {
                if (object == null) {
                    this.\u10ef.setSelectedItem(this.\u10f1[0]);
                } else {
                    int n2;
                    for (n2 = 0; n2 < this.\u10f1.length && !JideSwingUtilities.equals(this.\u10f1[n2], object); ++n2) {
                    }
                    if (n2 >= this.\u10f1.length) {
                        this.\u10ef.setSelectedIndex(0);
                    } else {
                        this.\u10ef.setSelectedIndex(n2);
                    }
                }
                if (this._editor != null && this._editor.getParent() instanceof JPanel) {
                    this._editor = this.\u0101((String)this.\u10ef.getSelectedItem(), (JPanel)this._editor.getParent(), this.\u10ee, this._editor);
                }
            }
        }
        this.\u10ef.setEnabled(nArray == null || nArray.length > 1);
    }

    public int[] getColumnIndices() {
        return this.getColumnIndex();
    }

    public void setColumnIndices(int[] nArray) {
        this.setColumnIndex(nArray);
    }

    public int getVisibleButtons() {
        return this.\u10ed;
    }

    public void setVisibleButtons(int n2) {
        if (this.\u10ed != n2) {
            this.\u10ed = n2;
            this.initComponents();
        }
    }

    public ObjectGrouper getObjectGrouper() {
        return this.\u10e7;
    }

    @Override
    public void setObjectGrouper(ObjectGrouper objectGrouper) {
        this.\u10e7 = objectGrouper;
    }

    protected boolean shouldGoButtonBeVisible(int n2, int n3) {
        return n3 == 1 || n2 == n3 - 1 || this.isCollapsed() && n2 == 0;
    }

    protected boolean shouldClearButtonBeVisible(int n2, int n3) {
        return n3 == 1 || n2 == n3 - 1 || this.isCollapsed() && n2 == 0;
    }

    public boolean isCollapsible() {
        return this.\u10ec;
    }

    public void setCollapsible(boolean bl) {
        boolean bl2 = this.\u10ec;
        if (bl2 != bl) {
            this.\u10ec = bl;
            this.firePropertyChange("collapsible", bl2, bl);
            if (this._filterPanels.size() > 0) {
                FilterPanel filterPanel = this._filterPanels.get(0);
                filterPanel.updateCollapseButton();
            }
        }
    }

    public boolean isCollapsed() {
        return this.\u10e3;
    }

    public void setCollapsed(boolean bl) {
        boolean bl2;
        if (this.isCollapsible() && (bl2 = this.\u10e3) != bl) {
            this.\u10e3 = bl;
            this.firePropertyChange("collapsed", bl2, bl);
            int n2 = this._filterPanels.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FilterPanel filterPanel = this._filterPanels.get(i2);
                if (i2 != 0) {
                    filterPanel.setVisible(!bl);
                    if (bl) {
                        this.remove(filterPanel);
                    } else {
                        this.add(filterPanel);
                    }
                }
                filterPanel.updateIndex(i2, n2);
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    protected Component createFilterItemPanel(IFilterableTableModel.FilterItem filterItem, int n2, int n3) {
        FilterPanel filterPanel = new FilterPanel(filterItem, n2, n3);
        this._filterPanels.add(n2, filterPanel);
        return filterPanel;
    }

    private void \u0217() {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof FilterPanel)) continue;
            ((FilterPanel)component).updateIndex(i2, n2);
            ((FilterPanel)component).updateCollapseButton();
        }
    }

    public void saveFilterItems() {
        if (this._style == 1) {
            this.\u10e5.clear();
            int n2 = this._filterPanels.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FilterPanel filterPanel = this._filterPanels.get(i2);
                this.\u10e5.addElement(this.\u0101(filterPanel._comboBox, filterPanel._editor));
            }
        }
    }

    private Component \u0251() {
        final JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this.\u10ef = this.createColumnComboBox(this.\u10f1);
        JLabel jLabel = new JLabel(this.getResourceString("FilterEditor.column"));
        jLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.column.mnemonic").charAt(0));
        jPanel.add((Component)JideSwingUtilities.createTopPanel(JideSwingUtilities.createLabeledComponent(jLabel, this.\u10ef, "First")), "Before");
        this.\u10ef.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = "" + itemEvent.getItem();
                    TableCustomFilterEditor.this._editor = TableCustomFilterEditor.this.\u0101(string, jPanel, TableCustomFilterEditor.this.\u10ee, TableCustomFilterEditor.this._editor);
                }
            }
        });
        this._editor = this.\u0101("" + this.\u10ef.getSelectedItem(), jPanel, this.\u10ee, this._editor);
        ButtonPanel buttonPanel = new ButtonPanel(11);
        this._addButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.add")){
            private static final long \u0102 = 563125241570287601L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IFilterableTableModel.FilterItem filterItem = TableCustomFilterEditor.this.\u0101(TableCustomFilterEditor.this.\u10ef, TableCustomFilterEditor.this._editor);
                if (filterItem != null) {
                    TableCustomFilterEditor.this.\u10e5.addElement(filterItem);
                }
            }
        });
        this._addButton.setMnemonic(this.getResourceString("FilterEditor.add.mnemonic").charAt(0));
        this._replaceButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.replace")){
            private static final long \u0102 = -5580794636838313891L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IFilterableTableModel.FilterItem filterItem;
                int n2 = TableCustomFilterEditor.this._list.getSelectedIndex();
                if (n2 != -1 && (filterItem = TableCustomFilterEditor.this.\u0101(TableCustomFilterEditor.this.\u10ef, TableCustomFilterEditor.this._editor)) != null) {
                    TableCustomFilterEditor.this.\u10e5.set(n2, filterItem);
                }
            }
        });
        this._replaceButton.setMnemonic(this.getResourceString("FilterEditor.replace.mnemonic").charAt(0));
        this._replaceButton.setEnabled(false);
        buttonPanel.addButton(this._replaceButton);
        buttonPanel.addButton(this._addButton);
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    protected JComboBox createColumnComboBox(String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName("CompactField");
        SearchableUtils.installSearchable(jComboBox);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected FilterFactoryManager createFilterFactoryManager() {
        FilterFactoryManager filterFactoryManager = new FilterFactoryManager();
        filterFactoryManager.registerDefaultFilterFactories(this.getStyle() != 1);
        return filterFactoryManager;
    }

    protected String getColumnName(TableModel tableModel, int n2) {
        return tableModel.getColumnName(n2);
    }

    private CustomFilterEditor \u0101(String string, JPanel jPanel, IFilterableTableModel iFilterableTableModel, CustomFilterEditor customFilterEditor) {
        int n2 = this.\u0107(string);
        if (n2 != -1) {
            int n3 = -1;
            Component[] componentArray = jPanel.getComponents();
            int n4 = componentArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Component component = componentArray[i2];
                if (!(component instanceof CustomFilterEditor)) continue;
                jPanel.remove(component);
                n3 = i2;
                break;
            }
            if (n2 >= 0 && n2 < this.\u10eb.getColumnCount()) {
                Class<?> clazz = this.\u10eb.getColumnClass(n2);
                ConverterContext converterContext = this.\u10eb instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)this.\u10eb).getConverterContextAt(0, n2) : null;
                customFilterEditor = this.createCustomFilterEditor(this.\u10e8, clazz, converterContext, iFilterableTableModel.getPossibleValues(n2, ObjectComparatorManager.getComparator(this.\u10eb.getColumnClass(n2))));
                if (n3 == -1) {
                    jPanel.add(customFilterEditor);
                } else {
                    jPanel.add((Component)customFilterEditor, n3);
                }
            }
            jPanel.doLayout();
            jPanel.revalidate();
            jPanel.repaint();
            return customFilterEditor;
        }
        return null;
    }

    protected CustomFilterEditor createCustomFilterEditor(FilterFactoryManager filterFactoryManager, Class clazz, ConverterContext converterContext, Object[] objectArray) {
        CustomFilterEditor customFilterEditor = new CustomFilterEditor(filterFactoryManager, clazz, converterContext, objectArray){

            @Override
            protected ValueEditor createValueEditor(Class clazz, ConverterContext converterContext, Object[] objectArray) {
                return TableCustomFilterEditor.this.createValueEditor(clazz, converterContext, objectArray);
            }
        };
        customFilterEditor.setSingleLineMode(this._style == 1);
        return customFilterEditor;
    }

    protected ValueEditor createValueEditor(Class clazz, ConverterContext converterContext, Object[] objectArray) {
        return new ValueEditor(clazz, converterContext, objectArray);
    }

    protected Component createListPanel() {
        this._list = new JList(this.\u10e5);
        this._list.setCellRenderer(new StyledListCellRenderer(){

            @Override
            protected void customizeStyledLabel(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                if (object instanceof IFilterableTableModel.FilterItem) {
                    int n3;
                    IFilterableTableModel.FilterItem filterItem = (IFilterableTableModel.FilterItem)object;
                    this.clearStyleRanges();
                    String string = TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this.\u10eb, filterItem.getColumn());
                    String string2 = filterItem.getFilter().getName();
                    if (string2 == null) {
                        string2 = filterItem.getFilter().getClass().getSimpleName();
                    }
                    if ((n3 = string2.indexOf(" | ")) != -1) {
                        String string3 = string2.substring(0, n3);
                        this.addStyleRange(new StyleRange(string.length() + 1, string3.length(), 1));
                        this.setText(string + " " + string3 + " " + string2.substring(n3 + 3));
                    } else {
                        this.addStyleRange(new StyleRange(string.length() + 1, string2.length(), 1));
                        this.setText(string + " " + string2);
                    }
                } else {
                    super.customizeStyledLabel(jList, object, n2, bl, bl2);
                }
            }
        });
        this._list.setVisibleRowCount(4);
        ButtonPanel buttonPanel = new ButtonPanel(11);
        if ((4 & this.getVisibleButtons()) != 0) {
            this._andButton = new JToggleButton(this.getResourceString("FilterEditor.and.text"));
            this._andButton.addActionListener(new AbstractAction(){
                private static final long \u0102 = -7912967668407982207L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setAnd(!TableCustomFilterEditor.this.isAnd());
                    TableCustomFilterEditor.this.\u0216();
                }
            });
            buttonPanel.addButton((AbstractButton)this._andButton, "HELP");
        }
        if ((8 & this.getVisibleButtons()) != 0) {
            this._removeButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.remove")){
                private static final long \u0102 = -908045929494519071L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = TableCustomFilterEditor.this._list.getSelectedIndices();
                    for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                        int n2 = nArray[i2];
                        TableCustomFilterEditor.this.\u10e5.removeElementAt(n2);
                    }
                }
            });
            this._removeButton.setMnemonic(this.getResourceString("FilterEditor.remove.mnemonic").charAt(0));
            this._removeButton.setEnabled(false);
            buttonPanel.addButton(this._removeButton);
        }
        if ((1 & this.getVisibleButtons()) != 0) {
            this._clearButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.clear")){
                private static final long \u0102 = 4551449282917080305L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getClearFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._clearButton.setMnemonic(this.getResourceString("FilterEditor.clear.mnemonic").charAt(0));
            buttonPanel.addButton(this._clearButton);
        }
        if ((2 & this.getVisibleButtons()) != 0) {
            this._applyButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.apply")){
                private static final long \u0102 = 388509703998133194L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getApplyFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._applyButton.setMnemonic(this.getResourceString("FilterEditor.apply.mnemonic").charAt(0));
            buttonPanel.addButton(this._applyButton);
        }
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = TableCustomFilterEditor.this._list.getSelectedIndex();
                if ((8 & TableCustomFilterEditor.this.getVisibleButtons()) != 0) {
                    TableCustomFilterEditor.this._removeButton.setEnabled(n2 != -1);
                }
                if (n2 != -1) {
                    IFilterableTableModel.FilterItem filterItem = (IFilterableTableModel.FilterItem)TableCustomFilterEditor.this.\u10e5.getElementAt(n2);
                    TableCustomFilterEditor.this.\u10ef.setSelectedItem(TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this.\u10eb, filterItem.getColumn()));
                    TableCustomFilterEditor.this._editor.setFilter(filterItem.getFilter());
                }
                TableCustomFilterEditor.this._replaceButton.setEnabled(n2 != -1);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        this._filtersLabel = new JLabel(this.getResourceString("FilterEditor.filterList"));
        this._filtersLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.filterList.mnemonic").charAt(0));
        this._filtersLabel.setLabelFor(this._list);
        jPanel.add((Component)this._filtersLabel, "First");
        jPanel.add(new JScrollPane(this._list));
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    private void \u0216() {
        if (this._andButton != null) {
            if (this.isAnd()) {
                this._andButton.setText(this.getResourceString("FilterEditor.and.text"));
            } else {
                this._andButton.setText(this.getResourceString("FilterEditor.or.text"));
            }
        }
    }

    private IFilterableTableModel.FilterItem \u0101(JComboBox jComboBox, CustomFilterEditor customFilterEditor) {
        Filter filter;
        String string;
        int n2;
        if (jComboBox != null && (n2 = this.\u0107(string = "" + jComboBox.getSelectedItem())) != -1 && (filter = customFilterEditor.getFilter()) != null) {
            return new IFilterableTableModel.FilterItem(n2, filter);
        }
        return null;
    }

    private int \u0107(String string) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.\u10eb.getColumnCount(); ++i2) {
            if (!string.equals(this.getColumnName(this.\u10eb, i2))) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private IFilterableTableModel.FilterItem[] \u0215() {
        int n2 = this.\u10e5.size();
        IFilterableTableModel.FilterItem[] filterItemArray = new IFilterableTableModel.FilterItem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            filterItemArray[i2] = (IFilterableTableModel.FilterItem)this.\u10e5.getElementAt(i2);
        }
        return filterItemArray;
    }

    public IFilterableTableModel.FilterItem[] getFilterItems() {
        this.saveFilterItems();
        return this.\u0215();
    }

    public void setFilterItems(IFilterableTableModel.FilterItem[] filterItemArray) {
        this.\u10e5.clear();
        for (IFilterableTableModel.FilterItem filterItem : filterItemArray) {
            this.\u10e5.addElement(filterItem);
        }
        if (this.getStyle() == 1) {
            this.removeAll();
            this.\u0101(filterItemArray);
            this.\u0216();
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    public ListModel getFilterItemModel() {
        return this.\u10e5;
    }

    public IFilterableTableModel getFilterableTableModel() {
        return this.\u10ee;
    }

    public FilterFactoryManager getFilterFactoryManager() {
        return this.\u10e8;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.filter.filterEditor", this.getLocale()).getString(string);
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int n2) {
        if (this._style != n2) {
            this._style = n2;
            this.initComponents();
        }
    }

    public ActionListener getApplyFilterActionListener() {
        if (this.\u10e4 == null) {
            this.\u10e4 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.\u10ee.clearFilters();
                    TableCustomFilterEditor.this.saveFilterItems();
                    IFilterableTableModel.FilterItem[] filterItemArray = TableCustomFilterEditor.this.getFilterItems();
                    TableCustomFilterEditor.this.\u10ee.setAndMode(TableCustomFilterEditor.this.isAnd());
                    for (IFilterableTableModel.FilterItem filterItem : filterItemArray) {
                        if (filterItem == null || filterItem.getFilter() == null) continue;
                        TableCustomFilterEditor.this.\u10ee.addFilter(filterItem);
                    }
                    TableCustomFilterEditor.this.\u10ee.setFiltersApplied(true);
                }
            };
        }
        return this.\u10e4;
    }

    public void setApplyFilterActionListener(ActionListener actionListener) {
        this.\u10e4 = actionListener;
    }

    public ActionListener getClearFilterActionListener() {
        if (this.\u10f0 == null) {
            this.\u10f0 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.\u10ee.clearFilters();
                    TableCustomFilterEditor.this.\u10ee.setFiltersApplied(true);
                    TableCustomFilterEditor.this.initComponents();
                }
            };
        }
        return this.\u10f0;
    }

    public void setClearFilterActionListener(ActionListener actionListener) {
        this.\u10f0 = actionListener;
    }

    public boolean isAnd() {
        return this.\u10e6 == null || this.\u10e6 != false;
    }

    public void setAnd(boolean bl) {
        this.\u10e6 = bl;
        if (this._style == 0) {
            this.\u0216();
        } else if (this._style == 1) {
            for (FilterPanel filterPanel : this._filterPanels) {
                filterPanel.updateAndButton();
            }
        }
    }

    public class FilterPanel
    extends JPanel {
        public JComboBox _comboBox;
        public CustomFilterEditor _editor;
        public int _index;
        public int _total;
        public IFilterableTableModel.FilterItem _item;
        public JButton _goButton;
        public JButton _clearButton;
        public JButton _removeButton;
        public JButton _addButton;
        public JideButton _collapseButton;
        public JComboBox _andButton;
        public JLabel _filterLabel;
        private JPanel \u0101;

        public FilterPanel(IFilterableTableModel.FilterItem filterItem, int n2, int n3) {
            this._index = n2;
            this._item = filterItem;
            this._total = n3;
            this.setName("FilterItemPanel");
            this.setLayout(new JideBoxLayout(this, 0, 2));
            this.\u0103();
            if (filterItem != null) {
                this._editor.setFilter(filterItem.getFilter());
            }
        }

        private void \u0103() {
            this.\u0104();
            this.\u0101();
            this.\u0102();
            int n2 = this._andButton.getPreferredSize().width;
            int n3 = this._collapseButton.getPreferredSize().width + this._filterLabel.getPreferredSize().width + 4;
            this.\u0101 = new JPanel(new BorderLayout(4, 4));
            if (this._index == 0) {
                this.\u0101.add((Component)this._collapseButton, "Before");
                this.\u0101.add((Component)this._filterLabel, "Center");
                this.add((Component)this.\u0101, "fix");
            } else {
                this.add((Component)this._andButton, "fix");
                this._andButton.setEnabled(this._index == 1);
            }
            int n4 = n2 - n3;
            if (n4 > 0) {
                this.\u0101.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
            }
            this.updateAndButton();
            Dimension dimension = new Dimension(Math.max(n2, n3), this._andButton.getPreferredSize().height);
            this._andButton.setPreferredSize(dimension);
            this._andButton.setMinimumSize(dimension);
            this._andButton.setMaximumSize(dimension);
            this._comboBox = TableCustomFilterEditor.this.createColumnComboBox(TableCustomFilterEditor.this.\u10f1);
            if (this._item != null) {
                this._comboBox.setSelectedItem(TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this.\u10eb, this._item.getColumn()));
            }
            this.add(this._comboBox);
            this._comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        String string = "" + itemEvent.getItem();
                        FilterPanel.this._editor = TableCustomFilterEditor.this.\u0101(string, FilterPanel.this, TableCustomFilterEditor.this.\u10ee, null);
                        if (FilterPanel.this._item != null) {
                            FilterPanel.this._item.setColumn(FilterPanel.this._comboBox.getSelectedIndex());
                        }
                    }
                }
            });
            this._editor = TableCustomFilterEditor.this.\u0101("" + this._comboBox.getSelectedItem(), this, TableCustomFilterEditor.this.\u10ee, null);
            this._removeButton = new JButton(new AbstractAction(){
                private static final long \u0102 = -4217044571297871091L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setCollapsed(false);
                    Object object = actionEvent.getSource();
                    if (object instanceof Component) {
                        Container container = SwingUtilities.getAncestorOfClass(FilterPanel.class, (Component)object);
                        container.getParent().remove(container);
                        TableCustomFilterEditor.this._filterPanels.remove((FilterPanel)container);
                    }
                    TableCustomFilterEditor.this.\u10e5.removeElement(FilterPanel.this._item);
                    TableCustomFilterEditor.this.\u0217();
                    TableCustomFilterEditor.this.doLayout();
                    TableCustomFilterEditor.this.revalidate();
                    TableCustomFilterEditor.this.repaint();
                }
            });
            this.\u0101(this._removeButton);
            this._removeButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/remove.png"));
            this._removeButton.setDisabledIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/remove_disabled.png"));
            this._removeButton.setEnabled(this._total > 1);
            this._removeButton.setName("CompactButton");
            this.add(this._removeButton);
            this._addButton = new JButton(new AbstractAction(){
                private static final long \u0102 = 7039269938504847465L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setCollapsed(false);
                    TableCustomFilterEditor.this.\u10e5.add(FilterPanel.this._index, null);
                    TableCustomFilterEditor.this.add(TableCustomFilterEditor.this.createFilterItemPanel(null, FilterPanel.this._index + 1, FilterPanel.this.getComponentCount() + 1), FilterPanel.this._index + 1);
                    TableCustomFilterEditor.this.\u0217();
                    TableCustomFilterEditor.this.doLayout();
                    TableCustomFilterEditor.this.revalidate();
                    TableCustomFilterEditor.this.repaint();
                }
            });
            this.\u0101(this._addButton);
            this._addButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/add.png"));
            this._addButton.setDisabledIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/add_disabled.png"));
            this._addButton.setName("CompactButton");
            this.add(this._addButton);
            this._goButton = new JButton(new AbstractAction(TableCustomFilterEditor.this.getResourceString("FilterEditor.go")){
                private static final long \u0102 = -7519987690195292108L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getApplyFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._goButton.setMnemonic(TableCustomFilterEditor.this.getResourceString("FilterEditor.go.mnemonic").charAt(0));
            this._goButton.setName("CompactButton");
            this.add(this._goButton);
            this._goButton.setVisible(this._total == 1 || this._index == this._total - 1);
            if ((1 & TableCustomFilterEditor.this.getVisibleButtons()) != 0) {
                this._clearButton = new JButton(new AbstractAction(TableCustomFilterEditor.this.getResourceString("FilterEditor.clear")){
                    private static final long \u0102 = -8011863987580373543L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionListener actionListener = TableCustomFilterEditor.this.getClearFilterActionListener();
                        if (actionListener != null) {
                            actionListener.actionPerformed(actionEvent);
                        }
                    }
                });
                this._clearButton.setMnemonic(TableCustomFilterEditor.this.getResourceString("FilterEditor.clear.mnemonic").charAt(0));
                this._clearButton.setName("CompactButton");
                this.add(this._clearButton);
                this._clearButton.setVisible(this._total == 1 || this._index == this._total - 1);
            }
            this.add(Box.createGlue(), "vary");
        }

        private void \u0102() {
            if (this._filterLabel == null) {
                this._filterLabel = new JLabel(TableCustomFilterEditor.this.getResourceString("FilterEditor.filters"));
            }
        }

        private void \u0101(JButton jButton) {
            jButton.setHideActionText(true);
            jButton.setMargin(new Insets(3, 3, 1, 2));
        }

        public void updateAndButton() {
            if (this._andButton != null) {
                this._andButton.setSelectedIndex(TableCustomFilterEditor.this.isAnd() ? 0 : 1);
            }
        }

        private void \u0101() {
            if (this._andButton == null) {
                this._andButton = new JComboBox<Object>(new Object[]{TableCustomFilterEditor.this.getResourceString("FilterEditor.and.text"), TableCustomFilterEditor.this.getResourceString("FilterEditor.or.text")});
                this._andButton.setName("CompactField");
                this._andButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            TableCustomFilterEditor.this.setAnd(FilterPanel.this._andButton.getSelectedIndex() == 0);
                        }
                    }
                });
            }
        }

        public void updateIndex(int n2, int n3) {
            if (n2 != this._index || this._total != n3) {
                if (n2 == 0) {
                    if (this._andButton != null) {
                        this.remove(this._andButton);
                    }
                    if (this._collapseButton == null) {
                        this.\u0104();
                    }
                    if (this._filterLabel == null) {
                        this.\u0102();
                    }
                    this.\u0101.removeAll();
                    if (this._filterLabel.getParent() == null) {
                        this.\u0101.add((Component)this._filterLabel, "Center");
                    }
                    if (this._collapseButton.getParent() == null) {
                        this.\u0101.add((Component)this._collapseButton, "Before");
                    }
                    this.add(this.\u0101, "fix", 0);
                } else {
                    if (this.\u0101 != null) {
                        this.remove(this.\u0101);
                    }
                    if (this._andButton == null) {
                        this.\u0101();
                    }
                    if (this._andButton.getParent() == null) {
                        this.add(this._andButton, "fix", 0);
                    }
                    this._andButton.setEnabled(n2 == 1);
                }
                this._removeButton.setEnabled(n3 > 1);
            }
            this._goButton.setVisible(TableCustomFilterEditor.this.shouldGoButtonBeVisible(n2, n3));
            this._clearButton.setVisible(TableCustomFilterEditor.this.shouldClearButtonBeVisible(n2, n3));
            this._index = n2;
            this._total = n3;
        }

        private void \u0104() {
            if (this._collapseButton == null) {
                this._collapseButton = new JideButton(new AbstractAction(){
                    private static final long \u0102 = -4265129428753780124L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableCustomFilterEditor.this.setCollapsed(!TableCustomFilterEditor.this.isCollapsed());
                        FilterPanel.this.updateCollapseButton();
                    }
                });
                this.updateCollapseButton();
            }
        }

        public void updateCollapseButton() {
            if (this._collapseButton != null) {
                if (!TableCustomFilterEditor.this.isCollapsible()) {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/blank.png"));
                    this._collapseButton.setEnabled(false);
                } else if (TableCustomFilterEditor.this._filterPanels != null && TableCustomFilterEditor.this._filterPanels.size() <= 1) {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/blank.png"));
                    this._collapseButton.setEnabled(false);
                } else {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, TableCustomFilterEditor.this.isCollapsed() ? "icons/expand.png" : "icons/collapse.png"));
                    this._collapseButton.setEnabled(true);
                }
            }
        }
    }
}

